/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.filter.FIRFilter;
import marytts.signalproc.filter.FilterBankAnalyserBase;
import marytts.signalproc.filter.HighPassFilter;
import marytts.signalproc.filter.LowPassFilter;
import marytts.signalproc.filter.Subband;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.signal.SignalProcUtils;

public class FIRWaveletFilterBankAnalyser
extends FilterBankAnalyserBase {
    public FIRFilter[][] filters;
    public double[][] normalizationFilterTransformedIRs;
    public int numLevels;
    double samplingRateInHz;
    double[] samplingRates;

    public FIRWaveletFilterBankAnalyser(int numLevelsIn, double samplingRateInHzIn) {
        int i;
        this.numLevels = Math.max(0, numLevelsIn);
        this.samplingRateInHz = samplingRateInHzIn;
        this.samplingRates = new double[this.numLevels + 1];
        this.samplingRates[0] = 0.5 * this.samplingRateInHz;
        for (i = 1; i < this.numLevels; ++i) {
            this.samplingRates[i] = 0.5 * this.samplingRates[i - 1];
        }
        this.samplingRates[this.numLevels] = this.samplingRates[this.numLevels - 1];
        this.filters = new FIRFilter[this.numLevels][2];
        this.normalizationFilterTransformedIRs = new double[this.numLevels][];
        for (i = 0; i < this.numLevels; ++i) {
            int j;
            int filterOrder = SignalProcUtils.getFIRFilterOrder((int)this.samplingRates[i]);
            this.filters[i][0] = new LowPassFilter(0.25, filterOrder);
            this.filters[i][1] = new HighPassFilter(0.25, filterOrder);
            int maxFreq = this.filters[i][0].transformedIR.length / 2 + 1;
            this.normalizationFilterTransformedIRs[i] = new double[maxFreq];
            Arrays.fill(this.normalizationFilterTransformedIRs[i], 0.0);
            double[] dArray = this.normalizationFilterTransformedIRs[i];
            dArray[0] = dArray[0] + Math.abs(this.filters[i][0].transformedIR[0]);
            double[] dArray2 = this.normalizationFilterTransformedIRs[i];
            dArray2[0] = dArray2[0] + Math.abs(this.filters[i][1].transformedIR[0]);
            double[] dArray3 = this.normalizationFilterTransformedIRs[i];
            int n = maxFreq - 1;
            dArray3[n] = dArray3[n] + Math.abs(this.filters[i][0].transformedIR[1]);
            double[] dArray4 = this.normalizationFilterTransformedIRs[i];
            int n2 = maxFreq - 1;
            dArray4[n2] = dArray4[n2] + Math.abs(this.filters[i][1].transformedIR[1]);
            for (j = 1; j < maxFreq - 1; ++j) {
                double[] dArray5 = this.normalizationFilterTransformedIRs[i];
                int n3 = j;
                dArray5[n3] = dArray5[n3] + Math.sqrt(this.filters[i][0].transformedIR[2 * j] * this.filters[i][0].transformedIR[2 * j] + this.filters[i][0].transformedIR[2 * j + 1] * this.filters[i][0].transformedIR[2 * j + 1]);
                double[] dArray6 = this.normalizationFilterTransformedIRs[i];
                int n4 = j;
                dArray6[n4] = dArray6[n4] + Math.sqrt(this.filters[i][1].transformedIR[2 * j] * this.filters[i][1].transformedIR[2 * j] + this.filters[i][1].transformedIR[2 * j + 1] * this.filters[i][1].transformedIR[2 * j + 1]);
            }
            for (j = 0; j < maxFreq; ++j) {
                this.normalizationFilterTransformedIRs[i][j] = 1.0 / this.normalizationFilterTransformedIRs[i][j];
            }
        }
    }

    @Override
    public Subband[] apply(double[] x) {
        Subband[] subbands = null;
        if (this.filters != null && x != null && this.numLevels >= 0) {
            subbands = new Subband[this.numLevels + 1];
            double[] lowBand = null;
            double[] highBand = null;
            boolean count = false;
            for (int i = 0; i < this.numLevels; ++i) {
                if (i == 0) {
                    lowBand = this.filters[i][0].apply(x);
                    lowBand = SignalProcUtils.decimate(lowBand, 2.0);
                    highBand = this.filters[i][1].apply(x);
                    highBand = SignalProcUtils.decimate(highBand, 2.0);
                } else {
                    highBand = this.filters[i][1].apply(lowBand);
                    highBand = SignalProcUtils.decimate(highBand, 2.0);
                    lowBand = this.filters[i][0].apply(lowBand);
                    lowBand = SignalProcUtils.decimate(lowBand, 2.0);
                }
                subbands[i] = new Subband(highBand, this.samplingRates[i]);
            }
            subbands[this.numLevels] = new Subband(lowBand, this.samplingRates[this.numLevels]);
        }
        return subbands;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        int numLevels = 1;
        FIRWaveletFilterBankAnalyser analyser = new FIRWaveletFilterBankAnalyser(numLevels, samplingRate);
        Subband[] subbands = analyser.apply(x);
        for (int i = 0; i < subbands.length; ++i) {
            AudioFormat outputFormat = new AudioFormat((int)subbands[i].samplingRate, inputAudio.getFormat().getSampleSizeInBits(), inputAudio.getFormat().getChannels(), true, true);
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(subbands[i].waveform), outputFormat);
            String outFileName = args[0].substring(0, args[0].length() - 4) + "_band" + String.valueOf(i + 1) + ".wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        }
    }
}

