/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;

public class Chorus
implements InlineDataProcessor {
    private double[] buffIn;
    private double[] buffOut;
    private boolean[] bFirstInBuff;
    private int[] delays;
    private double[] amps;
    private int buffInStart;
    private int numChannels;
    private double sumAmps;

    public Chorus(int samplingRate) {
        this(null, null, samplingRate);
    }

    public Chorus(int[] delaysInMiliseconds, double[] ampsIn, int samplingRate) {
        boolean bDelete = false;
        if (delaysInMiliseconds == null) {
            bDelete = true;
            delaysInMiliseconds = new int[]{466, 600};
            ampsIn = new double[]{0.54, -0.1};
        }
        this.numChannels = Math.min(delaysInMiliseconds.length, ampsIn.length);
        if (this.numChannels > 0) {
            int i;
            this.delays = new int[this.numChannels];
            this.amps = new double[this.numChannels];
            this.bFirstInBuff = new boolean[this.numChannels];
            for (i = 0; i < this.numChannels; ++i) {
                this.delays[i] = (int)Math.floor((double)delaysInMiliseconds[i] / 1000.0 * (double)samplingRate + 0.5);
            }
            int buffInLen = this.delays[0];
            for (i = 0; i < this.numChannels; ++i) {
                if (buffInLen >= this.delays[i]) continue;
                buffInLen = this.delays[i];
            }
            if (buffInLen < 1) {
                buffInLen = 1;
            }
            this.buffIn = new double[buffInLen];
            for (i = 0; i < buffInLen; ++i) {
                this.buffIn[i] = 0.0;
            }
            this.buffOut = null;
            this.buffInStart = 1;
            for (i = 0; i < this.numChannels; ++i) {
                this.amps[i] = ampsIn[i];
            }
            this.sumAmps = 1.0;
            for (i = 0; i < this.numChannels; ++i) {
                this.sumAmps += this.amps[i];
            }
            for (i = 0; i < this.numChannels; ++i) {
                this.bFirstInBuff[i] = true;
            }
        } else {
            this.buffIn = null;
            this.buffOut = null;
            this.bFirstInBuff = null;
            this.delays = null;
            this.amps = null;
            this.buffInStart = 1;
            this.numChannels = 0;
            this.sumAmps = 1.0;
        }
        if (bDelete) {
            delaysInMiliseconds = null;
            ampsIn = null;
        }
    }

    @Override
    public void applyInline(double[] data, int pos, int buffOutLen) {
        if (buffOutLen != data.length) {
            buffOutLen = data.length;
        }
        if (buffOutLen > 0) {
            int i;
            if (this.buffOut == null || this.buffOut.length != buffOutLen) {
                this.buffOut = new double[buffOutLen];
            }
            for (i = 0; i < buffOutLen; ++i) {
                this.buffOut[i] = 0.0;
            }
            for (int j = 1; j <= buffOutLen; ++j) {
                this.buffIn[this.buffInStart - 1] = data[j - 1];
                for (i = 1; i <= this.numChannels; ++i) {
                    if (i == 1) {
                        this.buffOut[j - 1] = 1.0 / this.sumAmps * this.buffIn[this.buffInStart - 1];
                    }
                    int ind = this.buffInStart - this.delays[i - 1];
                    if (!this.bFirstInBuff[i - 1] && ind < 1) {
                        ind += this.buffIn.length;
                    }
                    if (this.buffInStart + 1 > this.buffIn.length) {
                        this.bFirstInBuff[i - 1] = false;
                    }
                    if (ind < 1) continue;
                    int n = j - 1;
                    this.buffOut[n] = this.buffOut[n] + this.amps[i - 1] / this.sumAmps * this.buffIn[ind - 1];
                }
                ++this.buffInStart;
                if (this.buffInStart <= this.buffIn.length) continue;
                this.buffInStart = 1;
            }
            for (i = 0; i < buffOutLen; ++i) {
                data[i] = this.buffOut[i];
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int[] delaysInMiliseconds = new int[]{366, 500};
        double[] amps = new double[]{0.54, -0.1};
        for (int i = 0; i < args.length; ++i) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
            FrameOverlapAddSource foas = new FrameOverlapAddSource(signal, 3, true, 1024, samplingRate, new Chorus(delaysInMiliseconds, amps, samplingRate));
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), inputAudio.getFormat());
            String outFileName = args[i].substring(0, args[i].length() - 4) + "_chorusAdded.wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        }
    }
}

