/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.modification;

import java.util.Arrays;
import marytts.signalproc.adaptation.prosody.BasicProsodyModifierParams;
import marytts.signalproc.analysis.RegularizedPostWarpedCepstrumEstimator;
import marytts.signalproc.analysis.RegularizedPreWarpedCepstrumEstimator;
import marytts.signalproc.process.TDPSOLAInstants;
import marytts.signalproc.process.TDPSOLAProcessor;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzer;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmPlusTransientsSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechFrame;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignalWithContext;
import marytts.signalproc.sinusoidal.hntm.analysis.TransientSegment;
import marytts.signalproc.sinusoidal.hntm.synthesis.NoisePartWaveformSynthesizer;
import marytts.signalproc.window.Window;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class HntmProsodyModifier {
    public static HntmSpeechSignalWithContext modify(HntmSpeechSignal hntmSignal, HntmSpeechFrame[] leftContexts, HntmSpeechFrame[] rightContexts, BasicProsodyModifierParams pmodParams, HntmAnalyzerParams analysisParams) {
        int j;
        float alpha;
        int scaleIndex;
        int i;
        int[] sortedIndices;
        HntmSpeechSignalWithContext output = null;
        if (!pmodParams.willProsodyBeModified()) {
            return new HntmSpeechSignalWithContext(hntmSignal, leftContexts, rightContexts);
        }
        if (pmodParams.tScalesTimes != null) {
            sortedIndices = MathUtils.quickSort(pmodParams.tScalesTimes);
            pmodParams.tScales = MathUtils.sortAs(pmodParams.tScales, sortedIndices);
        }
        float[] tScalesMod = new float[hntmSignal.frames.length + 1];
        float[] allScalesTimes = new float[hntmSignal.frames.length + 1];
        float[] pScalesMod = new float[hntmSignal.frames.length + 1];
        for (i = 0; i < hntmSignal.frames.length; ++i) {
            allScalesTimes[i] = hntmSignal.frames[i].tAnalysisInSeconds;
        }
        allScalesTimes[hntmSignal.frames.length] = hntmSignal.frames[hntmSignal.frames.length - 1].tAnalysisInSeconds + (hntmSignal.frames[hntmSignal.frames.length - 1].tAnalysisInSeconds - hntmSignal.frames[hntmSignal.frames.length - 2].tAnalysisInSeconds);
        if (pmodParams.tScalesTimes != null) {
            if (pmodParams.tScales.length != pmodParams.tScalesTimes.length) {
                System.out.println("Error! Time scale array and associated instants should be of identical length");
                return null;
            }
            for (i = 0; i < allScalesTimes.length; ++i) {
                scaleIndex = MathUtils.findClosest(pmodParams.tScalesTimes, allScalesTimes[i]);
                if (allScalesTimes[i] > pmodParams.tScalesTimes[scaleIndex]) {
                    if (scaleIndex < pmodParams.tScalesTimes.length - 1) {
                        alpha = (double)(pmodParams.tScalesTimes[scaleIndex + 1] - pmodParams.tScalesTimes[scaleIndex]) > 1.0E-10 ? (pmodParams.tScalesTimes[scaleIndex + 1] - allScalesTimes[i]) / (pmodParams.tScalesTimes[scaleIndex + 1] - pmodParams.tScalesTimes[scaleIndex]) : 0.5f;
                        tScalesMod[i] = alpha * pmodParams.tScales[scaleIndex] + (1.0f - alpha) * pmodParams.tScales[scaleIndex + 1];
                        continue;
                    }
                    tScalesMod[i] = pmodParams.tScales[scaleIndex];
                    continue;
                }
                if (allScalesTimes[i] < pmodParams.tScalesTimes[scaleIndex]) {
                    if (scaleIndex > 0) {
                        alpha = (double)(pmodParams.tScalesTimes[scaleIndex] - pmodParams.tScalesTimes[scaleIndex - 1]) > 1.0E-10 ? (pmodParams.tScalesTimes[scaleIndex] - allScalesTimes[i]) / (pmodParams.tScalesTimes[scaleIndex] - pmodParams.tScalesTimes[scaleIndex - 1]) : 0.5f;
                        tScalesMod[i] = alpha * pmodParams.tScales[scaleIndex - 1] + (1.0f - alpha) * pmodParams.tScales[scaleIndex];
                        continue;
                    }
                    tScalesMod[i] = pmodParams.tScales[scaleIndex];
                    continue;
                }
                tScalesMod[i] = pmodParams.tScales[scaleIndex];
            }
        } else {
            Arrays.fill(tScalesMod, pmodParams.tScales[0]);
        }
        if (pmodParams.pScalesTimes != null) {
            if (pmodParams.pScales.length != pmodParams.pScalesTimes.length) {
                System.out.println("Error! Pitch scale array and associated instants should be of identical length");
                return null;
            }
            for (i = 0; i < allScalesTimes.length; ++i) {
                scaleIndex = MathUtils.findClosest(pmodParams.pScalesTimes, allScalesTimes[i]);
                if (allScalesTimes[i] > pmodParams.pScalesTimes[scaleIndex]) {
                    if (scaleIndex < pmodParams.pScalesTimes.length - 1) {
                        alpha = (double)(pmodParams.pScalesTimes[scaleIndex + 1] - pmodParams.pScalesTimes[scaleIndex]) > 1.0E-10 ? (pmodParams.pScalesTimes[scaleIndex + 1] - allScalesTimes[i]) / (pmodParams.pScalesTimes[scaleIndex + 1] - pmodParams.pScalesTimes[scaleIndex]) : 0.5f;
                        pScalesMod[i] = alpha * pmodParams.pScales[scaleIndex] + (1.0f - alpha) * pmodParams.pScales[scaleIndex + 1];
                        continue;
                    }
                    pScalesMod[i] = pmodParams.pScales[scaleIndex];
                    continue;
                }
                if (allScalesTimes[i] < pmodParams.pScalesTimes[scaleIndex]) {
                    if (scaleIndex > 0) {
                        alpha = (double)(pmodParams.pScalesTimes[scaleIndex] - pmodParams.pScalesTimes[scaleIndex - 1]) > 1.0E-10 ? (pmodParams.pScalesTimes[scaleIndex] - allScalesTimes[i]) / (pmodParams.pScalesTimes[scaleIndex] - pmodParams.pScalesTimes[scaleIndex - 1]) : 0.5f;
                        pScalesMod[i] = alpha * pmodParams.pScales[scaleIndex - 1] + (1.0f - alpha) * pmodParams.pScales[scaleIndex];
                        continue;
                    }
                    pScalesMod[i] = pmodParams.pScales[scaleIndex];
                    continue;
                }
                pScalesMod[i] = pmodParams.pScales[scaleIndex];
            }
        } else {
            Arrays.fill(pScalesMod, pmodParams.pScales[0]);
        }
        if (hntmSignal instanceof HntmPlusTransientsSpeechSignal && ((HntmPlusTransientsSpeechSignal)hntmSignal).transients != null) {
            int numTransientSegments = ((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments.length;
            if (output == null) {
                output = new HntmSpeechSignalWithContext();
            }
            output.hntmSignal = new HntmPlusTransientsSpeechSignal(hntmSignal.frames.length, hntmSignal.samplingRateInHz, hntmSignal.originalDurationInSeconds, numTransientSegments);
            output.leftContexts = new HntmSpeechFrame[hntmSignal.frames.length];
            output.rightContexts = new HntmSpeechFrame[hntmSignal.frames.length];
            if (numTransientSegments > 0) {
                float[] tempScales = new float[4 * numTransientSegments];
                float[] tempScalesTimes = new float[4 * numTransientSegments];
                float[] tempScales2 = ArrayUtils.copy(tScalesMod);
                float[] tempScalesTimes2 = ArrayUtils.copy(allScalesTimes);
                boolean ind = false;
                for (i = 0; i < numTransientSegments; ++i) {
                    tempScalesTimes[2 * i] = ((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i].startTime;
                    tempScales[2 * i] = 1.0f;
                    tempScalesTimes[2 * i + 1] = ((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i].getEndTime(hntmSignal.samplingRateInHz);
                    tempScales[2 * i + 1] = 1.0f;
                    if (tempScalesTimes2 == null) continue;
                    for (j = 0; j < tempScalesTimes2.length; ++j) {
                        if (!(tempScalesTimes2[j] >= tempScalesTimes[2 * i]) || !(tempScalesTimes2[j] <= tempScalesTimes[2 * i + 1])) continue;
                        tempScales2[j] = 1.0f;
                    }
                }
                block7: for (i = numTransientSegments; i < 2 * numTransientSegments; ++i) {
                    tempScalesTimes[2 * i] = ((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i - numTransientSegments].startTime - 0.001f;
                    tempScales[2 * i] = 1.0f;
                    for (j = 0; j < allScalesTimes.length; ++j) {
                        if (!(tempScalesTimes[2 * i] > allScalesTimes[j])) continue;
                        tempScales[2 * i] = tScalesMod[j];
                        break;
                    }
                    tempScalesTimes[2 * i + 1] = ((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i - numTransientSegments].getEndTime(hntmSignal.samplingRateInHz) + 0.001f;
                    tempScales[2 * i + 1] = 1.0f;
                    for (j = allScalesTimes.length - 1; j >= 0; --j) {
                        if (!(tempScalesTimes[2 * i + 1] < allScalesTimes[j])) continue;
                        tempScales[2 * i + 1] = tScalesMod[j];
                        continue block7;
                    }
                }
                tScalesMod = ArrayUtils.combine(tempScales, tempScales2);
                allScalesTimes = ArrayUtils.combine(tempScalesTimes, tempScalesTimes2);
                sortedIndices = MathUtils.quickSort(allScalesTimes);
                tScalesMod = MathUtils.sortAs(tScalesMod, sortedIndices);
                for (i = 0; i < numTransientSegments; ++i) {
                    ((HntmPlusTransientsSpeechSignal)output.hntmSignal).transients.segments[i] = new TransientSegment(((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i]);
                    ((HntmPlusTransientsSpeechSignal)output.hntmSignal).transients.segments[i].startTime = SignalProcUtils.timeScaledTime(((HntmPlusTransientsSpeechSignal)hntmSignal).transients.segments[i].startTime, tScalesMod, allScalesTimes);
                }
            }
        } else {
            if (output == null) {
                output = new HntmSpeechSignalWithContext();
            }
            output.hntmSignal = new HntmSpeechSignal(hntmSignal.frames.length, hntmSignal.samplingRateInHz, hntmSignal.originalDurationInSeconds);
            output.leftContexts = new HntmSpeechFrame[hntmSignal.frames.length];
            output.rightContexts = new HntmSpeechFrame[hntmSignal.frames.length];
        }
        float[] tAnalysis = new float[hntmSignal.frames.length + 1];
        for (i = 0; i < hntmSignal.frames.length; ++i) {
            tAnalysis[i] = hntmSignal.frames[i].tAnalysisInSeconds;
        }
        tAnalysis[hntmSignal.frames.length] = hntmSignal.frames[hntmSignal.frames.length - 1].tAnalysisInSeconds + (hntmSignal.frames[hntmSignal.frames.length - 1].tAnalysisInSeconds - hntmSignal.frames[hntmSignal.frames.length - 2].tAnalysisInSeconds);
        boolean[] vuvs = new boolean[hntmSignal.frames.length + 1];
        for (i = 0; i < hntmSignal.frames.length; ++i) {
            vuvs[i] = (double)hntmSignal.frames[i].f0InHz > 10.0;
        }
        vuvs[hntmSignal.frames.length] = vuvs[hntmSignal.frames.length - 1];
        TDPSOLAInstants synthesisInstants = TDPSOLAProcessor.transformAnalysisInstants(tAnalysis, hntmSignal.samplingRateInHz, vuvs, tScalesMod, pScalesMod);
        if (output == null) {
            output = new HntmSpeechSignalWithContext();
        }
        output.hntmSignal = new HntmSpeechSignal(synthesisInstants.synthesisInstantsInSeconds.length, hntmSignal.samplingRateInHz, hntmSignal.originalDurationInSeconds);
        output.leftContexts = new HntmSpeechFrame[synthesisInstants.synthesisInstantsInSeconds.length];
        output.rightContexts = new HntmSpeechFrame[synthesisInstants.synthesisInstantsInSeconds.length];
        int currentSynthesisIndex = 0;
        boolean bBroke = false;
        for (i = 0; i < synthesisInstants.repeatSkipCounts.length; ++i) {
            for (j = 0; j <= synthesisInstants.repeatSkipCounts[i]; ++j) {
                if (i < hntmSignal.frames.length) {
                    output.hntmSignal.frames[currentSynthesisIndex] = new HntmSpeechFrame(hntmSignal.frames[i]);
                    if (leftContexts != null) {
                        output.leftContexts[currentSynthesisIndex] = new HntmSpeechFrame(leftContexts[i]);
                    }
                    if (rightContexts != null) {
                        output.rightContexts[currentSynthesisIndex] = new HntmSpeechFrame(rightContexts[i]);
                    }
                } else {
                    output.hntmSignal.frames[currentSynthesisIndex] = new HntmSpeechFrame(hntmSignal.frames[hntmSignal.frames.length - 1]);
                    if (leftContexts != null) {
                        output.leftContexts[currentSynthesisIndex] = new HntmSpeechFrame(leftContexts[hntmSignal.frames.length - 1]);
                    }
                    if (rightContexts != null) {
                        output.rightContexts[currentSynthesisIndex] = new HntmSpeechFrame(rightContexts[hntmSignal.frames.length - 1]);
                    }
                }
                output.hntmSignal.frames[currentSynthesisIndex].tAnalysisInSeconds = synthesisInstants.synthesisInstantsInSeconds[currentSynthesisIndex];
                if (++currentSynthesisIndex < output.hntmSignal.frames.length) continue;
                bBroke = true;
                break;
            }
            if (bBroke) break;
        }
        output.hntmSignal.originalDurationInSeconds = output.hntmSignal.frames[output.hntmSignal.frames.length - 1].tAnalysisInSeconds;
        if (analysisParams.noiseModel == 1 || analysisParams.noiseModel == 4 || analysisParams.noiseModel == 5) {
            double[] noisePartWaveform = NoisePartWaveformSynthesizer.synthesize(hntmSignal, leftContexts, rightContexts, analysisParams);
            int noiseWaveformLenMod = SignalProcUtils.time2sample(output.hntmSignal.originalDurationInSeconds, output.hntmSignal.samplingRateInHz);
            double[] noisePartWaveformMod = new double[noiseWaveformLenMod];
            double[] winWgtSum = new double[noiseWaveformLenMod];
            Arrays.fill(noisePartWaveformMod, 0.0);
            Arrays.fill(winWgtSum, 0.0);
            Window winNoise = null;
            double[] wgt = null;
            currentSynthesisIndex = 0;
            bBroke = false;
            boolean invert = false;
            for (i = 1; i < synthesisInstants.repeatSkipCounts.length - 1; ++i) {
                for (j = 0; j <= synthesisInstants.repeatSkipCounts[i]; ++j) {
                    int analysisStartInd;
                    int analysisEndInd = i < hntmSignal.frames.length - 1 ? SignalProcUtils.time2sample(hntmSignal.frames[i + 1].tAnalysisInSeconds, hntmSignal.samplingRateInHz) : noisePartWaveform.length - 1;
                    int wsNoise = analysisEndInd - (analysisStartInd = SignalProcUtils.time2sample(hntmSignal.frames[i - 1].tAnalysisInSeconds, hntmSignal.samplingRateInHz)) + 1;
                    if (wsNoise > 0) {
                        int kStart;
                        int halfWsNoise = (int)Math.floor(0.5 * (double)wsNoise + 0.5);
                        winNoise = Window.get(analysisParams.harmonicAnalysisWindowType, wsNoise);
                        wgt = winNoise.getCoeffs();
                        int synthesisMidInd = SignalProcUtils.time2sample(output.hntmSignal.frames[currentSynthesisIndex].tAnalysisInSeconds, output.hntmSignal.samplingRateInHz);
                        int synthesisStartInd = synthesisMidInd - halfWsNoise;
                        int synthesisEndInd = synthesisStartInd + wsNoise - 1;
                        for (int k = kStart = Math.max(0, synthesisStartInd); k <= Math.min(synthesisEndInd, noiseWaveformLenMod - 1); ++k) {
                            int kIndex = invert ? analysisEndInd - (k - kStart) : k - kStart + analysisStartInd;
                            int noisePartWaveformSize = noisePartWaveform.length;
                            try {
                                int n = k;
                                noisePartWaveformMod[n] = noisePartWaveformMod[n] + noisePartWaveform[kIndex] * wgt[k - kStart];
                                continue;
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                int n = k;
                                noisePartWaveformMod[n] = noisePartWaveformMod[n] + noisePartWaveform[kIndex - 1] * wgt[k - kStart];
                            }
                        }
                    }
                    boolean bl = invert = !invert;
                    if (++currentSynthesisIndex < output.hntmSignal.frames.length) continue;
                    bBroke = true;
                    break;
                }
                if (bBroke) break;
            }
            for (i = 0; i < winWgtSum.length; ++i) {
                if (!(winWgtSum[i] > 0.0)) continue;
                int n = i;
                noisePartWaveformMod[n] = noisePartWaveformMod[n] / winWgtSum[i];
            }
            HntmAnalyzer.packNoisePartWaveforms(output.hntmSignal, noisePartWaveformMod);
        }
        double[][] modifiedPhases = null;
        if (HntmAnalyzerParams.UNWRAP_PHASES_ALONG_HARMONICS_AFTER_TIME_SCALING) {
            modifiedPhases = HntmAnalyzer.unwrapPhasesAlongHarmonics(output.hntmSignal);
        }
        pmodParams = new BasicProsodyModifierParams(tScalesMod, allScalesTimes, pScalesMod, allScalesTimes);
        if (pmodParams.pScales != null) {
            float[] currentCeps = null;
            for (i = 0; i < output.hntmSignal.frames.length; ++i) {
                int pScaleInd;
                float pScale;
                int newTotalHarmonics;
                boolean isVoiced = false;
                if (output.hntmSignal.frames[i].h != null && output.hntmSignal.frames[i].h.complexAmps != null && output.hntmSignal.frames[i].h.complexAmps.length > 0) {
                    isVoiced = true;
                }
                if (!isVoiced) continue;
                if (!analysisParams.useHarmonicAmplitudesDirectly) {
                    currentCeps = output.hntmSignal.frames[i].h.getCeps(output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz, analysisParams);
                }
                if ((newTotalHarmonics = (int)Math.floor((double)((float)output.hntmSignal.frames[i].h.complexAmps.length / (pScale = pScalesMod[pScaleInd = MathUtils.findClosest(allScalesTimes, output.hntmSignal.frames[i].tAnalysisInSeconds)])) + 0.5)) > 0) {
                    int rightHarmonicInd;
                    int leftHarmonicInd;
                    int currentHarmonicNo;
                    int k;
                    float harmonicEnergyOrig = 0.0f;
                    double[] amps = new double[output.hntmSignal.frames[i].h.complexAmps.length];
                    for (k = 0; k < output.hntmSignal.frames[i].h.complexAmps.length; ++k) {
                        currentHarmonicNo = k + 1;
                        if (!analysisParams.useHarmonicAmplitudesDirectly) {
                            if (analysisParams.regularizedCepstrumWarpingMethod == 1) {
                                amps[k] = RegularizedPreWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)currentHarmonicNo * output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz);
                            } else if (analysisParams.regularizedCepstrumWarpingMethod == 2) {
                                amps[k] = RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)currentHarmonicNo * output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz);
                            }
                        } else {
                            leftHarmonicInd = (int)Math.floor((float)currentHarmonicNo * pScale) - 1;
                            amps[k] = leftHarmonicInd < 0 ? MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[0]) : ((rightHarmonicInd = leftHarmonicInd + 1) > output.hntmSignal.frames[i].h.complexAmps.length - 1 ? MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[output.hntmSignal.frames[i].h.complexAmps.length - 1]) : MathUtils.interpolatedSample((float)(leftHarmonicInd + 1) * output.hntmSignal.frames[i].f0InHz, (float)currentHarmonicNo * pScale * output.hntmSignal.frames[i].f0InHz, (float)(rightHarmonicInd + 1) * output.hntmSignal.frames[i].f0InHz, MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[leftHarmonicInd]), MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[rightHarmonicInd])));
                        }
                        harmonicEnergyOrig = (float)((double)harmonicEnergyOrig + amps[k] * amps[k]);
                    }
                    output.hntmSignal.frames[i].h.complexAmps = MathUtils.interpolate(output.hntmSignal.frames[i].h.complexAmps, newTotalHarmonics);
                    output.hntmSignal.frames[i].f0InHz *= pScale;
                    double[] linearAmps = new double[newTotalHarmonics];
                    double[] freqsInHz = new double[newTotalHarmonics];
                    float harmonicEnergyMod = 0.0f;
                    double[] ampsMod = new double[newTotalHarmonics];
                    if (!analysisParams.useHarmonicAmplitudesDirectly) {
                        currentCeps = output.hntmSignal.frames[i].h.getCeps(output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz, analysisParams);
                    }
                    for (k = 0; k < newTotalHarmonics; ++k) {
                        currentHarmonicNo = k + 1;
                        if (!analysisParams.useHarmonicAmplitudesDirectly) {
                            if (analysisParams.regularizedCepstrumWarpingMethod == 1) {
                                ampsMod[k] = RegularizedPreWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)currentHarmonicNo * output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz);
                            } else if (analysisParams.regularizedCepstrumWarpingMethod == 2) {
                                ampsMod[k] = RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)currentHarmonicNo * output.hntmSignal.frames[i].f0InHz, output.hntmSignal.samplingRateInHz);
                            }
                        } else {
                            leftHarmonicInd = (int)Math.floor((float)currentHarmonicNo * pScale) - 1;
                            ampsMod[k] = leftHarmonicInd < 0 ? MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[0]) : ((rightHarmonicInd = leftHarmonicInd + 1) > output.hntmSignal.frames[i].h.complexAmps.length - 1 ? MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[output.hntmSignal.frames[i].h.complexAmps.length - 1]) : MathUtils.interpolatedSample((float)(leftHarmonicInd + 1) * output.hntmSignal.frames[i].f0InHz, (float)currentHarmonicNo * pScale * output.hntmSignal.frames[i].f0InHz, (float)(rightHarmonicInd + 1) * output.hntmSignal.frames[i].f0InHz, MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[leftHarmonicInd]), MathUtils.magnitudeComplex(output.hntmSignal.frames[i].h.complexAmps[rightHarmonicInd])));
                        }
                        harmonicEnergyMod = (float)((double)harmonicEnergyMod + ampsMod[k] * ampsMod[k]);
                        linearAmps[k] = ampsMod[k];
                        freqsInHz[k] = (float)currentHarmonicNo * output.hntmSignal.frames[i].f0InHz;
                    }
                    continue;
                }
                output.hntmSignal.frames[i].h.complexAmps = null;
            }
            if (HntmAnalyzerParams.UNWRAP_PHASES_ALONG_HARMONICS_AFTER_PITCH_SCALING) {
                HntmAnalyzer.unwrapPhasesAlongHarmonics(output.hntmSignal);
            }
        }
        return output;
    }
}

