/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.test;

import java.io.IOException;
import java.util.Arrays;
import marytts.signalproc.sinusoidal.test.BaseTester;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class NoiseTester
extends BaseTester {
    public static final float DEFAULT_TRANSITION_BANDWIDTH_IN_HZ = 50.0f;
    public static final double FIXED_F0_NOISE = 100.0;

    public NoiseTester() {
        this(0.0f, 0.5f * (float)DEFAULT_FS);
    }

    public NoiseTester(float freqStartInHz, float freqEndInHz) {
        this(freqStartInHz, freqEndInHz, DEFAULT_AMP);
    }

    public NoiseTester(float freqStartInHz, float freqEndInHz, float amp) {
        this(freqStartInHz, freqEndInHz, amp, DEFAULT_DUR);
    }

    public NoiseTester(float freqStartInHz, float freqEndInHz, float amp, float durationInSeconds) {
        this(freqStartInHz, freqEndInHz, amp, durationInSeconds, DEFAULT_FS);
    }

    public NoiseTester(float freqStartInHz, float freqEndInHz, float amp, float durationInSeconds, int samplingRateInHz) {
        float[][] freqs = new float[1][];
        float[] amps = new float[1];
        freqs[0] = new float[2];
        freqs[0][0] = freqStartInHz;
        freqs[0][1] = freqEndInHz;
        amps[0] = amp;
        this.fs = samplingRateInHz;
        this.checkFreqs(freqs);
        this.init(freqs, amps, durationInSeconds, samplingRateInHz);
    }

    public NoiseTester(float[][] freqs) {
        this.init(freqs);
    }

    public NoiseTester(float[][] freqs, float durationInSeconds) {
        this.init(freqs, durationInSeconds);
    }

    public NoiseTester(float[][] freqs, float[] amps) {
        this.init(freqs, amps);
    }

    public NoiseTester(float[][] freqs, float[] amps, float durationInSeconds) {
        this.init(freqs, amps, durationInSeconds);
    }

    public NoiseTester(float[][] freqs, float[] amps, float startTimeInSeconds, float endTimeInSeconds) {
        this(freqs, amps, startTimeInSeconds, endTimeInSeconds, DEFAULT_FS);
    }

    public NoiseTester(float[][] freqs, float[] amps, float durationInSeconds, int samplingRateInHz) {
        this.init(freqs, amps, durationInSeconds, samplingRateInHz);
    }

    public NoiseTester(float[][] freqs, float[] amps, float startTimeInSeconds, float endTimeInSeconds, int samplingRateInHz) {
        float[] startTimesInSeconds = new float[freqs.length];
        float[] endTimesInSeconds = new float[freqs.length];
        Arrays.fill(startTimesInSeconds, startTimeInSeconds);
        Arrays.fill(endTimesInSeconds, endTimeInSeconds);
        this.init(freqs, amps, startTimesInSeconds, endTimesInSeconds, samplingRateInHz);
    }

    public NoiseTester(float[][] freqs, float[] amps, float[] startTimesInSeconds, float[] endTimesInSeconds, int samplingRateInHz) {
        this.init(freqs, amps, startTimesInSeconds, endTimesInSeconds, samplingRateInHz);
    }

    public void checkFreqs(float[][] freqs) {
        if (freqs != null) {
            float maxFreq = 0.5f * (float)this.fs;
            for (int i = 0; i < freqs.length; ++i) {
                for (int j = 0; j < 2; ++j) {
                    if (freqs[i][j] < 0.0f) {
                        freqs[i][j] = 0.0f;
                    }
                    if (!(freqs[i][j] > maxFreq)) continue;
                    freqs[i][j] = maxFreq;
                }
                if (!(freqs[i][0] > freqs[i][1])) continue;
                float tmp = freqs[i][0];
                freqs[i][0] = freqs[i][1];
                freqs[i][1] = tmp;
            }
        }
    }

    public void init(float[][] freqs) {
        float[] amps = new float[freqs.length];
        for (int i = 0; i < amps.length; ++i) {
            amps[i] = DEFAULT_AMP;
        }
        this.init(freqs, amps);
    }

    public void init(float[][] freqs, float durationInSeconds) {
        float[] amps = new float[freqs.length];
        for (int i = 0; i < amps.length; ++i) {
            amps[i] = DEFAULT_AMP;
        }
        this.init(freqs, amps, durationInSeconds);
    }

    public void init(float[][] freqs, float[] amps) {
        this.init(freqs, amps, DEFAULT_DUR);
    }

    public void init(float[][] freqs, float[] amps, float durationInSeconds) {
        this.init(freqs, amps, durationInSeconds, DEFAULT_FS);
    }

    public void init(float[][] freqs, float[] amps, float durationInSeconds, int samplingRateInHz) {
        if (freqs != null && freqs.length > 0) {
            float[] startTimesInSeconds = new float[freqs.length];
            float[] endTimesInSeconds = new float[freqs.length];
            for (int i = 0; i < freqs.length; ++i) {
                startTimesInSeconds[i] = 0.0f;
                endTimesInSeconds[i] = durationInSeconds;
            }
            this.init(freqs, amps, startTimesInSeconds, endTimesInSeconds, samplingRateInHz);
        }
    }

    public void init(float[][] freqs, float[] amps, float[] startTimesInSeconds, float[] endTimesInSeconds, int samplingRateInHz) {
        this.fs = samplingRateInHz;
        this.signal = null;
        this.pitchMarks = null;
        if (freqs != null && freqs.length > 0) {
            int i;
            assert (amps.length == freqs.length);
            assert (startTimesInSeconds.length == freqs.length);
            assert (startTimesInSeconds.length == endTimesInSeconds.length);
            for (i = 0; i < freqs.length; ++i) {
                assert (freqs[i].length >= 2);
            }
            int[] startSampleIndices = new int[freqs.length];
            int[] endSampleIndices = new int[freqs.length];
            for (i = 0; i < startTimesInSeconds.length; ++i) {
                if (startTimesInSeconds[i] < 0.0f) {
                    startTimesInSeconds[i] = 0.0f;
                }
                if (endTimesInSeconds[i] < 0.0f) {
                    endTimesInSeconds[i] = 0.0f;
                }
                if (startTimesInSeconds[i] > endTimesInSeconds[i]) {
                    startTimesInSeconds[i] = endTimesInSeconds[i];
                }
                startSampleIndices[i] = (int)Math.floor((double)(startTimesInSeconds[i] * (float)this.fs) + 0.5);
                endSampleIndices[i] = (int)Math.floor((double)(endTimesInSeconds[i] * (float)this.fs) + 0.5) - 1;
            }
            int minStartSampleIndex = 0;
            int maxEndSampleIndex = MathUtils.getMax(endSampleIndices);
            int maxT0 = SignalProcUtils.time2sample(0.01, this.fs);
            int numPitchMarks = (int)Math.floor((double)(maxEndSampleIndex - minStartSampleIndex + 1) / (double)maxT0 + 0.5) + 1;
            this.pitchMarks = new int[numPitchMarks];
            for (i = 0; i < numPitchMarks; ++i) {
                this.pitchMarks[i] = Math.min(i * maxT0 + minStartSampleIndex, maxEndSampleIndex);
            }
            float lastTime = SignalProcUtils.sample2time(this.pitchMarks[this.pitchMarks.length - 1], this.fs);
            int numfrm = (int)Math.floor(((double)lastTime - 0.5 * (double)this.ws) / (double)this.ss + 0.5);
            this.f0s = new double[numfrm];
            Arrays.fill(this.f0s, 100.0);
            if (maxEndSampleIndex > 0) {
                this.signal = new double[maxEndSampleIndex + 1];
                Arrays.fill(this.signal, 0.0);
                for (i = 0; i < freqs.length; ++i) {
                    double[] noise = SignalProcUtils.getNoise(freqs[i][0], freqs[i][1], 50.0, this.fs, endSampleIndices[i] - startSampleIndices[i] + 1);
                    for (int j = startSampleIndices[i]; j < endSampleIndices[i]; ++j) {
                        int n = j;
                        this.signal[n] = this.signal[n] + (double)(2.0f * amps[i]) * noise[j - startSampleIndices[i]];
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        NoiseTester t = null;
        int numTracks = 1;
        float[][] freqs = new float[numTracks][];
        for (int i = 0; i < numTracks; ++i) {
            freqs[i] = new float[2];
        }
        freqs[0][0] = 2000.0f;
        freqs[0][1] = 4000.0f;
        float durationInSeconds = 1.0f;
        t = new NoiseTester((float[][])freqs, durationInSeconds);
        if (args.length > 1) {
            t.write(args[0], args[1]);
        } else {
            t.write(args[0]);
        }
    }
}

