/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.install;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class LicenseRegistry {
    private static Map<URL, String> remote2local = null;

    public static URL getLicense(URL licenseURL) {
        long startT = System.currentTimeMillis();
        if (remote2local == null) {
            LicenseRegistry.loadLocalLicenses();
        }
        assert (remote2local != null);
        if (!remote2local.containsKey(licenseURL)) {
            LicenseRegistry.downloadLicense(licenseURL);
        }
        String localFilename = remote2local.get(licenseURL);
        File downloadDir = new File(System.getProperty("mary.downloadDir", "."));
        File localFile = new File(downloadDir, localFilename);
        try {
            URL localURL = localFile.toURI().toURL();
            System.out.println("Lookup took " + (System.currentTimeMillis() - startT) + " ms");
            return localURL;
        }
        catch (MalformedURLException e) {
            System.err.println("Cannot create URL from local file " + localFile.getAbsolutePath());
            e.printStackTrace();
            return null;
        }
    }

    private static void loadLocalLicenses() {
        remote2local = new HashMap<URL, String>();
        File downloadDir = new File(System.getProperty("mary.downloadDir", "."));
        File licenseIndexFile = new File(downloadDir, "license-index.txt");
        if (!licenseIndexFile.canRead()) {
            return;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(licenseIndexFile), "UTF-8"));
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line = line.trim(), "|");
                if (!st.hasMoreTokens()) continue;
                String localFilename = st.nextToken().trim();
                if (!st.hasMoreTokens()) continue;
                String remoteURLString = st.nextToken().trim();
                File localLicenseFile = new File(downloadDir, localFilename);
                if (!localLicenseFile.canRead()) {
                    System.err.println("License index file " + licenseIndexFile.getAbsolutePath() + " refers to license file " + localLicenseFile.getAbsolutePath() + ", but that file cannot be read. Skipping.");
                    continue;
                }
                URL remoteURL = new URL(remoteURLString);
                remote2local.put(remoteURL, localFilename);
            }
            br.close();
        }
        catch (IOException e) {
            System.err.println("Problem reading local license index file " + licenseIndexFile.getAbsolutePath() + ":");
            e.printStackTrace();
        }
    }

    private static void downloadLicense(URL licenseURL) {
        assert (remote2local != null);
        File downloadDir = new File(System.getProperty("mary.downloadDir", "."));
        String filename = licenseURL.toString().replace('/', '_').replace(':', '_');
        File licenseFile = new File(downloadDir, filename);
        System.out.println("Downloading license from " + licenseURL.toString());
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(licenseFile));
            BufferedInputStream in = new BufferedInputStream(licenseURL.openStream());
            byte[] buf = new byte[4096];
            int n = -1;
            while ((n = in.read(buf)) >= 0) {
                out.write(buf, 0, n);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            System.err.println("Cannot download license from " + licenseURL.toString());
            e.printStackTrace();
        }
        remote2local.put(licenseURL, filename);
        LicenseRegistry.saveIndex();
    }

    private static void saveIndex() {
        assert (remote2local != null);
        File downloadDir = new File(System.getProperty("mary.downloadDir", "."));
        File licenseIndexFile = new File(downloadDir, "license-index.txt");
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(licenseIndexFile), "UTF-8"));
            for (URL remote : remote2local.keySet()) {
                pw.println(remote2local.get(remote) + "|" + remote.toString());
            }
            pw.close();
        }
        catch (IOException e) {
            System.err.println("Problem updating the index file " + licenseIndexFile.getAbsolutePath());
            e.printStackTrace();
        }
    }
}

