/*
 * Decompiled with CFR 0.152.
 */
package marytts.vocalizations;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.SynthesisException;
import marytts.signalproc.adaptation.prosody.BasicProsodyModifierParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizedSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizer;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.unitselection.data.TimelineReader;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.Datagram;
import marytts.util.data.DatagramDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;
import marytts.util.math.Polynomial;
import marytts.vocalizations.HNMFeatureFileReader;
import marytts.vocalizations.VocalizationIntonationReader;
import marytts.vocalizations.VocalizationSynthesisTechnology;
import marytts.vocalizations.VocalizationUnit;
import marytts.vocalizations.VocalizationUnitFileReader;

public class HNMSynthesisTechnology
extends VocalizationSynthesisTechnology {
    protected HNMFeatureFileReader vHNMFeaturesReader;
    protected VocalizationIntonationReader vIntonationReader;
    protected HntmAnalyzerParams analysisParams;
    protected HntmSynthesizerParams synthesisParams;
    protected TimelineReader audioTimeline;
    protected VocalizationUnitFileReader unitFileReader;
    protected boolean f0ContourImposeSupport;

    public HNMSynthesisTechnology(String waveTimeLineFile, String unitFile, String hnmFeatureFile, String intonationFeatureFile, boolean imposeF0Support) throws MaryConfigurationException {
        try {
            this.audioTimeline = new TimelineReader(waveTimeLineFile);
            this.unitFileReader = new VocalizationUnitFileReader(unitFile);
            this.f0ContourImposeSupport = imposeF0Support;
            this.vHNMFeaturesReader = new HNMFeatureFileReader(hnmFeatureFile);
            this.vIntonationReader = this.f0ContourImposeSupport ? new VocalizationIntonationReader(intonationFeatureFile) : null;
        }
        catch (IOException e) {
            throw new MaryConfigurationException("Can not read data from files " + e);
        }
        this.initializeParameters();
    }

    public HNMSynthesisTechnology(TimelineReader audioTimeline, VocalizationUnitFileReader unitFileReader, HNMFeatureFileReader vHNMFeaturesReader, VocalizationIntonationReader vIntonationReader, boolean imposeF0Support) {
        this.audioTimeline = audioTimeline;
        this.unitFileReader = unitFileReader;
        this.vHNMFeaturesReader = vHNMFeaturesReader;
        this.vIntonationReader = vIntonationReader;
        this.f0ContourImposeSupport = imposeF0Support;
        this.initializeParameters();
    }

    private void initializeParameters() {
        this.analysisParams = new HntmAnalyzerParams();
        this.analysisParams.harmonicModel = 1;
        this.analysisParams.noiseModel = 1;
        this.analysisParams.useHarmonicAmplitudesDirectly = true;
        this.analysisParams.harmonicSynthesisMethodBeforeNoiseAnalysis = 1;
        this.analysisParams.regularizedCepstrumWarpingMethod = 2;
        this.synthesisParams = new HntmSynthesizerParams();
        this.synthesisParams.harmonicPartSynthesisMethod = 1;
        this.synthesisParams.overlappingHarmonicPartSynthesis = false;
        this.synthesisParams.harmonicSynthesisOverlapInSeconds = 0.01f;
        this.synthesisParams.writeHarmonicPartToSeparateFile = false;
        this.synthesisParams.writeNoisePartToSeparateFile = false;
        this.synthesisParams.writeTransientPartToSeparateFile = false;
        this.synthesisParams.writeOriginalMinusHarmonicPartToSeparateFile = false;
    }

    @Override
    public AudioInputStream synthesize(int backchannelNumber, AudioFileFormat aft) throws SynthesisException {
        int numberOfBackChannels = this.unitFileReader.getNumberOfUnits();
        if (backchannelNumber >= numberOfBackChannels) {
            throw new IllegalArgumentException("This voice has " + numberOfBackChannels + " backchannels only. so it doesn't support unit number " + backchannelNumber);
        }
        VocalizationUnit bUnit = this.unitFileReader.getUnit(backchannelNumber);
        long start = bUnit.startTime;
        int duration = bUnit.duration;
        Datagram[] frames = null;
        try {
            frames = this.audioTimeline.getDatagrams(start, (long)duration);
        }
        catch (IOException e) {
            throw new SynthesisException("Can not read data from timeline file " + e);
        }
        LinkedList<Datagram> datagrams = new LinkedList<Datagram>();
        datagrams.addAll(Arrays.asList(frames));
        DatagramDoubleDataSource audioSource = new DatagramDoubleDataSource(datagrams);
        return new DDSAudioInputStream(new BufferedDoubleDataSource(audioSource), aft.getFormat());
    }

    @Override
    public AudioInputStream reSynthesize(int backchannelNumber, AudioFileFormat aft) throws SynthesisException {
        float[] pScalesArray = new float[]{1.0f};
        float[] tScalesArray = new float[]{1.0f};
        float[] tScalesTimes = new float[]{1.0f};
        float[] pScalesTimes = new float[]{1.0f};
        return this.synthesizeUsingF0Modification(backchannelNumber, pScalesArray, pScalesTimes, tScalesArray, tScalesTimes, aft);
    }

    @Override
    public AudioInputStream synthesizeUsingImposedF0(int sourceIndex, int targetIndex, AudioFileFormat aft) throws SynthesisException {
        if (!this.f0ContourImposeSupport) {
            throw new SynthesisException("Mary configuration of this voice doesn't support intonation contour imposition");
        }
        int numberOfUnits = this.vHNMFeaturesReader.getNumberOfUnits();
        if (sourceIndex >= numberOfUnits || targetIndex >= numberOfUnits) {
            throw new IllegalArgumentException("sourceIndex(" + sourceIndex + ") and targetIndex(" + targetIndex + ") are should be less than number of available units (" + numberOfUnits + ")");
        }
        double[] sourceF0 = this.vIntonationReader.getContour(sourceIndex);
        double[] targetF0coeffs = this.vIntonationReader.getIntonationCoeffs(targetIndex);
        double[] sourceF0coeffs = this.vIntonationReader.getIntonationCoeffs(sourceIndex);
        if (targetF0coeffs == null || sourceF0coeffs == null) {
            return this.reSynthesize(sourceIndex, aft);
        }
        if (targetF0coeffs.length == 0 || sourceF0coeffs.length == 0) {
            return this.reSynthesize(sourceIndex, aft);
        }
        double[] targetF0 = Polynomial.generatePolynomialValues(targetF0coeffs, sourceF0.length, 0.0, 1.0);
        sourceF0 = Polynomial.generatePolynomialValues(sourceF0coeffs, sourceF0.length, 0.0, 1.0);
        assert (targetF0.length == sourceF0.length);
        float[] tScalesArray = new float[]{1.0f};
        float[] tScalesTimes = new float[]{1.0f};
        float[] pScalesArray = new float[targetF0.length];
        float[] pScalesTimes = new float[targetF0.length];
        double skipSizeInSeconds = this.vIntonationReader.getSkipSizeInSeconds();
        double windowSizeInSeconds = this.vIntonationReader.getWindowSizeInSeconds();
        for (int i = 0; i < targetF0.length; ++i) {
            pScalesArray[i] = (float)(targetF0[i] / sourceF0[i]);
            pScalesTimes[i] = (float)((double)i * skipSizeInSeconds + 0.5 * windowSizeInSeconds);
        }
        return this.synthesizeUsingF0Modification(sourceIndex, pScalesArray, pScalesTimes, tScalesArray, tScalesTimes, aft);
    }

    private AudioInputStream synthesizeUsingF0Modification(int backchannelNumber, float[] pScalesArray, float[] pScalesTimes, float[] tScalesArray, float[] tScalesTimes, AudioFileFormat aft) throws SynthesisException {
        AudioFormat af;
        if (backchannelNumber > this.vHNMFeaturesReader.getNumberOfUnits()) {
            throw new IllegalArgumentException("requesting unit should not be more than number of units");
        }
        if (!this.f0ContourImposeSupport) {
            throw new SynthesisException("Mary configuration of this voice doesn't support intonation contour imposition");
        }
        BasicProsodyModifierParams pmodParams = new BasicProsodyModifierParams(tScalesArray, tScalesTimes, pScalesArray, pScalesTimes);
        HntmSpeechSignal hnmSignal = this.vHNMFeaturesReader.getHntmSpeechSignal(backchannelNumber);
        HntmSynthesizer hs = new HntmSynthesizer();
        HntmSynthesizedSignal xhat = hs.synthesize(hnmSignal, null, null, pmodParams, null, this.analysisParams, this.synthesisParams);
        if (aft == null) {
            float sampleRate = 16000.0f;
            int sampleSizeInBits = 16;
            int channels = 1;
            boolean signed = true;
            boolean bigEndian = false;
            af = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        } else {
            af = aft.getFormat();
        }
        double[] audio_double = xhat.output;
        double MaxSample = MathUtils.getAbsMax(audio_double);
        for (int i = 0; i < audio_double.length; ++i) {
            audio_double[i] = 0.3 * (audio_double[i] / MaxSample);
        }
        DDSAudioInputStream oais = new DDSAudioInputStream(new BufferedDoubleDataSource(audio_double), af);
        return oais;
    }
}

