/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.TrainingParameters;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenNameFinderTrainerTool
implements CmdLineTool {
    @Override
    public String getName() {
        return "TokenNameFinderTrainer";
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable name finder";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + TrainingParameters.getParameterUsage() + " -data trainingData -model model\n" + TrainingParameters.getDescription();
    }

    static ObjectStream<NameSample> openSampleData(String sampleDataName, File sampleDataFile, Charset encoding) {
        CmdLineUtil.checkInputFile(sampleDataName + " Data", sampleDataFile);
        FileInputStream sampleDataIn = CmdLineUtil.openInFile(sampleDataFile);
        PlainTextByLineStream lineStream = new PlainTextByLineStream(sampleDataIn.getChannel(), encoding);
        return new NameSampleDataStream(lineStream);
    }

    @Override
    public void run(String[] args) {
        TokenNameFinderModel model;
        if (args.length < 8) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        TrainingParameters parameters = new TrainingParameters(args);
        if (!parameters.isValid()) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        File trainingDataInFile = new File(CmdLineUtil.getParameter("-data", args));
        File modelOutFile = new File(CmdLineUtil.getParameter("-model", args));
        CmdLineUtil.checkOutputFile("name finder model", modelOutFile);
        ObjectStream<NameSample> sampleStream = TokenNameFinderTrainerTool.openSampleData("Training", trainingDataInFile, parameters.getEncoding());
        try {
            model = NameFinderME.train(parameters.getLanguage(), parameters.getType(), sampleStream, Collections.<String, Object>emptyMap(), parameters.getNumberOfIterations(), parameters.getCutoff());
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        CmdLineUtil.writeModel("name finder", modelOutFile, model);
    }
}

