/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.formats.LeipzigDoccatSampleStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeipzigDocumentSampleStreamFactory
implements ObjectStreamFactory<DocumentSample> {
    @Override
    public String getUsage() {
        return ArgumentParser.createUsage(Parameters.class);
    }

    @Override
    public boolean validateArguments(String[] args) {
        return ArgumentParser.validateArguments(args, Parameters.class);
    }

    @Override
    public ObjectStream<DocumentSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        try {
            return new LeipzigDoccatSampleStream(params.getLang(), 20, CmdLineUtil.openInFile(new File(params.getData())));
        }
        catch (IOException e) {
            System.err.println("Cannot open sample data: " + e.getMessage());
            throw new TerminateToolException(-1);
        }
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="cat|de|dk|ee|en|fi|fr|it|jp|kr|nl|no|se|sorb|tr")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="sampleData")
        public String getData();
    }
}

