/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.loganalysis;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.BooleanArrayDataRow;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.ListDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.math.matrix.ExtendedSparseMatrix;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagLogReader
extends Operator {
    public TagLogReader(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        String tag;
        int minOccurrences = this.getParameterAsInt("min_occurrences");
        ExtendedSparseMatrix<String, Integer> matrix = new ExtendedSparseMatrix<String, Integer>();
        try {
            BufferedReader inTas = new BufferedReader(new FileReader(this.getParameterAsFile("tag_logfile")));
            String buf = null;
            while ((buf = inTas.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(buf, "\t");
                tokens.nextToken();
                tag = tokens.nextToken();
                try {
                    Integer id = Integer.parseInt(tokens.nextToken());
                    matrix.incEntry(tag, id, 1.0);
                }
                catch (NumberFormatException id) {
                    // empty catch block
                }
            }
            inTas.close();
        }
        catch (FileNotFoundException inTas) {
        }
        catch (IOException inTas) {
            // empty catch block
        }
        HashMap<String, Attribute> tagAttributeMap = new HashMap<String, Attribute>();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Iterator it = matrix.getXLabels();
        while (it.hasNext()) {
            tag = (String)it.next();
            if (matrix.getNumYEntries(tag) <= minOccurrences) continue;
            Attribute att = AttributeFactory.createAttribute((String)tag, (int)6);
            att.getMapping().mapString("false");
            att.getMapping().mapString("true");
            attributes.add(att);
            tagAttributeMap.put(tag, att);
        }
        MemoryExampleTable et = new MemoryExampleTable(attributes);
        ArrayList<BooleanArrayDataRow> dataRows = new ArrayList<BooleanArrayDataRow>();
        Iterator it2 = matrix.getYLabels();
        while (it2.hasNext()) {
            Integer id = (Integer)it2.next();
            BooleanArrayDataRow d = new BooleanArrayDataRow(new boolean[attributes.size()]);
            Iterator it22 = matrix.getXEntries(id);
            while (it22.hasNext()) {
                String tag2 = (String)it22.next();
                Attribute att = (Attribute)tagAttributeMap.get(tag2);
                if (att == null) continue;
                d.set(att, (double)att.getMapping().getPositiveIndex());
            }
            dataRows.add(d);
        }
        et.readExamples((DataRowReader)new ListDataRowReader(dataRows.iterator()));
        ExampleSet examples = et.createExampleSet();
        return new IOObject[]{examples};
    }

    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeFile logFile = new ParameterTypeFile("tag_logfile", "the tag log file", "txt", false);
        logFile.setExpert(false);
        types.add(logFile);
        ParameterTypeInt minOccurrences = new ParameterTypeInt("min_occurrences", "minimal number of occurrences of a tag to be considered", 1, Integer.MAX_VALUE, 100);
        logFile.setExpert(false);
        types.add(minOccurrences);
        return types;
    }
}

