/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.relp;

import com.sun.speech.freetts.FreeTTSSpeakable;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.relp.FloatList;
import com.sun.speech.freetts.util.Utilities;
import com.sun.speech.freetts.util.WaveUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import javax.sound.sampled.AudioFormat;

public class LPCResult {
    private static final double POST_EMPHASIS = 0.0;
    private int frameSize = 10;
    private int numberOfFrames = 0;
    private short[][] frames = null;
    private int[] times = null;
    private int[] sizes = null;
    private byte[] residuals = null;
    private int numberOfChannels;
    private int sampleRate;
    private int residualFold = 1;
    private float lpcMinimum;
    private float lpcRange;
    private static final int MAX_SAMPLE_SIZE = Utilities.getInteger("com.sun.speech.freetts.LpcResult.maxSamples", 1024);
    private static final float[] residualToFloatMap = new float[256];

    public void resizeFrames(int numberOfFrames) {
        this.times = new int[numberOfFrames];
        this.frames = new short[numberOfFrames][];
        this.sizes = new int[numberOfFrames];
        this.numberOfFrames = numberOfFrames;
    }

    public void resizeResiduals(int numberOfSamples) {
        this.residuals = new byte[numberOfSamples];
    }

    public void setValues(int numberOfChannels, int sampleRate, int residualFold, float lpcMin, float lpcRange) {
        this.numberOfChannels = numberOfChannels;
        this.sampleRate = sampleRate;
        this.lpcMinimum = lpcMin;
        this.lpcRange = lpcRange;
    }

    public int getFrameShift(int frameIndex) {
        if (0 <= frameIndex && frameIndex < this.times.length) {
            if (frameIndex > 0) {
                return this.times[frameIndex] - this.times[frameIndex - 1];
            }
            return this.times[frameIndex];
        }
        return 0;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public short[] getFrame(int index) {
        return this.frames[index];
    }

    public int[] getTimes() {
        return this.times;
    }

    public int getNumberOfFrames() {
        return this.numberOfFrames;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public float getLPCMin() {
        return this.lpcMinimum;
    }

    public float getLPCRange() {
        return this.lpcRange;
    }

    public int getNumberOfSamples() {
        if (this.residuals == null) {
            return 0;
        }
        return this.residuals.length;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int[] getResidualSizes() {
        return this.sizes;
    }

    public byte[] getResiduals() {
        return this.residuals;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public void setNumberOfFrames(int numberFrames) {
        this.numberOfFrames = numberFrames;
    }

    public void setFrame(int index, short[] newFrames) {
        this.frames[index] = newFrames;
    }

    public void setTimes(int[] times) {
        this.times = times;
    }

    public void setNumberOfChannels(int numberOfChannels) {
        this.numberOfChannels = numberOfChannels;
    }

    public void setLPCMin(float min) {
        this.lpcMinimum = min;
    }

    public void setLPCRange(float range) {
        this.lpcRange = range;
    }

    public void setSampleRate(int rate) {
        this.sampleRate = rate;
    }

    public void setResidualSizes(int[] sizes) {
        for (int i = 0; i < this.sizes.length && i < sizes.length; ++i) {
            this.sizes[i] = sizes[i];
        }
    }

    public void copyResiduals(byte[] source, int targetPosition, int targetSize) {
        int unitSize = source.length;
        if (unitSize < targetSize) {
            int targetStart = (targetSize - unitSize) / 2;
            System.arraycopy(source, 0, this.residuals, targetPosition + targetStart, source.length);
        } else {
            int sourcePosition = (unitSize - targetSize) / 2;
            System.arraycopy(source, sourcePosition, this.residuals, targetPosition, targetSize);
        }
    }

    public void copyResidualsPulse(byte[] source, int targetPosition, int targetSize) {
        int unitSize = source.length;
        short sample = (short)(source[0] + 128);
        if (unitSize < targetSize) {
            this.residuals[(targetSize - unitSize) / 2] = WaveUtils.shortToUlaw(sample);
        } else {
            this.residuals[(unitSize - targetSize) / 2] = WaveUtils.shortToUlaw(sample);
        }
    }

    private static final byte hibyte(int val) {
        return (byte)(val >>> 8);
    }

    private static final byte lobyte(int val) {
        return (byte)(val & 0xFF);
    }

    public boolean playWave(AudioPlayer player, Utterance utterance) {
        return this.playWaveSamples(player, utterance.getSpeakable(), this.getNumberOfSamples() * 2);
    }

    public byte[] getWaveSamples() {
        return this.getWaveSamples(2 * this.getNumberOfSamples(), null);
    }

    private byte[] getWaveSamples(int numberSamples, Utterance utterance) {
        int numberChannels = this.getNumberOfChannels();
        float pp = 0.0f;
        byte[] samples = new byte[numberSamples];
        byte[] residuals = this.getResiduals();
        int[] residualSizes = this.getResidualSizes();
        FloatList outBuffer = FloatList.createList(numberChannels + 1);
        FloatList lpcCoefficients = FloatList.createList(numberChannels);
        double multiplier = (double)this.getLPCRange() / 65535.0;
        int s = 0;
        boolean firstPlay = true;
        int r = 0;
        for (int i = 0; i < this.numberOfFrames; ++i) {
            short[] frame = this.getFrame(i);
            FloatList lpcCoeffs = lpcCoefficients;
            for (int k = 0; k < numberChannels; ++k) {
                lpcCoeffs.value = (float)(((double)frame[k] + 32768.0) * multiplier) + this.lpcMinimum;
                lpcCoeffs = lpcCoeffs.next;
            }
            int pmSizeSamples = residualSizes[i];
            int j = 0;
            while (j < pmSizeSamples) {
                FloatList backBuffer = outBuffer.prev;
                float ob = residualToFloatMap[residuals[r] + 128];
                lpcCoeffs = lpcCoefficients;
                do {
                    ob += lpcCoeffs.value * backBuffer.value;
                    backBuffer = backBuffer.prev;
                } while ((lpcCoeffs = lpcCoeffs.next) != lpcCoefficients);
                int sample = (int)((double)ob + (double)pp * 0.0);
                samples[s++] = LPCResult.hibyte(sample);
                samples[s++] = LPCResult.lobyte(sample);
                outBuffer.value = pp = ob;
                outBuffer = outBuffer.next;
                ++j;
                ++r;
            }
        }
        return samples;
    }

    private boolean playWaveSamples(AudioPlayer player, FreeTTSSpeakable speakable, int numberSamples) {
        boolean ok = true;
        int numberChannels = this.getNumberOfChannels();
        float pp = 0.0f;
        byte[] samples = new byte[MAX_SAMPLE_SIZE];
        byte[] residuals = this.getResiduals();
        int[] residualSizes = this.getResidualSizes();
        FloatList outBuffer = FloatList.createList(numberChannels + 1);
        FloatList lpcCoefficients = FloatList.createList(numberChannels);
        double multiplier = (double)this.getLPCRange() / 65535.0;
        int s = 0;
        boolean firstPlay = true;
        player.begin(numberSamples);
        int r = 0;
        for (int i = 0; (ok &= !speakable.isCompleted()) && i < this.numberOfFrames; ++i) {
            short[] frame = this.getFrame(i);
            FloatList lpcCoeffs = lpcCoefficients;
            for (int k = 0; k < numberChannels; ++k) {
                lpcCoeffs.value = (float)(((double)frame[k] + 32768.0) * multiplier) + this.lpcMinimum;
                lpcCoeffs = lpcCoeffs.next;
            }
            int pmSizeSamples = residualSizes[i];
            int j = 0;
            while (j < pmSizeSamples) {
                FloatList backBuffer = outBuffer.prev;
                float ob = residualToFloatMap[residuals[r] + 128];
                lpcCoeffs = lpcCoefficients;
                do {
                    ob += lpcCoeffs.value * backBuffer.value;
                    backBuffer = backBuffer.prev;
                } while ((lpcCoeffs = lpcCoeffs.next) != lpcCoefficients);
                int sample = (int)((double)ob + (double)pp * 0.0);
                samples[s++] = LPCResult.hibyte(sample);
                samples[s++] = LPCResult.lobyte(sample);
                if (s >= MAX_SAMPLE_SIZE) {
                    if ((ok &= !speakable.isCompleted()) && !player.write(samples)) {
                        ok = false;
                    }
                    s = 0;
                }
                outBuffer.value = pp = ob;
                outBuffer = outBuffer.next;
                ++j;
                ++r;
            }
        }
        if ((ok &= !speakable.isCompleted()) && s > 0) {
            ok = player.write(samples, 0, s);
            s = 0;
        }
        if (ok &= !speakable.isCompleted()) {
            ok = player.end();
        }
        return ok;
    }

    public void dump() {
        this.dump(new OutputStreamWriter(System.out));
    }

    public void dump(Writer writer) {
        int i;
        DecimalFormat numberFormat = new DecimalFormat();
        numberFormat.setMaximumFractionDigits(6);
        numberFormat.setMinimumFractionDigits(6);
        PrintWriter pw = new PrintWriter(new BufferedWriter(writer));
        if (this.getNumberOfFrames() == 0) {
            pw.println("# ========== LPCResult ==========");
            pw.println("# Num_of_Frames: " + this.getNumberOfFrames());
            pw.flush();
            return;
        }
        pw.println("========== LPCResult ==========");
        pw.println("Num_of_Frames: " + this.getNumberOfFrames());
        pw.println("Num_of_Channels: " + this.getNumberOfChannels());
        pw.println("Num_of_Samples: " + this.getNumberOfSamples());
        pw.println("Sample_Rate: " + this.sampleRate);
        pw.println("LPC_Minimum: " + numberFormat.format(this.lpcMinimum));
        pw.println("LPC_Range: " + numberFormat.format(this.lpcRange));
        pw.println("Residual_Fold: " + this.residualFold);
        pw.println("Post_Emphasis: " + numberFormat.format(0.0));
        pw.print("Times:\n");
        for (i = 0; i < this.getNumberOfFrames(); ++i) {
            pw.print(this.times[i] + " ");
        }
        pw.print("\nFrames: ");
        for (i = 0; i < this.getNumberOfFrames(); ++i) {
            short[] frame = this.getFrame(i);
            for (int j = 0; j < frame.length; ++j) {
                pw.print(frame[j] + 32768 + "\n");
            }
        }
        pw.print("\nSizes: ");
        for (i = 0; i < this.getNumberOfFrames(); ++i) {
            pw.print(this.sizes[i] + " ");
        }
        pw.print("\nResiduals: ");
        for (i = 0; i < this.getNumberOfSamples(); ++i) {
            if (this.residuals[i] == 0) {
                pw.print(255);
            } else {
                pw.print(this.residuals[i] + 128);
            }
            pw.print("\n");
            pw.flush();
        }
        pw.flush();
    }

    public void dumpASCII() {
        this.dumpASCII(new OutputStreamWriter(System.out));
    }

    public void dumpASCII(String path) throws IOException {
        FileWriter writer = new FileWriter(path, true);
        this.getWave().dump(writer);
    }

    private Wave getWave() {
        AudioFormat audioFormat = new AudioFormat(this.getSampleRate(), 16, 1, true, true);
        return new Wave(audioFormat, this.getWaveSamples(this.getNumberOfSamples() * 2, null));
    }

    public void dumpASCII(Writer writer) {
        Wave wave = this.getWave();
        wave.dump(writer);
    }

    static {
        for (short i = 0; i < residualToFloatMap.length; i = (short)(i + 1)) {
            LPCResult.residualToFloatMap[i] = WaveUtils.ulawToShort(i);
        }
        LPCResult.residualToFloatMap[128] = WaveUtils.ulawToShort((short)255);
    }

    private static class Wave {
        public static final int DEFAULT_SAMPLE_SIZE_IN_BITS = 16;
        public static final boolean DEFAULT_SIGNED = true;
        public static final boolean DEFAULT_BIG_ENDIAN = false;
        private byte[] samples = null;
        private AudioFormat audioFormat = null;

        Wave(AudioFormat audioFormat, byte[] samples) {
            this.audioFormat = audioFormat;
            this.samples = samples;
        }

        public void dump(Writer writer) {
            PrintWriter pw = new PrintWriter(new BufferedWriter(writer));
            pw.println("#========== Wave ==========");
            pw.println("#Type: NULL");
            pw.println("#Sample_Rate: " + (int)this.audioFormat.getSampleRate());
            pw.println("#Num_of_Samples: " + this.samples.length / 2);
            pw.println("#Num_of_Channels: " + this.audioFormat.getChannels());
            if (this.samples != null) {
                for (int i = 0; i < this.samples.length; i += 2) {
                    pw.println(WaveUtils.bytesToShort(this.samples[i], this.samples[i + 1]));
                }
            }
            pw.flush();
        }
    }
}

