/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Scanner;
import marytts.features.FeatureDefinition;
import marytts.unitselection.select.Target;

public class SoP {
    private double[] coeffs;
    private String[] factors;
    private int[] factorsIndex;
    boolean interceptTerm;
    double correlation;
    double rmse;
    double solution;
    FeatureDefinition featureDefinition = null;

    public void setCorrelation(double val) {
        this.correlation = val;
    }

    public void setRMSE(double val) {
        this.rmse = val;
    }

    public double[] getCoeffs() {
        return this.coeffs;
    }

    public double getCorrelation() {
        return this.correlation;
    }

    public double getRMSE() {
        return this.rmse;
    }

    public int[] getFactorsIndex() {
        return this.factorsIndex;
    }

    public SoP() {
    }

    public SoP(FeatureDefinition featDef) {
        this.featureDefinition = featDef;
    }

    public void setCoeffsAndFactors(double[] coeffsVal, int[] selectedFactorsIndex, String[] allFactorsList, boolean b0) throws Exception {
        if (this.featureDefinition == null) {
            throw new Exception("FeatureDefinition not defined in SoP");
        }
        this.interceptTerm = b0;
        int numFactors = selectedFactorsIndex.length;
        if (this.interceptTerm) {
            this.coeffs = new double[numFactors + 1];
            this.factors = new String[numFactors + 1];
            this.factorsIndex = new int[numFactors + 1];
            this.coeffs[0] = coeffsVal[0];
            this.factors[0] = "_";
            this.factorsIndex[0] = -1;
            for (int i = 1; i < numFactors + 1; ++i) {
                this.coeffs[i] = coeffsVal[i];
                this.factors[i] = allFactorsList[selectedFactorsIndex[i - 1]];
                this.factorsIndex[i] = this.featureDefinition.getFeatureIndex(this.factors[i]);
            }
        } else {
            this.coeffs = new double[numFactors];
            this.factors = new String[numFactors];
            this.factorsIndex = new int[numFactors];
            for (int i = 0; i < numFactors; ++i) {
                this.coeffs[i] = coeffsVal[i];
                this.factors[i] = allFactorsList[selectedFactorsIndex[i]];
                this.factorsIndex[i] = this.featureDefinition.getFeatureIndex(this.factors[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String sopFile) {
        String strContext = "";
        Scanner s = null;
        try {
            String nextLine;
            s = new Scanner(new BufferedReader(new FileReader(sopFile)));
            while (s.hasNext() && !(nextLine = s.nextLine()).trim().equals("")) {
                strContext = strContext + nextLine + "\n";
            }
            this.featureDefinition = new FeatureDefinition(new BufferedReader(new StringReader(strContext)), false);
            if (s.hasNext()) {
                nextLine = s.nextLine();
                this.setCoeffsAndFactors(nextLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    public void setCoeffsAndFactors(String line) {
        String[] word = line.split(" ");
        int j = 0;
        this.coeffs = new double[word.length / 2];
        this.factors = new String[word.length / 2];
        this.factorsIndex = new int[word.length / 2];
        this.interceptTerm = false;
        for (int i = 0; i < word.length; ++i) {
            this.coeffs[j] = Double.parseDouble(word[i]);
            this.factors[j] = word[i + 1];
            if (word[i + 1].contentEquals("_")) {
                this.interceptTerm = true;
                this.factorsIndex[j] = -1;
            } else {
                this.factorsIndex[j] = this.featureDefinition.getFeatureIndex(this.factors[j]);
            }
            ++i;
            ++j;
        }
    }

    public SoP(String line, FeatureDefinition feaDef) {
        this.featureDefinition = feaDef;
        String[] word = line.split(" ");
        int j = 0;
        this.coeffs = new double[word.length / 2];
        this.factors = new String[word.length / 2];
        this.factorsIndex = new int[word.length / 2];
        this.interceptTerm = false;
        for (int i = 0; i < word.length; ++i) {
            this.coeffs[j] = Double.parseDouble(word[i]);
            this.factors[j] = word[i + 1];
            if (word[i + 1].contentEquals("_")) {
                this.interceptTerm = true;
                this.factorsIndex[j] = -1;
            } else {
                this.factorsIndex[j] = this.featureDefinition.getFeatureIndex(this.factors[j]);
            }
            ++i;
            ++j;
        }
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.featureDefinition;
    }

    public double solve(Target t, FeatureDefinition feaDef, boolean log) {
        this.solution = 0.0;
        double lastPosSolution = 0.0;
        if (this.interceptTerm) {
            this.solution = this.coeffs[0];
            for (int i = 1; i < this.coeffs.length; ++i) {
                this.solution += this.coeffs[i] * (double)t.getFeatureVector().getByteFeature(this.factorsIndex[i]);
                if (this.solution > 0.0) {
                    lastPosSolution = this.solution;
                    continue;
                }
                System.out.println("WARNING: sop solution negative");
            }
        } else {
            for (int i = 0; i < this.coeffs.length; ++i) {
                this.solution += this.coeffs[i] * (double)t.getFeatureVector().getByteFeature(this.factorsIndex[i]);
                if (this.solution > 0.0) {
                    lastPosSolution = this.solution;
                    continue;
                }
                System.out.println("WARNING: sop solution negative");
            }
        }
        if (this.solution < 0.0) {
            this.solution = lastPosSolution;
        }
        if (log) {
            return Math.exp(this.solution);
        }
        return this.solution;
    }

    public double solve(Target t, FeatureDefinition feaDef, boolean log, boolean debug) {
        this.solution = 0.0;
        double lastPosSolution = 0.0;
        if (this.interceptTerm) {
            this.solution = this.coeffs[0];
            if (debug) {
                System.out.format("   solution = %.3f (coeff[0])\n", this.coeffs[0]);
            }
            for (int i = 1; i < this.coeffs.length; ++i) {
                byte feaVal = t.getFeatureVector().getByteFeature(this.factorsIndex[i]);
                String feaValStr = t.getFeatureVector().getFeatureAsString(this.factorsIndex[i], feaDef);
                if (feaDef.hasFeatureValue(this.factorsIndex[i], feaValStr)) {
                    if (debug) {
                        System.out.format("   %.3f + (%.3f * %d (%s) = ", this.solution, this.coeffs[i], feaVal, this.factors[i]);
                    }
                    this.solution += this.coeffs[i] * (double)feaVal;
                    if (debug) {
                        System.out.format("%.3f  featureIndex=%d  feaValStr=%s \n", this.solution, this.factorsIndex[i], feaValStr);
                    }
                } else {
                    System.out.format("WARNING: Feature value for %s = %s is not valid", this.coeffs[i], feaValStr);
                }
                if (!(this.solution > 0.0)) continue;
                lastPosSolution = this.solution;
            }
        } else {
            for (int i = 0; i < this.coeffs.length; ++i) {
                this.solution += this.coeffs[i] * (double)t.getFeatureVector().getByteFeature(this.factorsIndex[i]);
            }
            if (this.solution > 0.0) {
                lastPosSolution = this.solution;
            }
        }
        if (debug) {
            if (log) {
                return Math.exp(lastPosSolution);
            }
            return lastPosSolution;
        }
        if (log) {
            return Math.exp(this.solution);
        }
        return this.solution;
    }

    public double interpret(Target t) {
        return this.solve(t, this.featureDefinition, false);
    }

    public void saveSelectedFeatures(PrintWriter toSopFile) {
        for (int j = 0; j < this.coeffs.length; ++j) {
            toSopFile.print(this.coeffs[j] + " " + this.factors[j] + " ");
        }
        toSopFile.println();
    }

    public void printCoefficients() {
        if (this.coeffs != null) {
            System.out.println("SoP coefficients (factor : factorIndex in FeatureDefinition)");
            for (int j = 0; j < this.coeffs.length; ++j) {
                System.out.format(" %.5f (%s : %d)\n", this.coeffs[j], this.factors[j], this.factorsIndex[j]);
            }
        } else {
            System.out.println("There is no coefficients to print (coeffs=null).");
        }
    }
}

