/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.modules.InternalModule;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.MbrolaVoice;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimplePhoneme2AP
extends InternalModule {
    private DocumentBuilderFactory factory = null;
    private DocumentBuilder docBuilder = null;
    protected AllophoneSet allophoneSet;

    public SimplePhoneme2AP(String localeString) {
        this(MaryDataType.SIMPLEPHONEMES, MaryDataType.ACOUSTPARAMS, MaryUtils.string2locale(localeString));
    }

    public SimplePhoneme2AP(MaryDataType inputType, MaryDataType outputType, Locale locale) {
        super("SimplePhoneme2AP", inputType, outputType, locale);
    }

    @Override
    public void startup() throws Exception {
        this.allophoneSet = MaryRuntimeUtils.needAllophoneSet(MaryProperties.localePrefix(this.getLocale()) + ".allophoneset");
        if (this.factory == null) {
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setNamespaceAware(true);
        }
        if (this.docBuilder == null) {
            this.docBuilder = this.factory.newDocumentBuilder();
        }
        super.startup();
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        String phoneString = d.getPlainText();
        MaryData result = new MaryData(this.outputType(), d.getLocale(), true);
        Document doc = result.getDocument();
        Element root = doc.getDocumentElement();
        root.setAttribute("xml:lang", MaryUtils.locale2xmllang(d.getLocale()));
        Element insertHere = root;
        Voice defaultVoice = d.getDefaultVoice();
        if (defaultVoice != null) {
            Element voiceElement = MaryXML.createElement(doc, "voice");
            voiceElement.setAttribute("name", defaultVoice.getName());
            root.appendChild(voiceElement);
            insertHere = voiceElement;
        }
        int cumulDur = 0;
        boolean isFirst = true;
        StringTokenizer stTokens = new StringTokenizer(phoneString);
        while (stTokens.hasMoreTokens()) {
            Element token = MaryXML.createElement(doc, "t");
            insertHere.appendChild(token);
            String tokenPhonemes = stTokens.nextToken();
            token.setAttribute("ph", tokenPhonemes);
            StringTokenizer stSyllables = new StringTokenizer(tokenPhonemes, "-_");
            while (stSyllables.hasMoreTokens()) {
                Element syllable = MaryXML.createElement(doc, "syllable");
                token.appendChild(syllable);
                String syllablePhonemes = stSyllables.nextToken();
                syllable.setAttribute("ph", syllablePhonemes);
                int stress = 0;
                if (syllablePhonemes.startsWith("'")) {
                    stress = 1;
                } else if (syllablePhonemes.startsWith(",")) {
                    stress = 2;
                }
                if (stress != 0) {
                    syllable.setAttribute("accent", "*");
                    token.setAttribute("accent", "*");
                }
                Allophone[] phones = this.allophoneSet.splitIntoAllophones(syllablePhonemes);
                for (int i = 0; i < phones.length; ++i) {
                    Element ph = MaryXML.createElement(doc, "ph");
                    ph.setAttribute("p", phones[i].name());
                    int dur = 70;
                    if (phones[i].isVowel()) {
                        dur = 100;
                        if (stress == 1) {
                            dur = (int)((double)dur * 1.5);
                        } else if (stress == 2) {
                            dur = (int)((double)dur * 1.2);
                        }
                    }
                    ph.setAttribute("d", String.valueOf(dur));
                    ph.setAttribute("end", String.valueOf(cumulDur += dur));
                    if (defaultVoice instanceof MbrolaVoice) {
                        if (isFirst) {
                            isFirst = false;
                            ph.setAttribute("f0", "(0," + ((MbrolaVoice)defaultVoice).topStart() + ")");
                        } else if (i == phones.length - 1 && !stTokens.hasMoreTokens() && !stSyllables.hasMoreTokens()) {
                            ph.setAttribute("f0", "(100," + ((MbrolaVoice)defaultVoice).baseEnd() + ")");
                        }
                    }
                    token.appendChild(ph);
                }
            }
        }
        Element boundary = MaryXML.createElement(doc, "boundary");
        boundary.setAttribute("bi", "4");
        boundary.setAttribute("duration", "400");
        insertHere.appendChild(boundary);
        return result;
    }
}

