/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.prosody;

import marytts.signalproc.adaptation.prosody.PitchStatistics;
import marytts.signalproc.adaptation.prosody.PitchStatisticsCollection;
import marytts.signalproc.adaptation.prosody.PitchStatisticsMapping;
import marytts.signalproc.adaptation.prosody.ProsodyTransformerParams;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class PitchTransformer {
    public double[] transform(ProsodyTransformerParams param, PitchStatisticsMapping mapping, PitchStatistics inputLocalStatistics, double[] f0s, double[] pscales) {
        double[] targetF0s = new double[f0s.length];
        if (f0s != null) {
            int i;
            if (param.pitchTransformationMethod != 0 && param.pitchTransformationMethod != -1) {
                double newMean;
                double meanShift;
                double scale;
                int bestIndex = -1;
                PitchStatistics inputStatistics = null;
                PitchStatistics outputStatistics = null;
                if (param.pitchTransformationMethod < 21) {
                    if (param.pitchStatisticsType == PitchStatistics.STATISTICS_IN_HERTZ) {
                        inputStatistics = new PitchStatistics(mapping.sourceGlobalStatisticsHz);
                    } else if (param.pitchStatisticsType == PitchStatistics.STATISTICS_IN_LOGHERTZ) {
                        inputStatistics = new PitchStatistics(mapping.sourceGlobalStatisticsLogHz);
                    } else {
                        System.out.println("Error! Statistics type unknown...");
                    }
                    assert (inputStatistics != null);
                    if (param.pitchStatisticsType == PitchStatistics.STATISTICS_IN_HERTZ) {
                        outputStatistics = new PitchStatistics(mapping.targetGlobalStatisticsHz);
                    } else if (param.pitchStatisticsType == PitchStatistics.STATISTICS_IN_LOGHERTZ) {
                        outputStatistics = new PitchStatistics(mapping.targetGlobalStatisticsLogHz);
                    } else {
                        System.out.println("Error! Statistics type unknown...");
                    }
                    assert (outputStatistics != null);
                } else {
                    if (param.pitchStatisticsType == PitchStatistics.STATISTICS_IN_HERTZ) {
                        bestIndex = this.findBestMatch(inputLocalStatistics, mapping.sourceLocalStatisticsHz, mapping.sourceVariancesHz);
                    } else if (param.pitchStatisticsType == PitchStatistics.STATISTICS_IN_LOGHERTZ) {
                        bestIndex = this.findBestMatch(inputLocalStatistics, mapping.sourceLocalStatisticsLogHz, mapping.sourceVariancesLogHz);
                    } else {
                        System.out.println("Error! Statistics type unknown...");
                    }
                    if (bestIndex < 0) {
                        System.out.println("Error! No best match found...");
                        assert (bestIndex > -1);
                    }
                    if (param.pitchStatisticsType == PitchStatistics.STATISTICS_IN_HERTZ) {
                        inputStatistics = new PitchStatistics(mapping.sourceLocalStatisticsHz.entries[bestIndex]);
                        outputStatistics = new PitchStatistics(mapping.targetLocalStatisticsHz.entries[bestIndex]);
                    } else if (param.pitchStatisticsType == PitchStatistics.STATISTICS_IN_LOGHERTZ) {
                        inputStatistics = new PitchStatistics(mapping.sourceLocalStatisticsLogHz.entries[bestIndex]);
                        outputStatistics = new PitchStatistics(mapping.targetLocalStatisticsLogHz.entries[bestIndex]);
                    } else {
                        System.out.println("Error! Statistics type unknown...");
                    }
                    assert (inputStatistics != null);
                    assert (outputStatistics != null);
                }
                if (param.isUseInputMeanPitch) {
                    inputStatistics.mean = inputLocalStatistics.mean;
                }
                if (param.isUseInputStdDevPitch) {
                    inputStatistics.standardDeviation = inputLocalStatistics.standardDeviation;
                }
                if (param.isUseInputRangePitch) {
                    inputStatistics.range = inputLocalStatistics.range;
                }
                if (param.isUseInputInterceptPitch) {
                    inputStatistics.intercept = inputLocalStatistics.intercept;
                }
                if (param.isUseInputSlopePitch) {
                    inputStatistics.slope = inputLocalStatistics.slope;
                }
                System.arraycopy(f0s, 0, targetF0s, 0, f0s.length);
                double minF0ScaleAllowed = -0.5;
                double maxF0ScaleAllowed = 1.5;
                double minF0ShiftAllowed = -200.0;
                double maxF0ShiftAllowed = 200.0;
                if (param.pitchStatisticsType == PitchStatistics.STATISTICS_IN_LOGHERTZ) {
                    targetF0s = SignalProcUtils.getLogF0s(targetF0s);
                    minF0ScaleAllowed = Math.log(0.5);
                    maxF0ScaleAllowed = Math.log(maxF0ScaleAllowed);
                    minF0ShiftAllowed = Math.log(0.1);
                    maxF0ShiftAllowed = Math.log(maxF0ShiftAllowed);
                }
                if (param.pitchTransformationMethod == 1 || param.pitchTransformationMethod == 21) {
                    double meanShift2 = outputStatistics.mean - inputStatistics.mean;
                    meanShift2 = Math.max(minF0ShiftAllowed, meanShift2);
                    meanShift2 = Math.min(maxF0ShiftAllowed, meanShift2);
                    for (i = 0; i < targetF0s.length; ++i) {
                        targetF0s[i] = targetF0s[i] + meanShift2;
                    }
                    System.out.println("Mean transformed -> (Output mean f0)-(Input mean f0)=" + String.valueOf(meanShift2));
                } else if (param.pitchTransformationMethod == 2 || param.pitchTransformationMethod == 22) {
                    scale = outputStatistics.standardDeviation / inputStatistics.standardDeviation;
                    scale = Math.max(minF0ScaleAllowed, scale);
                    scale = Math.min(maxF0ScaleAllowed, scale);
                    meanShift = inputStatistics.mean - inputStatistics.mean * scale;
                    meanShift = Math.max(minF0ShiftAllowed, meanShift);
                    meanShift = Math.min(maxF0ShiftAllowed, meanShift);
                    for (i = 0; i < targetF0s.length; ++i) {
                        targetF0s[i] = scale * targetF0s[i] + meanShift;
                    }
                    System.out.println("Std.dev. transformed -> (Output f0)/(Input f0)=" + String.valueOf(scale));
                } else if (param.pitchTransformationMethod == 3 || param.pitchTransformationMethod == 23) {
                    scale = outputStatistics.range / inputStatistics.range;
                    scale = Math.max(minF0ScaleAllowed, scale);
                    scale = Math.min(maxF0ScaleAllowed, scale);
                    meanShift = inputStatistics.mean - inputStatistics.mean * scale;
                    meanShift = Math.max(minF0ShiftAllowed, meanShift);
                    meanShift = Math.min(maxF0ShiftAllowed, meanShift);
                    for (i = 0; i < targetF0s.length; ++i) {
                        targetF0s[i] = scale * targetF0s[i] + meanShift;
                    }
                    System.out.println("Range transformed -> (Output f0)/(Input f0)=" + String.valueOf(scale));
                } else if (param.pitchTransformationMethod == 4 || param.pitchTransformationMethod == 24) {
                    scale = outputStatistics.slope / inputStatistics.slope;
                    scale = Math.max(minF0ScaleAllowed, scale);
                    scale = Math.min(maxF0ScaleAllowed, scale);
                    meanShift = inputStatistics.mean - inputStatistics.mean * scale;
                    meanShift = Math.max(minF0ShiftAllowed, meanShift);
                    meanShift = Math.min(maxF0ShiftAllowed, meanShift);
                    for (i = 0; i < targetF0s.length; ++i) {
                        targetF0s[i] = scale * targetF0s[i] + meanShift;
                    }
                    System.out.println("Slope transformed -> (Output f0)/(Input f0)=" + String.valueOf(scale));
                } else if (param.pitchTransformationMethod == 5 || param.pitchTransformationMethod == 25) {
                    double newMean2 = (inputStatistics.mean - inputStatistics.intercept) / inputStatistics.slope;
                    newMean2 = outputStatistics.slope * newMean2 + outputStatistics.intercept;
                    meanShift = newMean2 - inputStatistics.mean;
                    meanShift = Math.max(minF0ShiftAllowed, meanShift);
                    meanShift = Math.min(maxF0ShiftAllowed, meanShift);
                    for (i = 0; i < targetF0s.length; ++i) {
                        targetF0s[i] = targetF0s[i] + meanShift;
                    }
                    System.out.println("Intercept transformed -> (Output mean f0)-(Input mean f0)=" + String.valueOf(meanShift));
                } else if (param.pitchTransformationMethod == 6 || param.pitchTransformationMethod == 26) {
                    scale = outputStatistics.standardDeviation / inputStatistics.standardDeviation;
                    scale = Math.max(minF0ScaleAllowed, scale);
                    scale = Math.min(maxF0ScaleAllowed, scale);
                    meanShift = outputStatistics.mean - inputStatistics.mean * scale;
                    meanShift = Math.max(minF0ShiftAllowed, meanShift);
                    meanShift = Math.min(maxF0ShiftAllowed, meanShift);
                    for (i = 0; i < targetF0s.length; ++i) {
                        targetF0s[i] = scale * targetF0s[i] + meanShift;
                    }
                    System.out.println("Mean & Std.dev. transformed -> (Output mean f0)-(Input mean f0)=" + String.valueOf(meanShift) + " (Output f0)/(Input f0)=" + String.valueOf(scale));
                } else if (param.pitchTransformationMethod == 7 || param.pitchTransformationMethod == 27) {
                    scale = outputStatistics.slope / inputStatistics.slope;
                    scale = Math.max(minF0ScaleAllowed, scale);
                    scale = Math.min(maxF0ScaleAllowed, scale);
                    meanShift = outputStatistics.mean - inputStatistics.mean * scale;
                    meanShift = Math.max(minF0ShiftAllowed, meanShift);
                    meanShift = Math.min(maxF0ShiftAllowed, meanShift);
                    for (i = 0; i < targetF0s.length; ++i) {
                        targetF0s[i] = scale * targetF0s[i] + meanShift;
                    }
                    System.out.println("Mean & Slope transformed -> (Output mean f0)-(Input mean f0)=" + String.valueOf(meanShift) + " (Output f0)/(Input f0)=" + String.valueOf(scale));
                } else if (param.pitchTransformationMethod == 8 || param.pitchTransformationMethod == 28) {
                    scale = outputStatistics.standardDeviation / inputStatistics.standardDeviation;
                    scale = Math.max(minF0ScaleAllowed, scale);
                    scale = Math.min(maxF0ScaleAllowed, scale);
                    meanShift = inputStatistics.mean - inputStatistics.mean * scale;
                    meanShift = Math.max(minF0ShiftAllowed, meanShift);
                    meanShift = Math.min(maxF0ShiftAllowed, meanShift);
                    for (i = 0; i < targetF0s.length; ++i) {
                        targetF0s[i] = scale * targetF0s[i] + meanShift;
                    }
                    newMean = (inputStatistics.mean - inputStatistics.intercept) / inputStatistics.slope;
                    newMean = outputStatistics.slope * newMean + outputStatistics.intercept;
                    meanShift = newMean - inputStatistics.mean;
                    meanShift = Math.max(minF0ShiftAllowed, meanShift);
                    meanShift = Math.min(maxF0ShiftAllowed, meanShift);
                    for (i = 0; i < targetF0s.length; ++i) {
                        targetF0s[i] = targetF0s[i] + meanShift;
                    }
                    System.out.println("Intercept & Std. dev. transformed -> (Output mean f0)-(Input mean f0)=" + String.valueOf(meanShift) + " (Output f0)/(Input f0)=" + String.valueOf(scale));
                } else if (param.pitchTransformationMethod == 9 || param.pitchTransformationMethod == 29) {
                    scale = outputStatistics.slope / inputStatistics.slope;
                    scale = Math.max(minF0ScaleAllowed, scale);
                    scale = Math.min(maxF0ScaleAllowed, scale);
                    meanShift = inputStatistics.mean - inputStatistics.mean * scale;
                    for (i = 0; i < targetF0s.length; ++i) {
                        targetF0s[i] = scale * targetF0s[i] + meanShift;
                    }
                    newMean = (inputStatistics.mean - inputStatistics.intercept) / inputStatistics.slope;
                    newMean = outputStatistics.slope * newMean + outputStatistics.intercept;
                    meanShift = newMean - inputStatistics.mean;
                    meanShift = Math.max(minF0ShiftAllowed, meanShift);
                    meanShift = Math.min(maxF0ShiftAllowed, meanShift);
                    for (i = 0; i < targetF0s.length; ++i) {
                        targetF0s[i] = targetF0s[i] + meanShift;
                    }
                    System.out.println("Intercept & Slope transformed -> (Output mean f0)-(Input mean f0)=" + String.valueOf(meanShift) + " (Output f0)/(Input f0)=" + String.valueOf(scale));
                }
                if (param.pitchStatisticsType == PitchStatistics.STATISTICS_IN_LOGHERTZ) {
                    targetF0s = SignalProcUtils.getExpF0s(targetF0s);
                }
            } else {
                System.arraycopy(f0s, 0, targetF0s, 0, f0s.length);
            }
            if (param.pitchTransformationMethod != 0) {
                for (i = 0; i < targetF0s.length; ++i) {
                    int n = i;
                    targetF0s[n] = targetF0s[n] * pscales[i];
                }
            }
            for (i = 0; i < targetF0s.length; ++i) {
                if (f0s[i] < 10.0) {
                    targetF0s[i] = 0.0;
                }
                if (!(targetF0s[i] < 10.0)) continue;
                targetF0s[i] = 0.0;
            }
        }
        return targetF0s;
    }

    public int findBestMatch(PitchStatistics oneStatistics, PitchStatisticsCollection multipleStatistics, double[] variances) {
        int bestIndex = -1;
        if (multipleStatistics != null && oneStatistics != null && multipleStatistics.entries != null) {
            if (multipleStatistics.entries.length == 1) {
                bestIndex = 0;
            } else {
                double[] dists = new double[multipleStatistics.entries.length];
                for (int i = 0; i < multipleStatistics.entries.length; ++i) {
                    dists[i] = 0.0;
                    int n = i;
                    dists[n] = dists[n] + (oneStatistics.mean - multipleStatistics.entries[i].mean) * (oneStatistics.mean - multipleStatistics.entries[i].mean) / variances[0];
                    int n2 = i;
                    dists[n2] = dists[n2] + (oneStatistics.standardDeviation - multipleStatistics.entries[i].standardDeviation) * (oneStatistics.standardDeviation - multipleStatistics.entries[i].standardDeviation) / variances[1];
                    int n3 = i;
                    dists[n3] = dists[n3] + (oneStatistics.range - multipleStatistics.entries[i].range) * (oneStatistics.range - multipleStatistics.entries[i].range) / variances[2];
                    int n4 = i;
                    dists[n4] = dists[n4] + (oneStatistics.intercept - multipleStatistics.entries[i].intercept) * (oneStatistics.intercept - multipleStatistics.entries[i].intercept) / variances[3];
                    int n5 = i;
                    dists[n5] = dists[n5] + (oneStatistics.slope - multipleStatistics.entries[i].slope) * (oneStatistics.slope - multipleStatistics.entries[i].slope) / variances[4];
                    dists[i] = Math.sqrt(dists[i]);
                }
                bestIndex = MathUtils.getMinIndex(dists);
            }
        }
        return bestIndex;
    }
}

