/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.util.Arrays;
import marytts.signalproc.window.Window;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class OverlapAddEnergyNormalizer {
    public static double[] normalize(double[] x, int samplingRate, double windowSizeInSeconds, double skipSizeInSeconds, int windowType, double targetEnergy) {
        int i;
        double[] y = new double[x.length];
        double[] w = new double[x.length];
        Arrays.fill(y, 0.0);
        Arrays.fill(w, 0.0);
        int ws = (int)Math.floor(windowSizeInSeconds * (double)samplingRate + 0.5);
        if (ws % 2 != 0) {
            ++ws;
        }
        int half_ws = (int)((double)ws / 2.0);
        int ss = (int)Math.floor(skipSizeInSeconds * (double)samplingRate + 0.5);
        Window win = Window.get(windowType, ws);
        win.normalize(1.0f);
        double[] wgt = new double[ws];
        double[] frm = new double[ws];
        int start = 0;
        boolean bLastFrame = false;
        while (true) {
            if (start + ws - 1 >= x.length - 1) {
                bLastFrame = true;
            }
            wgt = win.getCoeffs();
            if (start == 0) {
                Arrays.fill(wgt, 0, half_ws - 1, 1.0);
            } else if (bLastFrame) {
                Arrays.fill(wgt, half_ws, ws - 1, 1.0);
            }
            Arrays.fill(frm, 0.0);
            System.arraycopy(x, start, frm, 0, Math.min(ws, x.length - start));
            frm = MathUtils.multiply(frm, wgt);
            double frmEn = SignalProcUtils.energy(frm);
            double gain = Math.sqrt(targetEnergy / frmEn);
            System.out.println(String.valueOf(gain));
            frm = MathUtils.multiply(frm, gain);
            frm = MathUtils.multiply(frm, wgt);
            for (i = 0; i < ws; ++i) {
                if (i + start >= y.length) {
                    bLastFrame = true;
                    break;
                }
                int n = i + start;
                y[n] = y[n] + frm[i];
                int n2 = i + start;
                w[n2] = w[n2] + wgt[i] * wgt[i];
            }
            if (bLastFrame) break;
            start += ss;
        }
        for (i = 0; i < y.length; ++i) {
            if (!(w[i] > 0.0)) continue;
            int n = i;
            y[n] = y[n] / w[i];
        }
        return y;
    }
}

