/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.window;

import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.LogSpectrum;
import marytts.signalproc.window.Window;
import marytts.util.math.MathUtils;

public class BartlettWindow
extends Window {
    public BartlettWindow(int length) {
        super(length);
    }

    public BartlettWindow(int length, double prescalingFactor) {
        super(length, prescalingFactor);
    }

    @Override
    protected void initialise() {
        int halfN = this.window.length / 2;
        this.window[halfN] = this.prescalingFactor;
        double top = 2.0 * this.prescalingFactor;
        for (int i = 0; i < halfN; ++i) {
            this.window[i] = top * (double)i / (double)(this.window.length - 1);
            this.window[halfN + i + 1] = this.prescalingFactor - this.window[i];
        }
    }

    public String toString() {
        return "Bartlett window";
    }

    public static void main(String[] args) {
        int samplingRate = Integer.getInteger("samplingrate", 1);
        int windowLengthMs = Integer.getInteger("windowlength.ms", 0);
        int windowLength = Integer.getInteger("windowlength.samples", 512);
        if (windowLengthMs != 0) {
            windowLength = windowLengthMs * samplingRate / 1000;
        }
        int fftSize = Math.max(4096, MathUtils.closestPowerOfTwoAbove(windowLength));
        BartlettWindow w = new BartlettWindow(windowLength);
        FunctionGraph timeGraph = new FunctionGraph(0.0, 1.0 / (double)samplingRate, w.window);
        timeGraph.showInJFrame(((Object)w).toString() + " in time domain", true, false);
        double[] fftSignal = new double[fftSize];
        double sum = MathUtils.sum(w.window);
        for (int i = 0; i < w.window.length; ++i) {
            fftSignal[i] = w.window[i] / sum;
        }
        LogSpectrum freqGraph = new LogSpectrum(fftSignal, samplingRate);
        freqGraph.showInJFrame(((Object)w).toString() + " log frequency response", true, false);
    }
}

