/*
 * Decompiled with CFR 0.152.
 */
package marytts.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MaryUtils {
    public static final String LOGPREFIX = "marytts";
    private static Timer maintenanceTimer = new Timer(true);
    protected static final char[] punctuationTable = new char[]{'\u201c', '\"', '\u201e', '\"', '\u2013', '-', '\u2033', '\"', '\u2036', '\"', '\u201c', '\"', '\u201d', '\"', '\u201e', '\"', '\u201f', '\"', '\u00ab', '\"', '\u00bb', '\"', '\u2018', '\'', '\u2019', '\'', '\u201a', '\'', '\u201b', '\'', '\u2032', '\'', '\u2035', '\'', '\u2039', '\'', '\u203a', '\'', '\u2010', '-', '\u2011', '-', '\u2012', '-', '\u2013', '-', '\u2014', '-', '\u2015', '-'};
    protected static final char[] toGermanLetterTable = new char[]{'\u00c0', 'A', '\u00c1', 'A', '\u00c2', 'A', '\u00c3', 'A', '\u00c5', 'A', '\u00c6', '\u00c4', '\u00c7', 'C', '\u00c8', 'E', '\u00c9', 'E', '\u00ca', 'E', '\u00cb', 'E', '\u00cc', 'I', '\u00cd', 'I', '\u00ce', 'I', '\u00cf', 'I', '\u00d1', 'N', '\u00d2', 'O', '\u00d3', 'O', '\u00d4', 'O', '\u00d5', 'O', '\u00d8', '\u00d6', '\u00d9', 'U', '\u00da', 'U', '\u00db', 'U', '\u00dd', 'Y', '\u00e0', 'a', '\u00e1', 'a', '\u00e2', 'a', '\u00e3', 'a', '\u00e5', 'a', '\u00e6', '\u00e4', '\u00e7', 'c', '\u00e8', 'e', '\u00e9', 'e', '\u00ea', 'e', '\u00eb', 'e', '\u00ec', 'i', '\u00ed', 'i', '\u00ee', 'i', '\u00ef', 'i', '\u00f1', 'n', '\u00f2', 'o', '\u00f3', 'o', '\u00f4', 'o', '\u00f5', 'o', '\u00f8', '\u00f6', '\u00f9', 'u', '\u00fa', 'u', '\u00fb', 'u', '\u00fd', 'y', '\u00ff', 'y'};
    protected static final char[] toItalianLetterTable = new char[]{'\u00c2', 'A', '\u00c3', 'A', '\u00c5', 'A', '\u00c6', 'A', '\u00c7', 'C', '\u00ca', 'E', '\u00cb', 'E', '\u00ce', 'I', '\u00cf', 'I', '\u00d1', 'N', '\u00d4', 'O', '\u00d5', 'O', '\u00d8', 'O', '\u00db', 'U', '\u00dd', 'Y', '\u00e2', 'a', '\u00e3', 'a', '\u00e5', 'a', '\u00e6', 'a', '\u00e7', 'c', '\u00ea', 'e', '\u00eb', 'e', '\u00ee', 'i', '\u00ef', 'i', '\u00f1', 'n', '\u00f4', 'o', '\u00f5', 'o', '\u00f8', 'o', '\u00fb', 'u', '\u00fd', 'y', '\u00ff', 'y', '\u00c4', 'A', '\u00d6', 'O', '\u00dc', 'U', '\u00e4', 'a', '\u00f6', 'o', '\u00fc', 'u', '\u00df', 's'};
    protected static final char[] germanToAsciiLetterTable = new char[]{'\u00c4', 'A', '\u00d6', 'O', '\u00dc', 'U', '\u00e4', 'a', '\u00f6', 'o', '\u00fc', 'u', '\u00df', 's'};

    public static Map<String, String> arrayToMap(String[] a) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < a.length; i += 2) {
            m.put(a[i], a[i + 1]);
        }
        return m;
    }

    public static Character[] StringToCharacterArray(String s) {
        Character[] cArray = new Character[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            cArray[i] = new Character(s.charAt(i));
        }
        return cArray;
    }

    public static String joinStrings(Collection<String> strings) {
        StringBuilder buf = new StringBuilder();
        if (strings == null) {
            throw new NullPointerException("Received null collection");
        }
        for (String s : strings) {
            buf.append(s);
        }
        return buf.toString();
    }

    public static int indexOf(byte[] bytes, byte[] pattern) {
        if (bytes == null || pattern == null || bytes.length < pattern.length || pattern.length == 0) {
            return -1;
        }
        int j = 0;
        int start = -1;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == pattern[j]) {
                if (j == 0) {
                    start = i;
                }
                if (++j != pattern.length) continue;
                return start;
            }
            j = 0;
            start = -1;
        }
        return -1;
    }

    public static String[] splitIntoSensibleXMLUnits(String s) {
        ArrayList<String> result = new ArrayList<String>();
        boolean inLetters = false;
        int partstart = 0;
        String letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dcabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df";
        String splitters = "\n \t\"=<>&;";
        for (int i = 0; i < s.length(); ++i) {
            if ("\n \t\"=<>&;".indexOf(s.charAt(i)) != -1) {
                if (i > partstart) {
                    result.add(s.substring(partstart, i));
                }
                result.add(s.substring(i, i + 1));
                partstart = i + 1;
                continue;
            }
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ\u00c4\u00d6\u00dcabcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df".indexOf(s.charAt(i)) == -1) {
                if (inLetters && i > partstart) {
                    result.add(s.substring(partstart, i));
                    partstart = i;
                }
                inLetters = false;
                continue;
            }
            if (!inLetters && i > partstart) {
                result.add(s.substring(partstart, i));
                partstart = i;
            }
            inLetters = true;
        }
        return result.toArray(new String[0]);
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static int romanToInt(String romanNumber) {
        if (!romanNumber.matches("[IVXLCDM]+")) {
            throw new NumberFormatException("Not a roman number: " + romanNumber);
        }
        String num = "IVXLCDM";
        int[] value = new int[]{1, 5, 10, 50, 100, 500, 1000};
        int sum = 0;
        int i = romanNumber.length() - 1;
        while (i >= 0) {
            int posR = num.indexOf(romanNumber.charAt(i));
            if (i > 0) {
                int posL = num.indexOf(romanNumber.charAt(i - 1));
                if (posR <= posL) {
                    sum += value[posR];
                    --i;
                    continue;
                }
                sum += value[posR] - value[posL];
                i -= 2;
                continue;
            }
            sum += value[posR];
            --i;
        }
        return sum;
    }

    public static boolean isPercentageDelta(String string) {
        String s = string.trim();
        if (s.length() < 3) {
            return false;
        }
        return s.substring(s.length() - 1).equals("%") && MaryUtils.isNumberDelta(s.substring(0, s.length() - 1));
    }

    public static int getPercentageDelta(String string) {
        String s = string.trim();
        if (!MaryUtils.isPercentageDelta(s)) {
            return 0;
        }
        return MaryUtils.getNumberDelta(s.substring(0, s.length() - 1));
    }

    public static boolean isSemitonesDelta(String string) {
        String s = string.trim();
        if (s.length() < 4) {
            return false;
        }
        return s.substring(s.length() - 2).equals("st") && MaryUtils.isNumberDelta(s.substring(0, s.length() - 2));
    }

    public static double getSemitonesDelta(String string) {
        String s = string.trim();
        if (!MaryUtils.isSemitonesDelta(s)) {
            return 0.0;
        }
        String num = s.substring(0, s.length() - 2);
        double value = 0.0;
        try {
            value = Double.parseDouble(num);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return value;
    }

    public static boolean isNumberDelta(String string) {
        String s = string.trim();
        if (s.length() < 2) {
            return false;
        }
        return (s.charAt(0) == '+' || s.charAt(0) == '-') && MaryUtils.isUnsignedNumber(s.substring(1));
    }

    public static int getNumberDelta(String string) {
        String s = string.trim();
        if (!MaryUtils.isNumberDelta(s)) {
            return 0;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return (int)Math.round(value);
    }

    public static boolean isUnsignedSemitones(String string) {
        String s = string.trim();
        if (s.length() < 3) {
            return false;
        }
        return s.substring(s.length() - 2).equals("st") && MaryUtils.isUnsignedNumber(s.substring(0, s.length() - 2));
    }

    public static double getUnsignedSemitones(String string) {
        String s = string.trim();
        if (!MaryUtils.isUnsignedSemitones(s)) {
            return 0.0;
        }
        String num = s.substring(0, s.length() - 2);
        double value = 0.0;
        try {
            value = Double.parseDouble(num);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return value;
    }

    public static boolean isUnsignedNumber(String string) {
        String s = string.trim();
        if (s.length() < 1) {
            return false;
        }
        if (s.charAt(0) != '+' && s.charAt(0) != '-') {
            double value = 0.0;
            try {
                value = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static int getUnsignedNumber(String string) {
        String s = string.trim();
        if (!MaryUtils.isUnsignedNumber(s)) {
            return 0;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return (int)Math.round(value);
    }

    public static boolean isNumber(String string) {
        String s = string.trim();
        if (s.length() < 1) {
            return false;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static int getNumber(String string) {
        String s = string.trim();
        if (!MaryUtils.isNumber(s)) {
            return 0;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return (int)Math.round(value);
    }

    public static Locale string2locale(String localeString) {
        Locale locale = null;
        StringTokenizer localeST = new StringTokenizer(localeString, "_-");
        String language = localeST.nextToken();
        String country = "";
        String variant = "";
        if (localeST.hasMoreTokens()) {
            country = localeST.nextToken();
            if (localeST.hasMoreTokens()) {
                variant = localeST.nextToken();
            }
        }
        locale = new Locale(language, country, variant);
        return locale;
    }

    public static String locale2xmllang(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null");
        }
        String country = locale.getCountry();
        if (!"".equals(country)) {
            return locale.getLanguage() + "-" + country;
        }
        return locale.getLanguage();
    }

    public static boolean subsumes(Locale general, Locale specific) {
        if (general == null || specific == null) {
            return false;
        }
        if (general.equals(specific)) {
            return true;
        }
        return general.getVariant().equals("") && (general.getCountry().equals("") ? general.getLanguage().equals(specific.getLanguage()) : general.getLanguage().equals(specific.getLanguage()) && general.getCountry().equals(specific.getCountry()));
    }

    public static long availableMemory() {
        Runtime rt = Runtime.getRuntime();
        return rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
    }

    public static File createSelfDeletingTempFile(int lifetimeInSeconds) throws IOException {
        final File f = File.createTempFile("mary", "temp");
        maintenanceTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                f.delete();
            }
        }, (long)lifetimeInSeconds * 1000L);
        return f;
    }

    public static String normaliseUnicodePunctuation(String unicodeText) {
        return MaryUtils.normaliseUnicode(unicodeText, punctuationTable);
    }

    public static String normaliseUnicodeLetters(String unicodeText, Locale targetLocale) {
        if (MaryUtils.subsumes(Locale.GERMAN, targetLocale)) {
            return MaryUtils.normaliseUnicode(unicodeText, toGermanLetterTable);
        }
        if (MaryUtils.subsumes(Locale.ITALIAN, targetLocale)) {
            return MaryUtils.normaliseUnicode(unicodeText, toItalianLetterTable);
        }
        String german = MaryUtils.normaliseUnicode(unicodeText, toGermanLetterTable);
        return MaryUtils.normaliseUnicode(german, germanToAsciiLetterTable);
    }

    private static String normaliseUnicode(String unicodeText, char[] mappings) {
        String result = unicodeText;
        for (int i = 0; i < mappings.length; i += 2) {
            result = result.replace(mappings[i], mappings[i + 1]);
        }
        return result;
    }

    public static String getThrowableAndCausesAsString(Throwable t) {
        StringBuffer buf = new StringBuffer();
        buf.append(t.toString());
        if (t.getCause() != null) {
            buf.append("\nCaused by: ");
            buf.append(MaryUtils.getThrowableAndCausesAsString(t.getCause()));
        }
        return buf.toString();
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return (osName = osName.toLowerCase()).indexOf("windows") != -1;
    }

    public static boolean isLittleEndian() {
        ByteOrder b = ByteOrder.nativeOrder();
        return b.equals(ByteOrder.LITTLE_ENDIAN);
    }

    public static int shellExecute(String strCommand) {
        return MaryUtils.shellExecute(strCommand, true);
    }

    public static int shellExecute(String strCommand, boolean bDisplayProgramOutput) {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(strCommand);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (p != null) {
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            try {
                line = input.readLine();
                if (bDisplayProgramOutput && line != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            while (line != null) {
                try {
                    line = input.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (!bDisplayProgramOutput || line == null) continue;
                System.out.println(line);
            }
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return p.exitValue();
        }
        return -1;
    }

    public static void writeCopyrightNotice(PrintWriter out, String commentChar) {
        out.println(" #########################################################################");
        out.println(commentChar + " Copyright 2009 DFKI GmbH.");
        out.println(commentChar + " All Rights Reserved.  Use is subject to license terms.");
        out.println(commentChar);
        out.println(commentChar + " This file is part of MARY TTS.");
        out.println(commentChar);
        out.println(commentChar + " MARY TTS is free software: you can redistribute it and/or modify");
        out.println(commentChar + " it under the terms of the GNU Lesser General Public License as published by");
        out.println(commentChar + " the Free Software Foundation, version 3 of the License.");
        out.println(commentChar);
        out.println(commentChar + " This program is distributed in the hope that it will be useful,");
        out.println(commentChar + " but WITHOUT ANY WARRANTY; without even the implied warranty of");
        out.println(commentChar + " MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
        out.println(commentChar + " GNU Lesser General Public License for more details.");
        out.println(commentChar);
        out.println(commentChar + " You should have received a copy of the GNU Lesser General Public License");
        out.println(commentChar + " along with this program.  If not, see <http://www.gnu.org/licenses/>.");
        out.println(commentChar);
        out.println(commentChar + " #########################################################################");
    }

    public static String toHumanReadableSize(long byteCount) {
        if (byteCount >= 0xA00000L) {
            return byteCount / 0x100000L + "MB";
        }
        if (byteCount >= 10240L) {
            return byteCount / 1024L + "kB";
        }
        return Long.toString(byteCount);
    }

    public static Logger getLogger(String nameSuffix) {
        return Logger.getLogger("marytts." + nameSuffix);
    }

    public static Logger getLogger(Class clazz) {
        return MaryUtils.getLogger(clazz.getSimpleName());
    }

    public static boolean isLog4jConfigured() {
        System.setProperty("log4j.defaultInitOverride", "true");
        Enumeration appenders = LogManager.getRootLogger().getAllAppenders();
        return appenders.hasMoreElements();
    }

    public static String getFirstMeaningfulMessage(Throwable t) {
        if (t == null) {
            return null;
        }
        String m = t.getMessage();
        if (m != null && !m.isEmpty()) {
            return m;
        }
        return MaryUtils.getFirstMeaningfulMessage(t.getCause());
    }
}

