/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import marytts.util.data.audio.AudioCommon;
import marytts.util.data.audio.AudioProcessor;

public class AudioRecorder {
    private static final SupportedFormat[] SUPPORTED_FORMATS = new SupportedFormat[]{new SupportedFormat("s8", AudioFormat.Encoding.PCM_SIGNED, 8, true), new SupportedFormat("u8", AudioFormat.Encoding.PCM_UNSIGNED, 8, true), new SupportedFormat("s16_le", AudioFormat.Encoding.PCM_SIGNED, 16, false), new SupportedFormat("s16_be", AudioFormat.Encoding.PCM_SIGNED, 16, true), new SupportedFormat("u16_le", AudioFormat.Encoding.PCM_UNSIGNED, 16, false), new SupportedFormat("u16_be", AudioFormat.Encoding.PCM_UNSIGNED, 16, true), new SupportedFormat("s24_le", AudioFormat.Encoding.PCM_SIGNED, 24, false), new SupportedFormat("s24_be", AudioFormat.Encoding.PCM_SIGNED, 24, true), new SupportedFormat("u24_le", AudioFormat.Encoding.PCM_UNSIGNED, 24, false), new SupportedFormat("u24_be", AudioFormat.Encoding.PCM_UNSIGNED, 24, true), new SupportedFormat("s32_le", AudioFormat.Encoding.PCM_SIGNED, 32, false), new SupportedFormat("s32_be", AudioFormat.Encoding.PCM_SIGNED, 32, true), new SupportedFormat("u32_le", AudioFormat.Encoding.PCM_UNSIGNED, 32, false), new SupportedFormat("u32_be", AudioFormat.Encoding.PCM_UNSIGNED, 32, true)};
    private static final String DEFAULT_FORMAT = "s16_le";
    private static final int DEFAULT_CHANNELS = 2;
    private static final float DEFAULT_RATE = 44100.0f;
    private static final AudioFileFormat.Type DEFAULT_TARGET_TYPE = AudioFileFormat.Type.WAVE;
    private static boolean sm_bDebug = false;

    public static void main(String[] args) {
        int nDotPosition;
        String strMixerName = null;
        int nInternalBufferSize = -1;
        String strFormat = DEFAULT_FORMAT;
        int nChannels = 2;
        float fRate = 44100.0f;
        String strExtension = null;
        boolean bDirectRecording = true;
        int millis = 0;
        if (args.length < 1) {
            AudioRecorder.printUsageAndExit();
        }
        String strFilename = null;
        block20: for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) {
                if (i == args.length - 1) {
                    strFilename = args[i];
                    continue;
                }
                AudioRecorder.printUsageAndExit();
            }
            if (args[i].length() != 2) {
                AudioRecorder.printUsageAndExit();
            }
            switch (args[i].charAt(1)) {
                case 'h': {
                    AudioRecorder.printUsageAndExit();
                }
                case 'l': {
                    AudioCommon.listMixersAndExit();
                }
                case 'L': {
                    AudioRecorder.listTargetDataLines();
                    System.exit(0);
                }
                case 'M': {
                    strMixerName = args[++i];
                    if (!sm_bDebug) continue block20;
                    AudioRecorder.out("AudioRecorder.main(): mixer name: " + strMixerName);
                    continue block20;
                }
                case 'i': {
                    nInternalBufferSize = Integer.parseInt(args[++i]);
                    continue block20;
                }
                case 'f': {
                    strFormat = args[++i].toLowerCase();
                    continue block20;
                }
                case 'c': {
                    nChannels = Integer.parseInt(args[++i]);
                    continue block20;
                }
                case 'r': {
                    fRate = Float.parseFloat(args[++i]);
                    continue block20;
                }
                case 't': {
                    strExtension = args[++i];
                    continue block20;
                }
                case 'D': {
                    sm_bDebug = true;
                    AudioCommon.setDebug(true);
                    AudioRecorder.out("AudioRecorder.main(): enabled debug messages");
                    continue block20;
                }
                case 'd': {
                    bDirectRecording = true;
                    AudioRecorder.out("AudioRecorder.main(): using direct recording");
                    continue block20;
                }
                case 'b': {
                    bDirectRecording = false;
                    AudioRecorder.out("AudioRecorder.main(): using buffered recording");
                    continue block20;
                }
                case '?': {
                    AudioRecorder.printUsageAndExit();
                }
                case 'T': {
                    millis = Integer.parseInt(args[++i]);
                    continue block20;
                }
                default: {
                    AudioRecorder.out("unknown option: " + args[i]);
                    AudioRecorder.printUsageAndExit();
                }
            }
        }
        if (sm_bDebug) {
            AudioRecorder.out("AudioRecorder.main(): output filename: " + strFilename);
        }
        if (strFilename == null) {
            AudioRecorder.printUsageAndExit();
        }
        File outputFile = new File(strFilename);
        if (strFormat.equals("phone")) {
            fRate = 8000.0f;
            strFormat = "u8";
            nChannels = 1;
        } else if (strFormat.equals("radio")) {
            fRate = 22050.0f;
            strFormat = DEFAULT_FORMAT;
            nChannels = 1;
        } else if (strFormat.equals("cd")) {
            fRate = 44100.0f;
            strFormat = DEFAULT_FORMAT;
            nChannels = 2;
        } else if (strFormat.equals("dat")) {
            fRate = 48000.0f;
            strFormat = DEFAULT_FORMAT;
            nChannels = 2;
        }
        int nOutputFormatIndex = -1;
        for (int i = 0; i < SUPPORTED_FORMATS.length; ++i) {
            if (!SUPPORTED_FORMATS[i].getName().equals(strFormat)) continue;
            nOutputFormatIndex = i;
            break;
        }
        if (nOutputFormatIndex == -1) {
            AudioRecorder.out("warning: output format '" + strFormat + "' not supported; using default output format '" + DEFAULT_FORMAT + "'");
            nOutputFormatIndex = 2;
        }
        AudioFormat.Encoding encoding = SUPPORTED_FORMATS[nOutputFormatIndex].getEncoding();
        int nBitsPerSample = SUPPORTED_FORMATS[nOutputFormatIndex].getSampleSize();
        boolean bBigEndian = SUPPORTED_FORMATS[nOutputFormatIndex].getBigEndian();
        int nFrameSize = nBitsPerSample / 8 * nChannels;
        AudioFormat audioFormat = new AudioFormat(encoding, fRate, nBitsPerSample, nChannels, nFrameSize, fRate, bBigEndian);
        if (sm_bDebug) {
            AudioRecorder.out("AudioRecorder.main(): target audio format: " + audioFormat);
        }
        AudioFileFormat.Type targetType = null;
        if (strExtension == null && (nDotPosition = strFilename.lastIndexOf(46)) != -1) {
            strExtension = strFilename.substring(nDotPosition + 1);
        }
        if (strExtension != null) {
            targetType = AudioCommon.findTargetType(strExtension);
            if (targetType == null) {
                AudioRecorder.out("target type '" + strExtension + "' is not supported.");
                AudioRecorder.out("using default type '" + DEFAULT_TARGET_TYPE.getExtension() + "'");
                targetType = DEFAULT_TARGET_TYPE;
            }
        } else {
            AudioRecorder.out("target type is neither specified nor can be guessed from the target file name.");
            AudioRecorder.out("using default type '" + DEFAULT_TARGET_TYPE.getExtension() + "'");
            targetType = DEFAULT_TARGET_TYPE;
        }
        if (sm_bDebug) {
            AudioRecorder.out("AudioRecorder.main(): target audio file format type: " + targetType);
        }
        TargetDataLine targetDataLine = null;
        targetDataLine = AudioCommon.getTargetDataLine(strMixerName, audioFormat, nInternalBufferSize);
        if (targetDataLine == null) {
            AudioRecorder.out("can't get TargetDataLine, exiting.");
            System.exit(1);
        }
        AbstractRecorder recorder = null;
        recorder = millis > 0 ? new BufferingRecorder(targetDataLine, targetType, outputFile, millis) : (bDirectRecording ? new DirectRecorder(targetDataLine, targetType, outputFile) : new BufferingRecorder(targetDataLine, targetType, outputFile, 0));
        if (sm_bDebug) {
            AudioRecorder.out("AudioRecorder.main(): Recorder: " + recorder);
        }
        AudioRecorder.out("Press ENTER to start the recording.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recorder.start();
        AudioRecorder.out("Recording...");
        AudioRecorder.out("Press ENTER to stop the recording.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        recorder.stopRecording();
        AudioRecorder.out("Recording stopped.");
    }

    private static void listTargetDataLines() {
        AudioRecorder.out("Available Mixers:");
        Mixer.Info[] aInfos = AudioSystem.getMixerInfo();
        for (int i = 0; i < aInfos.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(aInfos[i]);
            Line.Info[] lines = mixer.getTargetLineInfo();
            AudioRecorder.out(aInfos[i].getName());
            for (int j = 0; j < lines.length; ++j) {
                AudioRecorder.out("  " + lines[j].toString());
                if (!(lines[j] instanceof DataLine.Info)) continue;
                AudioFormat[] formats = ((DataLine.Info)lines[j]).getFormats();
                for (int k = 0; k < formats.length; ++k) {
                    AudioRecorder.out("    " + formats[k].toString());
                }
            }
        }
    }

    private static void printUsageAndExit() {
        AudioRecorder.out("AudioRecorder: usage:");
        AudioRecorder.out("\tjava AudioRecorder -l");
        AudioRecorder.out("\tjava AudioRecorder -L");
        AudioRecorder.out("\tjava AudioRecorder [-f <format>] [-c <numchannels>] [-r <samplingrate>] [-t <targettype>] [-M <mixername>] <soundfile>");
        System.exit(0);
    }

    private static void out(String strMessage) {
        System.out.println(strMessage);
    }

    public static class BufferingRecorder
    extends AbstractRecorder {
        private int millis;

        public BufferingRecorder(TargetDataLine line, AudioFileFormat.Type targetType, File file, int millis) {
            super(line, targetType, file);
            this.millis = millis;
        }

        @Override
        public void run() {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream outputStream = byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] abBuffer = new byte[65532];
            AudioFormat format = this.m_line.getFormat();
            int nFrameSize = format.getFrameSize();
            long totalBytesToRead = (long)((float)this.millis * format.getFrameRate() * (float)nFrameSize / 1000.0f);
            if (totalBytesToRead % (long)nFrameSize != 0L) {
                totalBytesToRead += (long)nFrameSize - totalBytesToRead % (long)nFrameSize;
            }
            long totalBytes = 0L;
            this.m_bRecording = true;
            while (this.m_bRecording) {
                int bytesToRead = abBuffer.length;
                if (totalBytesToRead > 0L && totalBytes + (long)abBuffer.length > totalBytesToRead) {
                    bytesToRead = (int)(totalBytesToRead - totalBytes);
                }
                if (sm_bDebug) {
                    AudioRecorder.out("BufferingRecorder.run(): trying to read: " + bytesToRead);
                }
                int nBytesRead = this.m_line.read(abBuffer, 0, bytesToRead);
                if (totalBytesToRead > 0L && (totalBytes += (long)nBytesRead) >= totalBytesToRead) {
                    this.m_bRecording = false;
                }
                if (sm_bDebug) {
                    AudioRecorder.out("BufferingRecorder.run(): read: " + nBytesRead);
                }
                try {
                    ((OutputStream)outputStream).write(abBuffer, 0, nBytesRead);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] abData = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(abData);
            AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, format, abData.length / format.getFrameSize());
            if (this.audioProcessor != null) {
                audioInputStream = this.audioProcessor.apply(audioInputStream);
            }
            try {
                AudioSystem.write(audioInputStream, this.m_targetType, this.m_file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class DirectRecorder
    extends AbstractRecorder {
        private AudioInputStream m_audioInputStream;

        public DirectRecorder(TargetDataLine line, AudioFileFormat.Type targetType, File file) {
            super(line, targetType, file);
            this.m_audioInputStream = new AudioInputStream(line);
        }

        @Override
        public void run() {
            try {
                if (this.audioProcessor != null) {
                    this.m_audioInputStream = this.audioProcessor.apply(this.m_audioInputStream);
                }
                if (sm_bDebug) {
                    AudioRecorder.out("before AudioSystem.write");
                }
                AudioSystem.write(this.m_audioInputStream, this.m_targetType, this.m_file);
                if (sm_bDebug) {
                    AudioRecorder.out("after AudioSystem.write");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class AbstractRecorder
    extends Thread
    implements Recorder {
        protected TargetDataLine m_line;
        protected AudioFileFormat.Type m_targetType;
        protected File m_file;
        protected boolean m_bRecording;
        protected AudioProcessor audioProcessor;

        public AbstractRecorder(TargetDataLine line, AudioFileFormat.Type targetType, File file) {
            this.m_line = line;
            this.m_targetType = targetType;
            this.m_file = file;
        }

        @Override
        public void setAudioProcessor(AudioProcessor proc) {
            this.audioProcessor = proc;
        }

        @Override
        public void start() {
            this.m_line.start();
            super.start();
        }

        @Override
        public void stopRecording() {
            this.m_line.drain();
            this.m_line.stop();
            this.m_line.close();
            this.m_bRecording = false;
        }

        public void stopRecordingNOW() {
            this.m_line.stop();
            this.m_line.close();
            this.m_bRecording = false;
        }
    }

    public static interface Recorder {
        public void setAudioProcessor(AudioProcessor var1);

        public void start();

        public void stopRecording();
    }

    private static class SupportedFormat {
        private String m_strName;
        private AudioFormat.Encoding m_encoding;
        private int m_nSampleSize;
        private boolean m_bBigEndian;

        public SupportedFormat(String strName, AudioFormat.Encoding encoding, int nSampleSize, boolean bBigEndian) {
            this.m_strName = strName;
            this.m_encoding = encoding;
            this.m_nSampleSize = nSampleSize;
        }

        public String getName() {
            return this.m_strName;
        }

        public AudioFormat.Encoding getEncoding() {
            return this.m_encoding;
        }

        public int getSampleSize() {
            return this.m_nSampleSize;
        }

        public boolean getBigEndian() {
            return this.m_bBigEndian;
        }
    }
}

