/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.util.data.audio.MaryAudioUtils;
import marytts.util.math.MathUtils;

public class FFT {
    static double[] cosDelta;
    static double[] sinDelta;

    public static double[] computeLogPowerSpectrum(double[] signal) {
        double[] spectrum = FFT.computePowerSpectrum(signal);
        for (int i = 0; i < spectrum.length; ++i) {
            spectrum[i] = MathUtils.db(spectrum[i]);
        }
        return spectrum;
    }

    public static double[] computeLogPowerSpectrum_FD(double[] fft) {
        double[] spectrum = FFT.computePowerSpectrum_FD(fft);
        for (int i = 0; i < spectrum.length; ++i) {
            spectrum[i] = MathUtils.db(spectrum[i]);
        }
        return spectrum;
    }

    public static double[] computePowerSpectrum(double[] signal) {
        if (signal == null) {
            throw new NullPointerException("Received null argument");
        }
        int N = signal.length;
        if (!MathUtils.isPowerOfTwo(N)) {
            N = MathUtils.closestPowerOfTwoAbove(N);
        }
        double[] real = new double[N];
        System.arraycopy(signal, 0, real, 0, signal.length);
        FFT.realTransform(real, false);
        return FFT.computePowerSpectrum_FD(real);
    }

    public static double[] computePowerSpectrum_FD(double[] fft) {
        if (fft == null) {
            throw new NullPointerException("Received null argument");
        }
        int halfN = fft.length / 2;
        double[] freqs = new double[halfN];
        freqs[0] = fft[0] * fft[0];
        for (int i = 2; i < fft.length; i += 2) {
            freqs[i / 2] = fft[i] * fft[i] + fft[i + 1] * fft[i + 1];
        }
        return freqs;
    }

    public static double[] computeLogAmplitudeSpectrum(double[] signal) {
        double[] spectrum = FFT.computeAmplitudeSpectrum(signal);
        for (int i = 0; i < spectrum.length; ++i) {
            spectrum[i] = Math.log(spectrum[i]);
        }
        return spectrum;
    }

    public static double[] computeLogAmplitudeSpectrum_FD(double[] fft) {
        double[] spectrum = FFT.computeAmplitudeSpectrum_FD(fft);
        for (int i = 0; i < spectrum.length; ++i) {
            spectrum[i] = Math.log(spectrum[i]);
        }
        return spectrum;
    }

    public static double[] computeAmplitudeSpectrum(double[] signal) {
        if (signal == null) {
            throw new NullPointerException("Received null argument");
        }
        int N = signal.length;
        if (!MathUtils.isPowerOfTwo(N)) {
            N = MathUtils.closestPowerOfTwoAbove(N);
        }
        double[] real = new double[N];
        System.arraycopy(signal, 0, real, 0, signal.length);
        FFT.realTransform(real, false);
        return FFT.computeAmplitudeSpectrum_FD(real);
    }

    public static double[] computeAmplitudeSpectrum_FD(double[] fft) {
        if (fft == null) {
            throw new NullPointerException("Received null argument");
        }
        int halfN = fft.length / 2;
        double[] freqs = new double[halfN];
        freqs[0] = fft[0];
        for (int i = 2; i < fft.length; i += 2) {
            freqs[i / 2] = Math.sqrt(fft[i] * fft[i] + fft[i + 1] * fft[i + 1]);
        }
        return freqs;
    }

    public static double[] computePhaseSpectrum_FD(double[] fft) {
        if (fft == null) {
            throw new NullPointerException("Received null argument");
        }
        double[] phases = new double[fft.length / 2];
        phases[0] = Math.atan2(0.0, fft[0]);
        for (int i = 2; i < fft.length; i += 2) {
            phases[i / 2] = Math.atan2(fft[i + 1], fft[i]);
        }
        return phases;
    }

    public static void transform(double[] real, double[] imag, boolean inverse) {
        int i;
        if (real == null || imag == null) {
            throw new NullPointerException("Received null argument");
        }
        if (real.length != imag.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        int N = real.length;
        assert (MathUtils.isPowerOfTwo(N));
        int halfN = N / 2;
        int iReverse = 0;
        for (i = 0; i < N; ++i) {
            int b;
            if (i > iReverse) {
                double tmpReal = real[i];
                double tmpImag = imag[i];
                real[i] = real[iReverse];
                imag[i] = imag[iReverse];
                real[iReverse] = tmpReal;
                imag[iReverse] = tmpImag;
            }
            for (b = halfN; b >= 1 && iReverse >= b; iReverse -= b, b >>= 1) {
            }
            iReverse += b;
        }
        int blockLength = 2;
        int powerOfTwo = 1;
        while (blockLength <= N) {
            double wStepReal = cosDelta[powerOfTwo];
            double wStepImag = sinDelta[powerOfTwo];
            if (inverse) {
                wStepImag = -wStepImag;
            }
            double wReal = 1.0;
            double wImag = 0.0;
            int halfBlockLength = blockLength / 2;
            for (int n = 0; n < halfBlockLength; ++n) {
                for (int i2 = n; i2 < N; i2 += blockLength) {
                    int j = i2 + halfBlockLength;
                    double tmpReal = wReal * real[j] - wImag * imag[j];
                    double tmpImag = wReal * imag[j] + wImag * real[j];
                    real[j] = real[i2] - tmpReal;
                    imag[j] = imag[i2] - tmpImag;
                    int n2 = i2;
                    real[n2] = real[n2] + tmpReal;
                    int n3 = i2;
                    imag[n3] = imag[n3] + tmpImag;
                }
                double oldWReal = wReal;
                wReal = oldWReal * wStepReal - wImag * wStepImag;
                wImag = oldWReal * wStepImag + wImag * wStepReal;
            }
            blockLength <<= 1;
            ++powerOfTwo;
        }
        if (inverse) {
            i = 0;
            while (i < N) {
                int n = i;
                real[n] = real[n] / (double)N;
                int n4 = i++;
                imag[n4] = imag[n4] / (double)N;
            }
        }
    }

    public static void transform(double[] realAndImag, boolean inverse) {
        int i;
        if (realAndImag == null) {
            throw new NullPointerException("Received null argument");
        }
        int N = realAndImag.length >> 1;
        assert (MathUtils.isPowerOfTwo(N));
        int halfN = N >> 1;
        int iReverse = 0;
        for (i = 0; i < N; ++i) {
            int b;
            if (i > iReverse) {
                int twoi = i << 1;
                int twoi1 = twoi + 1;
                int twoirev = iReverse << 1;
                int twoirev1 = twoirev + 1;
                double tmpReal = realAndImag[twoi];
                double tmpImag = realAndImag[twoi1];
                realAndImag[twoi] = realAndImag[twoirev];
                realAndImag[twoi1] = realAndImag[twoirev1];
                realAndImag[twoirev] = tmpReal;
                realAndImag[twoirev1] = tmpImag;
            }
            for (b = halfN; b >= 1 && iReverse >= b; iReverse -= b, b >>= 1) {
            }
            iReverse += b;
        }
        int blockLength = 2;
        int powerOfTwo = 1;
        while (blockLength <= N) {
            double wStepReal = cosDelta[powerOfTwo];
            double wStepImag = sinDelta[powerOfTwo];
            if (inverse) {
                wStepImag = -wStepImag;
            }
            double wReal = 1.0;
            double wImag = 0.0;
            int halfBlockLength = blockLength >> 1;
            for (int n = 0; n < halfBlockLength; ++n) {
                for (int i2 = n; i2 < N; i2 += blockLength) {
                    int j = i2 + halfBlockLength;
                    int twoi = i2 << 1;
                    int twoi1 = twoi + 1;
                    int twoj = j << 1;
                    int twoj1 = twoj + 1;
                    double tmpReal = wReal * realAndImag[twoj] - wImag * realAndImag[twoj1];
                    double tmpImag = wReal * realAndImag[twoj1] + wImag * realAndImag[twoj];
                    realAndImag[twoj] = realAndImag[twoi] - tmpReal;
                    realAndImag[twoj1] = realAndImag[twoi1] - tmpImag;
                    int n2 = twoi;
                    realAndImag[n2] = realAndImag[n2] + tmpReal;
                    int n3 = twoi1;
                    realAndImag[n3] = realAndImag[n3] + tmpImag;
                }
                double oldWReal = wReal;
                wReal = oldWReal * wStepReal - wImag * wStepImag;
                wImag = oldWReal * wStepImag + wImag * wStepReal;
            }
            blockLength <<= 1;
            ++powerOfTwo;
        }
        if (inverse) {
            i = 0;
            while (i < realAndImag.length) {
                int n = i++;
                realAndImag[n] = realAndImag[n] / (double)N;
            }
        }
    }

    public static void realTransform(double[] data, boolean inverse) {
        double c2;
        double c1 = 0.5;
        int n = data.length;
        double twoPi = Math.PI * -2;
        if (inverse) {
            twoPi = Math.PI * 2;
        }
        double delta = twoPi / (double)n;
        double wStepReal = Math.cos(delta);
        double wStepImag = Math.sin(delta);
        double wReal = wStepReal;
        double wImag = wStepImag;
        if (!inverse) {
            c2 = -0.5;
            FFT.transform(data, false);
        } else {
            c2 = 0.5;
        }
        int n4 = n >> 2;
        for (int i = 1; i < n4; ++i) {
            int twoI = i << 1;
            int twoIPlus1 = twoI + 1;
            int nMinusTwoI = n - twoI;
            int nMinusTwoIPlus1 = nMinusTwoI + 1;
            double h1r = c1 * (data[twoI] + data[nMinusTwoI]);
            double h1i = c1 * (data[twoIPlus1] - data[nMinusTwoIPlus1]);
            double h2r = -c2 * (data[twoIPlus1] + data[nMinusTwoIPlus1]);
            double h2i = c2 * (data[twoI] - data[nMinusTwoI]);
            data[twoI] = h1r + wReal * h2r - wImag * h2i;
            data[twoIPlus1] = h1i + wReal * h2i + wImag * h2r;
            data[nMinusTwoI] = h1r - wReal * h2r + wImag * h2i;
            data[nMinusTwoIPlus1] = -h1i + wReal * h2i + wImag * h2r;
            double oldWReal = wReal;
            wReal = oldWReal * wStepReal - wImag * wStepImag;
            wImag = oldWReal * wStepImag + wImag * wStepReal;
        }
        if (!inverse) {
            double tmp = data[0];
            data[0] = data[0] + data[1];
            data[1] = tmp - data[1];
            data[n / 2 + 1] = -data[n / 2 + 1];
        } else {
            double tmp = data[0];
            data[0] = 0.5 * (tmp + data[1]);
            data[1] = 0.5 * (tmp - data[1]);
            data[n / 2 + 1] = -data[n / 2 + 1];
            FFT.transform(data, true);
        }
    }

    public static double[] convolveWithZeroPadding(double[] signal1, double[] signal2, double deltaT) {
        double[] result = FFT.convolveWithZeroPadding(signal1, signal2);
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] * deltaT;
        }
        return result;
    }

    public static double[] convolveWithZeroPadding(double[] signal1, double[] signal2) {
        if (signal1 == null || signal2 == null) {
            throw new NullPointerException("Received null argument");
        }
        int N = signal1.length + signal2.length;
        if (!MathUtils.isPowerOfTwo(N)) {
            N = MathUtils.closestPowerOfTwoAbove(N);
        }
        double[] fft1 = new double[N];
        double[] fft2 = new double[N];
        System.arraycopy(signal1, 0, fft1, 0, signal1.length);
        System.arraycopy(signal2, 0, fft2, 0, signal2.length);
        double[] fftResult = FFT.convolve(fft1, fft2);
        double[] result = new double[signal1.length + signal2.length];
        System.arraycopy(fftResult, 0, result, 0, result.length);
        return result;
    }

    public static double[] convolve(double[] signal1, double[] signal2, double deltaT) {
        double[] result = FFT.convolve(signal1, signal2);
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] * deltaT;
        }
        return result;
    }

    public static double[] convolve(double[] signal1, double[] signal2) {
        if (signal1 == null || signal2 == null) {
            throw new NullPointerException("Received null argument");
        }
        if (signal1.length != signal2.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        int N = signal1.length;
        assert (MathUtils.isPowerOfTwo(N));
        double[] fft1 = new double[N];
        System.arraycopy(signal1, 0, fft1, 0, N);
        double[] fft2 = new double[N];
        System.arraycopy(signal2, 0, fft2, 0, N);
        FFT.realTransform(fft1, false);
        FFT.realTransform(fft2, false);
        fft1[0] = fft1[0] * fft2[0];
        fft1[1] = fft1[1] * fft2[1];
        for (int i = 2; i < N; i += 2) {
            double tmp = fft1[i];
            fft1[i] = fft1[i] * fft2[i] - fft1[i + 1] * fft2[i + 1];
            fft1[i + 1] = tmp * fft2[i + 1] + fft1[i + 1] * fft2[i];
        }
        FFT.realTransform(fft1, true);
        return fft1;
    }

    public static double[] convolve_FD(double[] signal1, double[] fft2, double deltaT) {
        double[] result = FFT.convolve_FD(signal1, fft2);
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] * deltaT;
        }
        return result;
    }

    public static double[] convolve_FD(double[] signal1, double[] fft2) {
        if (signal1 == null || fft2 == null) {
            throw new NullPointerException("Received null argument");
        }
        if (signal1.length != fft2.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        int N = signal1.length;
        assert (MathUtils.isPowerOfTwo(N));
        double[] fft1 = new double[N];
        System.arraycopy(signal1, 0, fft1, 0, N);
        FFT.realTransform(fft1, false);
        fft1[0] = fft1[0] * fft2[0];
        fft1[1] = fft1[1] * fft2[1];
        for (int i = 2; i < N; i += 2) {
            double tmp = fft1[i];
            fft1[i] = fft1[i] * fft2[i] - fft1[i + 1] * fft2[i + 1];
            fft1[i + 1] = tmp * fft2[i + 1] + fft1[i + 1] * fft2[i];
        }
        FFT.realTransform(fft1, true);
        return fft1;
    }

    public static double[] correlateWithZeroPadding(double[] signal1, double[] signal2) {
        if (signal1 == null || signal2 == null) {
            throw new NullPointerException("Received null argument");
        }
        int N = signal1.length + signal2.length;
        if (!MathUtils.isPowerOfTwo(N)) {
            N = MathUtils.closestPowerOfTwoAbove(N);
        }
        double[] fft1 = new double[N];
        double[] fft2 = new double[N];
        System.arraycopy(signal1, 0, fft1, 0, signal1.length);
        System.arraycopy(signal2, 0, fft2, 0, signal2.length);
        double[] fftResult = FFT.correlate(fft1, fft2);
        double[] result = new double[signal1.length + signal2.length];
        System.arraycopy(fftResult, 0, result, 0, result.length);
        return result;
    }

    public static double[] correlate(double[] signal1, double[] signal2) {
        if (signal1 == null || signal2 == null) {
            throw new NullPointerException("Received null argument");
        }
        if (signal1.length != signal2.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        int N = signal1.length;
        assert (MathUtils.isPowerOfTwo(N));
        double[] fft1 = new double[N];
        System.arraycopy(signal1, 0, fft1, 0, N);
        double[] fft2 = new double[N];
        System.arraycopy(signal2, 0, fft2, 0, N);
        FFT.realTransform(fft1, false);
        FFT.realTransform(fft2, false);
        fft1[0] = fft1[0] * fft2[0];
        fft1[1] = fft1[1] * fft2[1];
        for (int i = 2; i < N; i += 2) {
            double tmp = fft1[i];
            fft1[i] = fft1[i] * fft2[i] + fft1[i + 1] * fft2[i + 1];
            fft1[i + 1] = tmp * fft2[i + 1] - fft1[i + 1] * fft2[i];
        }
        FFT.realTransform(fft1, true);
        return fft1;
    }

    public static double[] autoCorrelate(double[] signal) {
        if (signal == null) {
            throw new NullPointerException("Received null argument");
        }
        int N = signal.length;
        assert (MathUtils.isPowerOfTwo(N));
        double[] fft = new double[N];
        System.arraycopy(signal, 0, fft, 0, N);
        FFT.realTransform(fft, false);
        fft[0] = fft[0] * fft[0];
        fft[1] = fft[1] * fft[1];
        for (int i = 2; i < N; i += 2) {
            fft[i] = fft[i] * fft[i] + fft[i + 1] * fft[i + 1];
            fft[i + 1] = 0.0;
        }
        FFT.realTransform(fft, true);
        return fft;
    }

    public static double[] autoCorrelateWithZeroPadding(double[] signal) {
        int n = MathUtils.closestPowerOfTwoAbove(2 * signal.length);
        double[] fftSignal = new double[n];
        System.arraycopy(signal, 0, fftSignal, 0, signal.length);
        double[] fftAutocorr = FFT.autoCorrelate(fftSignal);
        double[] result = new double[signal.length];
        int halfLength = signal.length / 2;
        int odd = signal.length % 2;
        System.arraycopy(fftAutocorr, n - halfLength, result, 0, halfLength);
        System.arraycopy(fftAutocorr, 0, result, halfLength, halfLength + odd);
        return result;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            int j;
            System.out.println("Measuring FFT accuracy for " + args[i]);
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[i]));
            double[] signal = MaryAudioUtils.getSamplesAsDoubleArray(ais);
            int N = signal.length;
            if (!MathUtils.isPowerOfTwo(N)) {
                N = MathUtils.closestPowerOfTwoAbove(N);
            }
            double[] ar = new double[N];
            double[] ai = new double[N];
            System.arraycopy(signal, 0, ar, 0, signal.length);
            FFT.transform(ar, ai, false);
            double[] result1 = new double[2 * N];
            for (int j2 = 0; j2 < N; ++j2) {
                result1[2 * j2] = ar[j2];
                result1[2 * j2 + 1] = ai[j2];
            }
            double[] result2 = new double[2 * N];
            for (int j3 = 0; j3 < signal.length; ++j3) {
                result2[2 * j3] = signal[j3];
            }
            FFT.transform(result2, false);
            System.err.println("Difference between result1 and 2: " + MathUtils.sumSquaredError(result1, result2));
            double[] result3 = new double[N];
            System.arraycopy(signal, 0, result3, 0, signal.length);
            FFT.realTransform(result3, false);
            double[] result2a = new double[N];
            System.arraycopy(result2, 0, result2a, 0, N);
            System.err.println("F2(N/2)=" + result2[N] + " F3(N/2)=" + result3[1]);
            result3[1] = 0.0;
            System.err.println("Difference between result 2a and 3: " + MathUtils.sumSquaredError(result2a, result3));
            double[] delta = new double[N];
            for (int j4 = 0; j4 < N; ++j4) {
                delta[j4] = Math.abs(result2a[j4] - result3[j4]);
                if (!(delta[j4] > 1.0E-4)) continue;
                System.err.println("delta[" + j4 + "]=" + delta[j4]);
            }
            result3[1] = result2[N];
            FFT.transform(ar, ai, true);
            FFT.transform(result2, true);
            double[] inverse2 = new double[N];
            for (j = 0; j < N; ++j) {
                inverse2[j] = result2[2 * j];
            }
            FFT.realTransform(result3, true);
            System.err.println("Difference between inverse 1 and 2:" + MathUtils.sumSquaredError(ar, inverse2));
            System.err.println("Difference between inverse 1 and 3:" + MathUtils.sumSquaredError(ar, result3));
            for (j = 0; j < N; ++j) {
                delta[j] = Math.abs(ar[j] - result3[j]);
                if (!(delta[j] > 1.0E-4)) continue;
                System.err.println("delta[" + j + "]=" + delta[j]);
            }
            System.out.println("Computing FFT speed for 1000 transforms at different n");
            for (int k = 5; k <= 11; ++k) {
                int n = 1 << k;
                double[] re = new double[n];
                double[] im = new double[n];
                System.arraycopy(signal, 0, re, 0, Math.min(signal.length, n));
                long start = System.currentTimeMillis();
                for (int j5 = 0; j5 < 5000; ++j5) {
                    FFT.transform(re, im, false);
                    FFT.transform(re, im, true);
                }
                long mid = System.currentTimeMillis();
                for (int j6 = 0; j6 < 5000; ++j6) {
                    FFT.realTransform(re, false);
                    FFT.realTransform(re, true);
                }
                long end = System.currentTimeMillis();
                long t1 = mid - start;
                long t2 = end - mid;
                System.out.println("n=" + n + " fft=" + t1 + ", realFFT=" + t2);
            }
        }
    }

    static {
        int N = 32;
        cosDelta = new double[N];
        sinDelta = new double[N];
        for (int i = 1; i < N; ++i) {
            double delta = Math.PI * -2 / (double)(1 << i);
            FFT.cosDelta[i] = Math.cos(delta);
            FFT.sinDelta[i] = Math.sin(delta);
        }
    }
}

