/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.parser.ParserModelLoader;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.Parser;
import opennlp.tools.parser.ParserFactory;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;

public final class ParserTool
implements CmdLineTool {
    private static Pattern untokenizedParenPattern1 = Pattern.compile("([^ ])([({)}])");
    private static Pattern untokenizedParenPattern2 = Pattern.compile("([({)}])([^ ])");

    public String getName() {
        return "Parser";
    }

    public String getShortDescription() {
        return "performs full syntactic parsing";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " [-bs n -ap n -k n] model < sentences \n" + "-bs n: Use a beam size of n.\n" + "-ap f: Advance outcomes in with at least f% of the probability mass.\n" + "-k n: Show the top n parses.  This will also display their log-probablities.";
    }

    public static Parse[] parseLine(String line, Parser parser, int numParses) {
        line = untokenizedParenPattern1.matcher(line).replaceAll("$1 $2");
        line = untokenizedParenPattern2.matcher(line).replaceAll("$1 $2");
        StringTokenizer str = new StringTokenizer(line);
        StringBuffer sb = new StringBuffer();
        ArrayList<String> tokens = new ArrayList<String>();
        while (str.hasMoreTokens()) {
            String tok = str.nextToken();
            tokens.add(tok);
            sb.append(tok).append(" ");
        }
        String text = sb.substring(0, sb.length() - 1);
        Parse p = new Parse(text, new Span(0, text.length()), "INC", 1.0, 0);
        int start = 0;
        int i = 0;
        for (String tok : tokens) {
            p.insert(new Parse(text, new Span(start, start + tok.length()), "TK", 0.0, i));
            start += tok.length() + 1;
            ++i;
        }
        Parse[] parses = numParses == 1 ? new Parse[]{parser.parse(p)} : parser.parse(p, numParses);
        return parses;
    }

    public void run(String[] args) {
        boolean showTopK;
        Integer numParses;
        if (args.length < 1) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        ParserModel model = (ParserModel)new ParserModelLoader().load(new File(args[args.length - 1]));
        Integer beamSize = CmdLineUtil.getIntParameter("-bs", args);
        if (beamSize == null) {
            beamSize = 20;
        }
        if ((numParses = CmdLineUtil.getIntParameter("-k", args)) == null) {
            numParses = 1;
            showTopK = false;
        } else {
            showTopK = true;
        }
        Double advancePercentage = CmdLineUtil.getDoubleParameter("-ap", args);
        if (advancePercentage == null) {
            advancePercentage = 0.95;
        }
        Parser parser = ParserFactory.create(model, beamSize, advancePercentage);
        PlainTextByLineStream lineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
        PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "sent");
        perfMon.start();
        try {
            String line;
            while ((line = (String)lineStream.read()) != null) {
                if (line.length() == 0) {
                    System.out.println();
                    continue;
                }
                Parse[] parses = ParserTool.parseLine(line, parser, numParses);
                int pn = parses.length;
                for (int pi = 0; pi < pn; ++pi) {
                    if (showTopK) {
                        System.out.print(pi + " " + parses[pi].getProb() + " ");
                    }
                    parses[pi].show();
                    perfMon.incrementCounter();
                }
            }
        }
        catch (IOException e) {
            CmdLineUtil.handleStdinIoError(e);
        }
        perfMon.stopAndPrintFinalResult();
    }
}

