/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.Iterator;
import opennlp.tools.doccat.DocumentCategorizer;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.util.eval.Mean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentCategorizerEvaluator {
    private DocumentCategorizer categorizer;
    private Mean accuracy = new Mean();

    public DocumentCategorizerEvaluator(DocumentCategorizer categorizer) {
        this.categorizer = categorizer;
    }

    public void evaluteSample(DocumentSample sample) {
        String[] document = sample.getText();
        double[] probs = this.categorizer.categorize(document);
        String cat = this.categorizer.getBestCategory(probs);
        if (sample.getCategory().equals(cat)) {
            this.accuracy.add(1.0);
        } else {
            this.accuracy.add(0.0);
        }
    }

    public void evaluate(Iterator<DocumentSample> samples) {
        while (samples.hasNext()) {
            this.evaluteSample(samples.next());
        }
    }

    public double getAccuracy() {
        return this.accuracy.mean();
    }

    public String toString() {
        return "Accuracy: " + this.accuracy.mean() + "\n" + "Number of documents: " + this.accuracy.count();
    }
}

