/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.Conll03NameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conll03NameSampleStreamFactory
implements ObjectStreamFactory<NameSample> {
    @Override
    public String getUsage() {
        return ArgumentParser.createUsage(Parameters.class);
    }

    @Override
    public boolean validateArguments(String[] args) {
        return ArgumentParser.validateArguments(args, Parameters.class);
    }

    @Override
    public ObjectStream<NameSample> create(String[] args) {
        Conll03NameSampleStream.LANGUAGE lang;
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        if ("en".equals(params.getLang())) {
            lang = Conll03NameSampleStream.LANGUAGE.EN;
        } else if ("de".equals(params.getLang())) {
            lang = Conll03NameSampleStream.LANGUAGE.DE;
        } else {
            System.err.println("Unsupported language: " + params.getLang());
            throw new TerminateToolException(-1);
        }
        int typesToGenerate = 0;
        if (params.getTypes().contains("per")) {
            typesToGenerate |= 1;
        }
        if (params.getTypes().contains("org")) {
            typesToGenerate |= 2;
        }
        if (params.getTypes().contains("loc")) {
            typesToGenerate |= 4;
        }
        if (params.getTypes().contains("misc")) {
            typesToGenerate |= 8;
        }
        return new Conll03NameSampleStream(lang, CmdLineUtil.openInFile(new File(params.getData())), typesToGenerate);
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="en|de")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="sampleData")
        public String getData();

        @ArgumentParser.ParameterDescription(valueName="per,loc,org,misc")
        public String getTypes();
    }
}

