/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize.lang.en;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenSampleStream
implements Iterator<TokenSample> {
    private BufferedReader in;
    private String line;
    private Pattern alphaNumeric = Pattern.compile("[A-Za-z0-9]");
    private boolean evenq = true;

    public TokenSampleStream(InputStream is) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(is));
        this.line = this.in.readLine();
    }

    @Override
    public boolean hasNext() {
        return this.line != null;
    }

    @Override
    public TokenSample next() {
        String[] tokens = this.line.split("\\s+");
        if (tokens.length == 0) {
            this.evenq = true;
        }
        StringBuffer sb = new StringBuffer(this.line.length());
        ArrayList<Span> spans = new ArrayList<Span>();
        int length = 0;
        for (int ti = 0; ti < tokens.length; ++ti) {
            String lastToken;
            String token = tokens[ti];
            String string = lastToken = ti - 1 >= 0 ? tokens[ti - 1] : "";
            if (token.equals("-LRB-")) {
                token = "(";
            } else if (token.equals("-LCB-")) {
                token = "{";
            } else if (token.equals("-RRB-")) {
                token = ")";
            } else if (token.equals("-RCB-")) {
                token = "}";
            }
            if (sb.length() != 0) {
                if (!this.alphaNumeric.matcher(token).find() || token.startsWith("'") || token.equalsIgnoreCase("n't")) {
                    if ((token.equals("``") || token.equals("--") || token.equals("$") || token.equals("(") || token.equals("&") || token.equals("#") || token.equals("\"") && this.evenq && ti != tokens.length - 1) && (!lastToken.equals("(") || !lastToken.equals("{"))) {
                        ++length;
                    }
                } else if (!(lastToken.equals("``") || lastToken.equals("\"") && !this.evenq || lastToken.equals("(") || lastToken.equals("{") || lastToken.equals("$") || lastToken.equals("#"))) {
                    ++length;
                }
            }
            if (token.equals("\"")) {
                if (ti == tokens.length - 1) {
                    this.evenq = true;
                } else {
                    boolean bl = this.evenq = !this.evenq;
                }
            }
            if (sb.length() < length) {
                sb.append(" ");
            }
            sb.append(token);
            spans.add(new Span(length, length + token.length()));
            length += token.length();
        }
        try {
            this.line = this.in.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.line = null;
        }
        return new TokenSample(sb.toString(), spans.toArray(new Span[spans.size()]));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static void usage() {
        System.err.println("TokenSampleStream [-spans] < in");
        System.err.println("Where in is a space delimited list of tokens.");
    }

    public static void main(String[] args) throws IOException {
        boolean showSpans = false;
        for (int ai = 0; ai < args.length; ++ai) {
            if (args[ai].equals("-spans")) {
                showSpans = true;
                continue;
            }
            System.err.println("Unknown option " + args[ai]);
            TokenSampleStream.usage();
        }
        TokenSampleStream tss = new TokenSampleStream(System.in);
        while (tss.hasNext()) {
            TokenSample ts = tss.next();
            String text = ts.getText();
            System.out.println(text);
            Span[] tokenSpans = ts.getTokenSpans();
            int ti = 0;
            if (!showSpans) continue;
            for (int i = 0; i < text.length(); ++i) {
                if (ti - 1 >= 0 && i == tokenSpans[ti - 1].getEnd() - 1) {
                    System.out.print("]");
                    continue;
                }
                if (i == tokenSpans[ti].getStart()) {
                    if (++ti - 1 >= 0 && i == tokenSpans[ti - 1].getEnd() - 1) {
                        System.out.print("|");
                        continue;
                    }
                    System.out.print("[");
                    continue;
                }
                System.out.print("-");
            }
            System.out.println();
        }
    }
}

