/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapidminer.Process;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroHandler {
    private static final String[] PREDEFINED_MACROS = new String[]{"experiment_name", "experiment_file", "experiment_path", "process_name", "process_file", "process_path"};
    private static final int EXPERIMENT_NAME = 0;
    private static final int EXPERIMENT_FILE = 1;
    private static final int EXPERIMENT_PATH = 2;
    private static final int PROCESS_NAME = 3;
    private static final int PROCESS_FILE = 4;
    private static final int PROCESS_PATH = 5;
    private Process process;
    private Map<String, String> macroMap = new HashMap<String, String>();

    public MacroHandler(Process process) {
        this.process = process;
    }

    public void clear() {
        this.macroMap.clear();
    }

    public Iterator<String> getDefinedMacroNames() {
        return this.macroMap.keySet().iterator();
    }

    public void addMacro(String macro, String value) {
        this.macroMap.put(macro, value);
    }

    public void removeMacro(String macro) {
        this.macroMap.remove(macro);
    }

    public String getMacro(String macro) {
        int i = 0;
        while (i < PREDEFINED_MACROS.length) {
            if (PREDEFINED_MACROS[i].equals(macro)) {
                switch (i) {
                    case 0: 
                    case 3: {
                        String fileName = this.process.getProcessFile().getName();
                        return fileName.substring(0, fileName.lastIndexOf("."));
                    }
                    case 1: 
                    case 4: {
                        return this.process.getProcessFile().getName();
                    }
                    case 2: 
                    case 5: {
                        return this.process.getProcessFile().getAbsolutePath();
                    }
                }
            }
            ++i;
        }
        return this.macroMap.get(macro);
    }

    public String toString() {
        return this.macroMap.toString();
    }
}

