/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapidminer.BreakpointListener;
import com.rapidminer.LoggingListener;
import com.rapidminer.MacroHandler;
import com.rapidminer.RapidMiner;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.UnknownParameterInformation;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.report.ReportStream;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.ResultService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Process
implements Cloneable {
    public static final int PROCESS_STATE_UNKNOWN = -1;
    public static final int PROCESS_STATE_STOPPED = 0;
    public static final int PROCESS_STATE_PAUSED = 1;
    public static final int PROCESS_STATE_RUNNING = 2;
    private ProcessRootOperator rootOperator = null;
    private Operator currentOperator;
    private File processFile;
    private List<UnknownParameterInformation> unknownParameterInformation = new LinkedList<UnknownParameterInformation>();
    private List<BreakpointListener> breakpointListeners = new LinkedList<BreakpointListener>();
    private List<LoggingListener> loggingListeners = new LinkedList<LoggingListener>();
    private MacroHandler macroHandler = new MacroHandler(this);
    private Map<String, Operator> operatorNameMap = new HashMap<String, Operator>();
    private Map<String, DataTable> dataTableMap = new HashMap<String, DataTable>();
    private Map<String, ReportStream> reportStreamMap = new HashMap<String, ReportStream>();
    private Map<String, IOObject> storageMap = new HashMap<String, IOObject>();
    private int processState = 0;
    private LogService logService = LogService.getGlobal();
    private Object breakpointLock = new Object();

    public Process() {
        try {
            ProcessRootOperator root = (ProcessRootOperator)OperatorService.createOperator("Process");
            root.rename("Root");
            this.setRootOperator(root);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize root operator of the process: " + e.getMessage(), e);
        }
    }

    public Process(File file) throws IOException, XMLException {
        Reader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(file), Process.getEncoding(null));
            this.readProcess(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        this.processFile = file;
    }

    public Process(String xmlString) throws IOException, XMLException {
        StringReader in = new StringReader(xmlString);
        this.readProcess(in);
        in.close();
    }

    public Process(Reader in) throws IOException, XMLException {
        this.readProcess(in);
    }

    public Process(InputStream in) throws IOException, XMLException {
        this.readProcess(new InputStreamReader(in, Process.getEncoding(null)));
    }

    public Process(URL url) throws IOException, XMLException {
        InputStreamReader in = new InputStreamReader(url.openStream(), Process.getEncoding(null));
        this.readProcess(in);
        ((Reader)in).close();
    }

    private Process(Process other) {
        this();
        this.setRootOperator((ProcessRootOperator)other.rootOperator.cloneOperator(other.rootOperator.getName()));
        this.currentOperator = null;
        this.processFile = other.processFile != null ? new File(other.processFile.getAbsolutePath()) : null;
    }

    public void setupFromXML(String xmlString) throws IOException, XMLException {
        StringReader in = new StringReader(xmlString);
        this.readProcess(in);
        in.close();
    }

    private void initLogging(int logVerbosity) {
        try {
            this.logService = new LogService(this, logVerbosity);
        }
        catch (UndefinedParameterError e) {
            this.logService = LogService.getGlobal();
        }
    }

    public Object clone() {
        return new Process(this);
    }

    @Deprecated
    public synchronized void setExperimentState(int state) {
        this.setProcessState(state);
    }

    private void setProcessState(int state) {
        this.processState = state;
    }

    @Deprecated
    public synchronized int getExperimentState() {
        return this.getProcessState();
    }

    public int getProcessState() {
        return this.processState;
    }

    public LogService getLog() {
        return this.logService;
    }

    public MacroHandler getMacroHandler() {
        return this.macroHandler;
    }

    public void clearMacros() {
        this.macroHandler.clear();
    }

    public void store(String name, IOObject object) {
        this.storageMap.put(name, object);
    }

    public IOObject retrieve(String name, boolean remove) {
        if (remove) {
            return this.storageMap.remove(name);
        }
        return this.storageMap.get(name);
    }

    public void clearStorage() {
        this.storageMap.clear();
    }

    public void addLoggingListener(LoggingListener loggingListener) {
        this.loggingListeners.add(loggingListener);
    }

    public void removeLoggingListener(LoggingListener loggingListener) {
        this.loggingListeners.remove(loggingListener);
    }

    public boolean dataTableExists(String name) {
        return this.dataTableMap.get(name) != null;
    }

    public void addDataTable(DataTable table) {
        this.dataTableMap.put(table.getName(), table);
        for (LoggingListener listener : this.loggingListeners) {
            listener.addDataTable(table);
        }
    }

    public void clearDataTable(String name) {
        DataTable table = this.getDataTable(name);
        if (table != null && table instanceof SimpleDataTable) {
            ((SimpleDataTable)table).clear();
        }
    }

    public void deleteDataTable(String name) {
        if (this.dataTableExists(name)) {
            DataTable table = this.dataTableMap.remove(name);
            for (LoggingListener listener : this.loggingListeners) {
                listener.removeDataTable(table);
            }
        }
    }

    public DataTable getDataTable(String name) {
        return this.dataTableMap.get(name);
    }

    public Collection<DataTable> getDataTables() {
        return this.dataTableMap.values();
    }

    private void clearDataTables() {
        this.dataTableMap.clear();
    }

    public void addReportStream(ReportStream stream) {
        this.reportStreamMap.put(stream.getName(), stream);
    }

    public ReportStream getReportStream(String name) {
        if (name == null || name.length() == 0) {
            if (this.reportStreamMap.size() == 1) {
                return this.reportStreamMap.values().iterator().next();
            }
            return null;
        }
        return this.reportStreamMap.get(name);
    }

    public void removeReportStream(String name) {
        this.reportStreamMap.remove(name);
    }

    public void clearReportStreams() {
        this.reportStreamMap.clear();
    }

    public void setRootOperator(ProcessRootOperator root) {
        this.rootOperator = root;
        this.operatorNameMap.clear();
        this.rootOperator.setProcess(this);
    }

    public ProcessRootOperator getRootOperator() {
        return this.rootOperator;
    }

    @Deprecated
    public File getExperimentFile() {
        return this.getProcessFile();
    }

    public File getProcessFile() {
        return this.processFile;
    }

    public Operator getOperator(String name) {
        return this.operatorNameMap.get(name);
    }

    public Operator getCurrentOperator() {
        return this.currentOperator;
    }

    public Collection<Operator> getAllOperators() {
        List<Operator> result = this.rootOperator.getAllInnerOperators();
        result.add(0, this.rootOperator);
        return result;
    }

    public Collection<String> getAllOperatorNames() {
        LinkedList<String> allNames = new LinkedList<String>();
        for (Operator o : this.getAllOperators()) {
            allNames.add(o.getName());
        }
        return allNames;
    }

    public void setCurrentOperator(Operator operator) {
        this.currentOperator = operator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(Operator operator, IOContainer iocontainer, int breakpointType) {
        this.setProcessState(1);
        this.fireBreakpointEvent(operator, iocontainer, breakpointType);
        while (this.getProcessState() == 1) {
            Object object = this.breakpointLock;
            synchronized (object) {
                try {
                    this.breakpointLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.setProcessState(2);
        Object object = this.breakpointLock;
        synchronized (object) {
            this.breakpointLock.notifyAll();
        }
        this.fireResumeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.setProcessState(0);
        Object object = this.breakpointLock;
        synchronized (object) {
            this.breakpointLock.notifyAll();
        }
    }

    public boolean shouldStop() {
        return this.getProcessState() == 0;
    }

    public void addBreakpointListener(BreakpointListener listener) {
        this.breakpointListeners.add(listener);
    }

    public void removeBreakpointListener(BreakpointListener listener) {
        this.breakpointListeners.remove(listener);
    }

    private void fireBreakpointEvent(Operator operator, IOContainer ioContainer, int location) {
        for (BreakpointListener l : this.breakpointListeners) {
            l.breakpointReached(this, operator, ioContainer, location);
        }
    }

    public void fireResumeEvent() {
        Iterator<BreakpointListener> i = this.breakpointListeners.iterator();
        while (i.hasNext()) {
            i.next().resume();
        }
    }

    public List<UnknownParameterInformation> getUnknownParameters() {
        return this.unknownParameterInformation;
    }

    public void clearUnknownParameters() {
        this.unknownParameterInformation.clear();
    }

    private int checkIO(IOContainer inputContainer) {
        IOObject[] inputObjects = inputContainer.getIOObjects();
        Class[] inputClasses = new Class[inputObjects.length];
        int i = 0;
        while (i < inputObjects.length) {
            inputClasses[i] = inputObjects[i].getClass();
            ++i;
        }
        this.logService.log("Checking i/o classes...", 3);
        try {
            Class<?>[] output = this.rootOperator.checkIO(inputClasses);
            if (output.length == 0) {
                this.logService.log("i/o classes are ok.", 3);
            } else {
                StringBuffer left = new StringBuffer();
                int i2 = 0;
                while (i2 < output.length) {
                    left.append(Tools.classNameWOPackage(output[i2]));
                    if (i2 < output.length - 1) {
                        left.append(", ");
                    }
                    ++i2;
                }
                this.logService.log("i/o classes are ok. Process output: " + left.toString() + ".", 3);
            }
            return 0;
        }
        catch (IllegalInputException e) {
            if (e.getOperator() != null) {
                e.getOperator().addError(e.getMessage());
            }
            return 1;
        }
        catch (WrongNumberOfInnerOperatorsException e) {
            if (e.getOperator() != null) {
                e.getOperator().addError(e.getMessage());
            }
            return 1;
        }
    }

    private int checkNumberOfInnerOperators() {
        this.logService.log("Checking process setup...", 3);
        int errorCount = this.rootOperator.checkNumberOfInnerOperators();
        if (errorCount == 0) {
            this.logService.log("Inner operators are ok.", 3);
        } else {
            this.logService.log("Process setup not ok", 6);
        }
        return errorCount;
    }

    private int checkProperties() {
        this.logService.log("Checking properties...", 3);
        int errorCount = this.rootOperator.checkProperties();
        if (errorCount == 0) {
            this.logService.log("Properties are ok.", 3);
        } else {
            this.logService.log("Properties are not ok", 6);
        }
        return errorCount;
    }

    private int performAdditionalChecks() {
        try {
            this.rootOperator.performAdditionalChecks();
            return 0;
        }
        catch (UserError e) {
            this.logService.log(e.getMessage(), 6);
            return 1;
        }
    }

    @Deprecated
    public boolean checkExperiment(IOContainer inputContainer) {
        return this.checkProcess(inputContainer);
    }

    public boolean checkProcess(IOContainer inputContainer) {
        boolean ok = true;
        this.rootOperator.clearErrorList();
        int errorCount = this.checkProperties();
        if ((errorCount += this.checkNumberOfInnerOperators()) == 0) {
            errorCount += this.performAdditionalChecks();
        }
        if (errorCount == 0) {
            errorCount += this.checkIO(inputContainer);
        }
        if (errorCount == 0) {
            this.logService.log("Process ok.", 3);
        } else {
            String errorMessage = null;
            errorMessage = errorCount == 1 ? "There was 1 error." : "There were " + errorCount + " errors.";
            this.logService.log(errorMessage, 6);
            ok = false;
        }
        int deprecationCount = this.rootOperator.checkDeprecations();
        if (deprecationCount > 0) {
            this.logService.log("Deprecations: " + deprecationCount + (deprecationCount == 1 ? " usage" : " usages") + " of deprecated operators.", 5);
        }
        return ok;
    }

    private final void prepareRun(IOContainer inputContainer, int logVerbosity, boolean cleanUp) throws OperatorException {
        if (cleanUp) {
            RapidMiner.cleanUp();
        }
        this.initLogging(logVerbosity);
        this.setProcessState(2);
        this.logService.log("Initialising process setup", 3);
        RandomGenerator.init(this);
        ResultService.init(this);
        this.checkProcess(inputContainer);
        this.clearDataTables();
        this.clearReportStreams();
        this.clearMacros();
        this.clearStorage();
        AttributeFactory.resetNameCounters();
        this.logService.log("Process initialised", 3);
    }

    public final IOContainer run() throws OperatorException {
        return this.run(new IOContainer());
    }

    public final IOContainer run(int logVerbosity) throws OperatorException {
        return this.run(new IOContainer(), logVerbosity, true);
    }

    public final IOContainer run(IOContainer input) throws OperatorException {
        return this.run(input, -1, true);
    }

    public final IOContainer run(IOContainer input, int logVerbosity) throws OperatorException {
        return this.run(input, logVerbosity, true);
    }

    public final IOContainer run(IOContainer input, boolean cleanUp) throws OperatorException {
        return this.run(input, -1, cleanUp);
    }

    public final IOContainer run(IOContainer input, int logVerbosity, boolean cleanUp) throws OperatorException {
        this.setProcessState(2);
        this.prepareRun(input, logVerbosity, cleanUp);
        long start = System.currentTimeMillis();
        this.logService.log("Process starts", 4);
        this.logService.log("Process:" + Tools.getLineSeparator() + this.getRootOperator().createProcessTree(3), 3);
        this.rootOperator.processStarts();
        try {
            IOContainer result = this.rootOperator.apply(input);
            long end = System.currentTimeMillis();
            this.logService.log("Process:" + Tools.getLineSeparator() + this.getRootOperator().createProcessTree(3), 3);
            this.logService.log("Produced output:" + Tools.getLineSeparator() + result, 3);
            this.logService.log("Process finished successfully after " + Tools.formatDuation(end - start), 4);
            IOContainer iOContainer = result;
            return iOContainer;
        }
        catch (OperatorException e) {
            throw e;
        }
        finally {
            this.tearDown();
            this.setProcessState(0);
        }
    }

    private void tearDown() {
        try {
            if (!this.shouldStop()) {
                this.rootOperator.processFinished();
            }
        }
        catch (OperatorException e) {
            this.logService.log("Problem during finishing the process: " + e.getMessage(), 6);
        }
        this.clearMacros();
        this.clearReportStreams();
        this.clearStorage();
        this.clearUnknownParameters();
        ResultService.close();
        this.logService.flush();
        this.logService = LogService.getGlobal();
    }

    public static Charset getEncoding(String encoding) {
        if (encoding == null && ((encoding = System.getProperty("rapidminer.general.encoding")) == null || encoding.trim().length() == 0)) {
            encoding = "SYSTEM";
        }
        Charset result = null;
        if ("SYSTEM".equals(encoding)) {
            result = Charset.defaultCharset();
        } else {
            try {
                result = Charset.forName(encoding);
            }
            catch (IllegalCharsetNameException e) {
                result = Charset.defaultCharset();
            }
            catch (UnsupportedCharsetException e) {
                result = Charset.defaultCharset();
            }
            catch (IllegalArgumentException e) {
                result = Charset.defaultCharset();
            }
        }
        return result;
    }

    public void save() throws IOException {
        this.save(this.processFile);
    }

    public void save(File file) throws IOException {
        Charset encoding = this.rootOperator.getEncoding();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            writer.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            writer.println("<process version=\"" + RapidMiner.getShortVersion() + "\">" + Tools.getLineSeparator());
            this.rootOperator.writeXML(writer, "  ", false);
            writer.println("</process>");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        this.logService.log("Finished writing of process definition file '" + file + "'.", 2);
    }

    @Deprecated
    public void setExperimentFile(File file) {
        this.setProcessFile(file);
    }

    public void setProcessFile(File file) {
        this.processFile = file;
    }

    public File resolveFileName(String name) {
        File workingDir = new File(System.getProperty("user.dir"));
        return Tools.getFile(this.processFile != null ? this.processFile.getParentFile() : workingDir, name);
    }

    public void readProcess(Reader in) throws XMLException, IOException {
        Map<String, Operator> nameMapBackup = this.operatorNameMap;
        this.operatorNameMap = new HashMap<String, Operator>();
        try {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(in));
                Element processElement = document.getDocumentElement();
                Element rootOperatorElement = null;
                if (processElement.getTagName().equals("process") || processElement.getTagName().equals("experiment")) {
                    NodeList children = processElement.getChildNodes();
                    int i = 0;
                    while (i < children.getLength()) {
                        Element childElement;
                        Node childNode = children.item(i);
                        if (childNode instanceof Element && (childElement = (Element)childNode).getTagName().equals("operator")) {
                            rootOperatorElement = childElement;
                            break;
                        }
                        ++i;
                    }
                    if (rootOperatorElement == null) {
                        throw new XMLException("The <process> tag must contain exactly one inner operator of type 'Process'!");
                    }
                    String version = processElement.getAttribute("version");
                    if (version != null) {
                        LogService.getGlobal().log("Reading process definition (version: " + version + ")");
                    }
                } else if (processElement.getTagName().equals("operator")) {
                    rootOperatorElement = processElement;
                } else {
                    throw new XMLException("Outermost tag of a process definition must be either <process> or <operator>!");
                }
                this.unknownParameterInformation.clear();
                Operator root = Operator.createFromXML(rootOperatorElement, this.unknownParameterInformation);
                if (!(root instanceof ProcessRootOperator)) {
                    throw new XMLException("Outermost operator must be of type 'Process'!");
                }
                this.rootOperator = (ProcessRootOperator)root;
                this.setRootOperator(this.rootOperator);
                nameMapBackup = this.operatorNameMap;
            }
            catch (ParserConfigurationException e) {
                throw new XMLException(e.toString(), e);
            }
            catch (SAXException e) {
                throw new XMLException("Cannot parse document: " + e, e);
            }
        }
        finally {
            this.operatorNameMap = nameMapBackup;
        }
    }

    public String registerName(String name, Operator operator) {
        if (this.operatorNameMap.get(name) != null) {
            String baseName = name;
            int index = baseName.indexOf(" (");
            if (index >= 0) {
                baseName = baseName.substring(0, index);
            }
            int i = 2;
            while (this.operatorNameMap.get(String.valueOf(baseName) + " (" + i + ")") != null) {
                ++i;
            }
            String newName = String.valueOf(baseName) + " (" + i + ")";
            this.operatorNameMap.put(newName, operator);
            return newName;
        }
        this.operatorNameMap.put(name, operator);
        return name;
    }

    public void unregisterName(String name) {
        this.operatorNameMap.remove(name);
    }

    public int notifyRenaming(String oldName, String newName) {
        return this.notifyRenaming(this.rootOperator, oldName, newName);
    }

    private int notifyRenaming(Operator operator, String oldName, String newName) {
        Parameters parameters = operator.getParameters();
        int count = parameters.notifyRenaming(oldName, newName);
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            int i = 0;
            while (i < chain.getNumberOfAllOperators()) {
                Operator child = chain.getOperatorFromAll(i);
                count += this.notifyRenaming(child, oldName, newName);
                ++i;
            }
        }
        return count;
    }

    public String toString() {
        if (this.rootOperator == null) {
            return "empty process";
        }
        return "Process:" + Tools.getLineSeparator() + this.rootOperator.getXML("", true);
    }
}

