/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.DataRow;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseDataRow
extends DataRow {
    private static final long serialVersionUID = 4043965829002723585L;
    private transient ResultSet resultSet;
    private int row;
    private Attribute lastAttribute = null;

    public DatabaseDataRow(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        this.row = resultSet.getRow();
    }

    private void ensureRowCorrect() throws SQLException {
        if (this.row != this.resultSet.getRow()) {
            throw new RuntimeException("DatabaseDataRow: ResultSet was modified since creation of row!");
        }
    }

    public double get(Attribute attribute) {
        try {
            this.ensureRowCorrect();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot read data: " + e);
        }
        this.lastAttribute = attribute;
        double value = attribute.getValue(this);
        this.lastAttribute = null;
        return value;
    }

    public void set(Attribute attribute, double value) {
        try {
            this.ensureRowCorrect();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot update data: " + e, e);
        }
        this.lastAttribute = attribute;
        attribute.setValue(this, value);
        this.lastAttribute = null;
    }

    protected double get(int index, double defaultValue) {
        if (this.lastAttribute == null) {
            throw new RuntimeException("Cannot read data, please use get(Attribute) method instead of get(int, double) in DatabaseDataRow.");
        }
        try {
            return DatabaseDataRow.readColumn(this.resultSet, this.lastAttribute);
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot read data: " + e, e);
        }
    }

    protected void set(int index, double value, double defaultValue) {
        try {
            String name = this.lastAttribute.getName();
            if (Double.isNaN(value)) {
                this.resultSet.updateNull(name);
            } else if (this.lastAttribute.isNominal()) {
                this.resultSet.updateString(name, this.lastAttribute.getMapping().mapIndex((int)value));
            } else {
                this.resultSet.updateDouble(name, value);
            }
            this.resultSet.updateRow();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot update data: " + e, e);
        }
    }

    protected void ensureNumberOfColumns(int numberOfColumns) {
    }

    public void trim() {
    }

    public String toString() {
        return "Database Data Row";
    }

    public static double readColumn(ResultSet resultSet, Attribute attribute) throws SQLException {
        String name = attribute.getName();
        if (attribute.isNominal()) {
            String dbString = resultSet.getString(name);
            if (dbString == null) {
                return Double.NaN;
            }
            return attribute.getMapping().mapString(dbString);
        }
        double value = resultSet.getDouble(name);
        if (resultSet.wasNull()) {
            return Double.NaN;
        }
        return value;
    }
}

