/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.generator.BinaryNumericalGenerator;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.tools.LogService;

public class MinMaxGenerator
extends BinaryNumericalGenerator {
    public static final int MIN = 0;
    public static final int MAX = 1;
    private static final String[] FUNCTION_NAMES = new String[]{"min", "max"};
    private int mode;

    public MinMaxGenerator(int mode) {
        this.mode = mode;
    }

    public MinMaxGenerator() {
    }

    public Attribute[] getOutputAttributes(ExampleTable input) {
        Attribute a1 = this.getArgument(0);
        Attribute a2 = this.getArgument(1);
        Attribute ao = AttributeFactory.createAttribute(2, 1, String.valueOf(this.getFunction()) + "(" + a1.getConstruction() + "," + a2.getConstruction() + ")");
        return new Attribute[]{ao};
    }

    public boolean isSelfApplicable() {
        return false;
    }

    public boolean isCommutative() {
        return true;
    }

    public FeatureGenerator newInstance() {
        return new MinMaxGenerator(this.mode);
    }

    public double calculateValue(double value1, double value2) {
        double r = 0.0;
        switch (this.mode) {
            case 0: {
                r = Math.min(value1, value2);
                break;
            }
            case 1: {
                r = Math.max(value1, value2);
            }
        }
        return r;
    }

    public void setFunction(String name) {
        int i = 0;
        while (i < FUNCTION_NAMES.length) {
            if (FUNCTION_NAMES[i].equals(name)) {
                this.mode = i;
                return;
            }
            ++i;
        }
        LogService.getGlobal().log("Illegal function name '" + name + "' for " + this.getClass().getName() + ".", 6);
    }

    public String getFunction() {
        return FUNCTION_NAMES[this.mode];
    }

    public boolean equals(Object o) {
        return super.equals(o) && this.mode == ((MinMaxGenerator)o).mode;
    }

    public int hashCode() {
        return super.hashCode() ^ Integer.valueOf(this.mode).hashCode();
    }
}

