/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui;

import com.rapidminer.NoBugError;
import com.rapidminer.Process;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Tools;
import java.awt.Toolkit;

public class ProcessThread
extends Thread {
    private Process process;

    public ProcessThread(Process process) {
        super("ProcessThread");
        this.process = process;
    }

    public void run() {
        try {
            try {
                IOContainer results = this.process.run();
                ProcessThread.beep("success");
                this.process.getRootOperator().sendEmail(results, null);
                RapidMinerGUI.getMainFrame().processEnded(this.process, results);
            }
            catch (ProcessStoppedException ex) {
                this.process.getLog().log(ex.getMessage(), 2);
                this.process = null;
            }
            catch (Throwable e) {
                ProcessThread.beep("error");
                String debugProperty = System.getProperty("rapidminer.general.debugmode");
                boolean debugMode = Tools.booleanValue(debugProperty, false);
                String message = e.getMessage();
                if (!debugMode && e instanceof RuntimeException) {
                    message = e.getMessage() != null ? "operator cannot be executed (" + e.getMessage() + "). Check the log messages..." : "operator cannot be executed. Check the log messages...";
                }
                this.process.getLog().logFinalException("Process failed: " + message, this.process, e, debugMode);
                try {
                    this.process.getRootOperator().sendEmail(null, e);
                }
                catch (UndefinedParameterError ex) {
                    this.process.getLog().log("Problems during sending result mail: " + ex.getMessage(), 5);
                }
                if (e instanceof OutOfMemoryError) {
                    SwingTools.showVerySimpleErrorMessage("Process failed!\nThis process would need more than the maximum amount of available memory.\nYou can either leave the process as it is and use a computer with more memory,\nreduce the amount of data by one of the sampling operators,\noptimize the process by using other learning or preprocessing schemes, or\ndirectly work on database systems, e.g. by using the cached database example source operators.");
                } else if (e instanceof NoBugError) {
                    SwingTools.showFinalErrorMessage("Process failed", e);
                } else if (debugMode) {
                    SwingTools.showFinalErrorMessage("Process failed", e);
                } else {
                    int oldVerbosity = this.process.getLog().getVerbosityLevel();
                    this.process.getLog().setVerbosityLevel(9);
                    boolean errors = this.process.checkProcess(new IOContainer());
                    this.process.getLog().setVerbosityLevel(oldVerbosity);
                    if (errors) {
                        if (e instanceof NullPointerException || e instanceof ArrayIndexOutOfBoundsException) {
                            SwingTools.showVerySimpleErrorMessage("Process failed!\nThe setup does not seem to contain any obvious errors,\nbut you should check the log messages or activate the\ndebug mode in the settings dialog in order to get more\ninformation about this problem.");
                        } else {
                            SwingTools.showSimpleErrorMessage("Process failed", e);
                        }
                    } else {
                        SwingTools.showVerySimpleErrorMessage("Process failed!\nSince the setup seem to contain errors you should check the setup and the log messages.");
                    }
                }
                RapidMinerGUI.getMainFrame().processEnded(this.process, null);
                this.process = null;
            }
        }
        finally {
            this.process = null;
        }
    }

    public static void beep(String reason) {
        if (Tools.booleanValue(System.getProperty("rapidminer.gui.beep." + reason), false)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void stopProcess() {
        if (this.process != null) {
            this.process.stop();
        }
    }

    public String toString() {
        return "ProcessThread (" + this.process.getProcessFile() + ")";
    }
}

