/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class ToggleExpertModeAction
extends AbstractAction {
    private static final long serialVersionUID = 5545547954042596599L;
    private static final String EXPERT_ICON_NAME = "graduate.png";
    private static final String BEGINNER_ICON_NAME = "user1.png";
    private static final Icon[] EXPERT_MODE_ICONS;
    private static final Icon[] BEGINNER_MODE_ICONS;
    private IconSize iconSize;
    private MainFrame mainFrame;

    static {
        IconSize size;
        EXPERT_MODE_ICONS = new Icon[IconSize.values().length];
        BEGINNER_MODE_ICONS = new Icon[IconSize.values().length];
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = iconSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            size = iconSizeArray[n2];
            ToggleExpertModeAction.EXPERT_MODE_ICONS[counter++] = SwingTools.createIcon(String.valueOf(size.getSize()) + "/" + EXPERT_ICON_NAME);
            ++n2;
        }
        counter = 0;
        iconSizeArray = IconSize.values();
        n = iconSizeArray.length;
        n2 = 0;
        while (n2 < n) {
            size = iconSizeArray[n2];
            ToggleExpertModeAction.BEGINNER_MODE_ICONS[counter++] = SwingTools.createIcon(String.valueOf(size.getSize()) + "/" + BEGINNER_ICON_NAME);
            ++n2;
        }
    }

    public ToggleExpertModeAction(MainFrame mainFrame, IconSize size) {
        super("Expert Mode");
        this.iconSize = size;
        this.putValue("ShortDescription", "Switch to expert mode (all available parameters are visible)");
        this.putValue("MnemonicKey", 69);
        this.putValue("SmallIcon", EXPERT_MODE_ICONS[size.ordinal()]);
        this.mainFrame = mainFrame;
    }

    public void actionPerformed(ActionEvent e) {
        this.mainFrame.toggleExpertMode();
    }

    public void updateIcon() {
        if (this.mainFrame.getPropertyTable().isExpertMode()) {
            this.putValue("SmallIcon", BEGINNER_MODE_ICONS[this.iconSize.ordinal()]);
            this.putValue("ShortDescription", "Switch to beginner mode (only the most important parameters are shown)");
            this.putValue("Name", "Beginner Mode");
        } else {
            this.putValue("SmallIcon", EXPERT_MODE_ICONS[this.iconSize.ordinal()]);
            this.putValue("ShortDescription", "Switch to expert mode (all available parameters are visible)");
            this.putValue("Name", "Expert Mode");
        }
    }
}

