/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.Process;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.ParameterService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class Tutorial
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 2826577972132069114L;
    private static final String PREVIOUS_ICON_NAME = "arrow_left_blue.png";
    private static final String NEXT_ICON_NAME = "arrow_right_blue.png";
    private static Icon ICON_PREVIOUS = null;
    private static Icon ICON_NEXT = null;
    private static final String START_TEXT = "<h2>Welcome to the RapidMiner online tutorial!</h2><p>This tutorial demonstrates basic concepts of RapidMiner and simple process setups which can be performed. The user should have some knowledge in the domains of data mining and ETL.</p><p>Whenever this tutorial refers to the &quot;RapidMiner Tutorial&quot;, it means the printed version available at<br><br><center><code>http://rapid-i.com</code></center></p><p>You should read the first chapter of the RapidMiner Tutorial for better motivation, but you can also try to start with the online tutorial without reading the printed version. Please read the texts carefully and try at least the suggested steps. The online tutorial will take about one hour.</p><br><h4>Please note:</h4><p>Most parts of RapidMiner provide additional information if you hold the mouse pointer a few moments on the part (tool tip texts). In this way all operators and parameters are described too.</p>";
    private static final String END_TEXT = "<h2>Congratulations!</h2><p>You have finished the RapidMiner online tutorial. You should be able to perform many of the possible process definitions. Now, you know the most important building blocks of the possible data mining process definitions. Of course these building blocks can be arbitrarily nested in RapidMiner as long as their input and output types fits. For a reference of all operators please refer to the RapidMiner Tutorial. Check also the other sample process setups which can be found in the sample directory of RapidMiner.</p><p>We have added many known preprocessing steps and learning operators to RapidMiner. Most data formats can also be handled. If you need to adapt RapidMiner you should read the chapter of the RapidMiner Tutorial which describes the creation of operators and the extension mechanism. RapidMiner can easily be extended. Have fun!</p>";
    private static final String[] PROCESSES;
    private int state = 0;
    private MainFrame mainFrame;
    private JEditorPane description;
    private JScrollPane descriptionScrollPane;
    private JButton prevButton;
    private JButton nextButton;

    static {
        UIDefaults uiDefaults = UIManager.getDefaults();
        Font f = new Font("SansSerif", 0, 12);
        FontUIResource font = new FontUIResource(f);
        uiDefaults.put("EditorPane.font", font);
        ICON_PREVIOUS = SwingTools.createIcon("24/arrow_left_blue.png");
        ICON_NEXT = SwingTools.createIcon("24/arrow_right_blue.png");
        PROCESSES = new String[]{"Empty.xml", "01_IO" + File.separator + "01_ExampleSource.xml", "02_Learner" + File.separator + "01_DecisionTree.xml", "01_IO" + File.separator + "18_ModelWriter.xml", "01_IO" + File.separator + "19_ModelLoader.xml", "02_Learner" + File.separator + "12_AssociationRules.xml", "02_Learner" + File.separator + "19_Stacking.xml", "08_Clustering" + File.separator + "01_KMeans.xml", "01_IO" + File.separator + "03_Sparse.xml", "01_IO" + File.separator + "02_ArffExampleSource.xml", "01_IO" + File.separator + "26_ExcelExampleSource.xml", "06_Visualisation" + File.separator + "08_SVMVisualisation.xml", "03_Preprocessing" + File.separator + "07_MissingValueReplenishment.xml", "03_Preprocessing" + File.separator + "08_NoiseGenerator.xml", "03_Preprocessing" + File.separator + "15_ExampleSetJoin.xml", "04_Validation" + File.separator + "03_XValidation_Numerical.xml", "02_Learner" + File.separator + "14_CostSensitiveLearningAndROCPlot.xml", "02_Learner" + File.separator + "13_AsymmetricCostLearning.xml", "02_Learner" + File.separator + "18_SimpleCostSensitiveLearning.xml", "05_Features" + File.separator + "03_PrincipalComponents.xml", "05_Features" + File.separator + "10_ForwardSelection.xml", "05_Features" + File.separator + "12_WeightGuidedFeatureSelection.xml", "05_Features" + File.separator + "18_MultiobjectiveSelection.xml", "04_Validation" + File.separator + "12_WrapperValidation.xml", "05_Features" + File.separator + "19_YAGGA.xml", "05_Features" + File.separator + "20_YAGGAResultAttributeSetting.xml", "03_Preprocessing" + File.separator + "12_FeatureGenerationByUser.xml", "05_Features" + File.separator + "13_EvolutionaryWeighting.xml", "06_Visualisation" + File.separator + "07_DataSetAndWeightsVisualisation.xml", "01_IO" + File.separator + "21_PreprocessingModelWriter.xml", "01_IO" + File.separator + "22_PreprocessingModelLoader.xml", "07_Meta" + File.separator + "01_ParameterOptimization.xml", "07_Meta" + File.separator + "06_OperatorEnabler.xml", "05_Features" + File.separator + "17_WeightingThreshold.xml", "04_Validation" + File.separator + "13_SignificanceTest.xml", "07_Meta" + File.separator + "08_MacroDefinition.xml", "03_Preprocessing" + File.separator + "24_GroupBasedCalculations.xml"};
    }

    public Tutorial(MainFrame mainFrame) {
        super(mainFrame, "RapidMiner Tutorial", false);
        this.mainFrame = mainFrame;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout layout = new GridBagLayout();
        JPanel mainPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.ipadx = 10;
        c.ipady = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.description = new JEditorPane("text/html", SwingTools.text2DisplayHtml(START_TEXT));
        this.description.setEditable(false);
        this.description.setBackground(this.getBackground());
        this.descriptionScrollPane = new ExtendedJScrollPane(this.description);
        c.gridwidth = 0;
        layout.setConstraints(this.descriptionScrollPane, c);
        mainPanel.add(this.descriptionScrollPane);
        c.weighty = 0.0;
        rootPanel.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.prevButton = new JButton("Previous", ICON_PREVIOUS);
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Tutorial.this.previous();
            }
        });
        this.prevButton.setEnabled(false);
        buttonPanel.add(this.prevButton);
        this.nextButton = new JButton("Next", ICON_NEXT);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Tutorial.this.next();
            }
        });
        buttonPanel.add(this.nextButton);
        rootPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(rootPanel);
        this.pack();
        this.setSize(400, 600);
        this.setLocationRelativeTo(mainFrame);
        mainFrame.setTutorialMode(true);
    }

    private void setProcess(String process) {
        File expFile = ParameterService.getUserSampleFile(process);
        if (expFile == null || !expFile.exists()) {
            expFile = ParameterService.getSampleFile(process);
        }
        this.mainFrame.open(expFile, false);
        this.description.setText(SwingTools.text2DisplayHtml(RapidMinerGUI.getMainFrame().getProcess().getRootOperator().getUserDescription()));
        this.description.getCaret().setDot(0);
        this.descriptionScrollPane.getVerticalScrollBar().setValue(0);
    }

    private void previous() {
        this.nextButton.setEnabled(true);
        if (this.state > 0) {
            --this.state;
        }
        if (this.state == 0) {
            this.prevButton.setEnabled(false);
            this.description.setText(SwingTools.text2DisplayHtml(START_TEXT));
        } else {
            this.setProcess(PROCESSES[this.state - 1]);
        }
    }

    private void next() {
        this.prevButton.setEnabled(true);
        if (this.state < PROCESSES.length + 1) {
            ++this.state;
        }
        if (this.state == PROCESSES.length + 1) {
            this.nextButton.setEnabled(false);
            this.description.setText(SwingTools.text2DisplayHtml(END_TEXT));
        } else {
            this.setProcess(PROCESSES[this.state - 1]);
        }
    }

    private void close() {
        this.mainFrame.setProcess(new Process(), true);
        this.mainFrame.setTutorialMode(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

