/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.fc;

import com.rapidminer.gui.look.fc.Bookmark;
import com.rapidminer.gui.look.fc.BookmarkListModel;
import com.rapidminer.gui.look.fc.FileList;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BookmarkList
extends JList
implements ListSelectionListener,
MouseListener {
    private static final long serialVersionUID = -7109320787696008679L;
    private static final ListCellRenderer RENDERER = new BookmarkCellRenderer();
    private FileList fileList;

    public BookmarkList(BookmarkListModel model, FileList fileList) {
        super(model);
        this.fileList = fileList;
        this.addListSelectionListener(this);
        this.addMouseListener(this);
    }

    public ListCellRenderer getCellRenderer() {
        return RENDERER;
    }

    public void valueChanged(ListSelectionEvent e) {
        Bookmark selectedBookmark;
        if (!e.getValueIsAdjusting() && (selectedBookmark = (Bookmark)this.getSelectedValue()) != null) {
            String path = selectedBookmark.getPath();
            File bookmarkFile = new File(path);
            if (bookmarkFile.exists() && bookmarkFile.canRead()) {
                this.fileList.filechooserUI.setCurrentDirectoryOfFileChooser(bookmarkFile);
            } else {
                JOptionPane.showConfirmDialog(this.fileList.fc, "Cannot access selected bookmark directory.", "Cannot access directory", -1, 0);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int index = this.locationToIndex(e.getPoint());
        this.setSelectedIndex(index);
        this.evaluatePopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.evaluatePopup(e);
    }

    private void evaluatePopup(MouseEvent e) {
        JPopupMenu menu;
        if (e.isPopupTrigger() && (menu = this.createBookmarkPopupMenu()) != null) {
            menu.show(this, e.getX(), e.getY());
        }
    }

    private JPopupMenu createBookmarkPopupMenu() {
        final Bookmark bookmark = (Bookmark)this.getSelectedValue();
        if (bookmark != null) {
            JPopupMenu bookmarksPopup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Rename Bookmark");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BookmarkList.this.fileList.renameBookmark(bookmark);
                }
            });
            bookmarksPopup.add(menuItem);
            menuItem = new JMenuItem("Delete Bookmark");
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BookmarkList.this.fileList.deleteBookmark(bookmark);
                }
            });
            bookmarksPopup.add(menuItem);
            return bookmarksPopup;
        }
        return null;
    }

    private static class BookmarkCellRenderer
    implements ListCellRenderer {
        private JLabel label = new JLabel();

        public BookmarkCellRenderer() {
            this.label.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
            this.label.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Bookmark bookmark = (Bookmark)value;
            String name = bookmark.getName();
            String path = bookmark.getPath();
            if (isSelected) {
                this.label.setBackground(UIManager.getColor("List.selectionBackground"));
                this.label.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.label.setBackground(UIManager.getColor("List.background"));
                this.label.setForeground(UIManager.getColor("List.foreground"));
            }
            if (!new File(path).exists()) {
                this.label.setForeground(Color.GRAY);
            }
            this.label.setText(name);
            this.label.setToolTipText("<html><b>" + name + "</b><br>" + path + "</html>");
            return this.label;
        }
    }
}

