/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.painters;

import com.rapidminer.gui.look.painters.Cache;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCachedPainter {
    protected static final Map<Object, Cache> cacheMap = new HashMap<Object, Cache>();

    public AbstractCachedPainter(int cacheCount) {
        AbstractCachedPainter.getCache(this.getClass()).setMaxCount(cacheCount);
    }

    protected abstract void paintToImage(Component var1, Graphics var2, int var3, int var4, Object[] var5);

    public void paint(Component c, Graphics g, int x, int y, int w, int h, Object[] args) {
        if (w <= 0 || h <= 0) {
            return;
        }
        Class<?> key = this.getClass();
        GraphicsConfiguration config = c.getGraphicsConfiguration();
        Cache cache = AbstractCachedPainter.getCache(key);
        Image image = cache.getImage(key, config, w, h, args);
        int attempts = 0;
        do {
            boolean draw = false;
            if (image instanceof VolatileImage) {
                switch (((VolatileImage)image).validate(config)) {
                    case 2: {
                        ((VolatileImage)image).flush();
                        image = null;
                        break;
                    }
                    case 1: {
                        draw = true;
                    }
                }
            }
            if (image == null) {
                image = this.createImage(c, w, h, config);
                cache.setImage(key, config, w, h, args, image);
                draw = true;
            }
            if (draw) {
                Graphics g2 = image.getGraphics();
                this.paintToImage(c, g2, w, h, args);
                g2.dispose();
            }
            this.paintImage(c, g, x, y, w, h, image, args);
        } while (image instanceof VolatileImage && ((VolatileImage)image).contentsLost() && ++attempts < 3);
    }

    protected void paintImage(Component c, Graphics g, int x, int y, int w, int h, Image image, Object[] args) {
        g.drawImage(image, x, y, null);
    }

    protected Image createImage(Component c, int w, int h, GraphicsConfiguration config) {
        if (config == null) {
            return new BufferedImage(w, h, 6);
        }
        return config.createCompatibleImage(w, h, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<Object, Cache> map = cacheMap;
        synchronized (map) {
            cacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cache getCache(Object key) {
        Map<Object, Cache> map = cacheMap;
        synchronized (map) {
            Cache cache = cacheMap.get(key);
            if (cache == null) {
                cache = new Cache(1);
                cacheMap.put(key, cache);
            }
            return cache;
        }
    }
}

