/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.PlotterPanel;
import com.rapidminer.gui.plotter.charts.ChartPanelShiftController;
import com.rapidminer.gui.plotter.charts.CtrlChartPanel;
import com.rapidminer.gui.tools.ExtendedJList;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedListModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AverageFunction;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPieChartPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = 8750708105082707503L;
    private static final int MAX_CATEGORIES = 50;
    private DataTable dataTable;
    private DefaultPieDataset pieDataSet = new DefaultPieDataset();
    private int groupByColumn = -1;
    private int legendByColumn = -1;
    private int valueColumn = -1;
    private JCheckBox useDistinct = new JCheckBox("Use Only Distinct", false);
    private JComboBox aggregationFunction = null;
    private boolean absolute = false;
    private String[] explodingGroups = new String[0];
    private ExtendedJList explodingGroupList = new ExtendedJList(new ExtendedListModel(), 200);
    private JSlider explodingSlider = new JSlider(0, 0, 100, 0);
    private double explodingAmount = 0.0;
    private ChartPanel panel = new ChartPanel(null);

    public AbstractPieChartPlotter() {
        this.setBackground(Color.white);
        this.useDistinct.setToolTipText("Indicates if only distinct values should be used for aggregation functions.");
        this.useDistinct.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractPieChartPlotter.this.updatePlotter();
            }
        });
        String[] allFunctions = new String[AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length + 1];
        allFunctions[0] = "none";
        System.arraycopy(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 0, allFunctions, 1, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length);
        this.aggregationFunction = new JComboBox<String>(allFunctions);
        this.aggregationFunction.setToolTipText("Select the type of the aggregation function which should be used for grouped values.");
        this.aggregationFunction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractPieChartPlotter.this.updatePlotter();
            }
        });
        this.explodingGroupList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object[] values = AbstractPieChartPlotter.this.explodingGroupList.getSelectedValues();
                    String[] newGroups = new String[values.length];
                    int i = 0;
                    while (i < values.length) {
                        newGroups[i] = (String)values[i];
                        ++i;
                    }
                    AbstractPieChartPlotter.this.setExplodingGroups(newGroups);
                }
            }
        });
        this.explodingGroupList.setForeground(Color.BLACK);
        this.explodingGroupList.setSelectionMode(2);
        this.explodingGroupList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.explodingGroupList.setCellRenderer(new PlotterPanel.LineStyleCellRenderer(this));
        this.updateGroups();
        this.explodingSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AbstractPieChartPlotter.this.setExplodingAmount((double)AbstractPieChartPlotter.this.explodingSlider.getValue() / (double)AbstractPieChartPlotter.this.explodingSlider.getMaximum());
            }
        });
    }

    public AbstractPieChartPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    public abstract JFreeChart createChart(PieDataset var1, boolean var2);

    public abstract boolean isSupportingExplosion();

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.groupByColumn = -1;
        this.legendByColumn = -1;
        this.valueColumn = -1;
        this.absolute = false;
        this.explodingGroups = new String[0];
        this.explodingAmount = 0.0;
        this.updatePlotter();
    }

    @Override
    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
        this.updatePlotter();
    }

    public void setExplodingAmount(double amount) {
        this.explodingAmount = amount;
        this.updatePlotter();
    }

    public void setExplodingGroups(String[] groups) {
        this.explodingGroups = groups;
        this.updatePlotter();
    }

    @Override
    public boolean isSupportingAbsoluteValues() {
        return true;
    }

    @Override
    public void setPlotColumn(int index, boolean plot) {
        this.valueColumn = plot ? index : -1;
        this.updatePlotter();
    }

    @Override
    public boolean getPlotColumn(int index) {
        return this.valueColumn == index;
    }

    @Override
    public Icon getIcon(int index) {
        return null;
    }

    @Override
    public String getPlotName() {
        return "Value Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 2;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (index == 0) {
            this.groupByColumn = dimension;
            this.updateGroups();
        } else if (index == 1) {
            this.legendByColumn = dimension;
        }
        this.updatePlotter();
    }

    @Override
    public int getAxis(int index) {
        if (index == 0) {
            return this.groupByColumn;
        }
        if (index == 1) {
            return this.legendByColumn;
        }
        return -1;
    }

    @Override
    public String getAxisName(int index) {
        if (index == 0) {
            return "Group-By Column";
        }
        if (index == 1) {
            return "Legend Column";
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroups() {
        ExtendedListModel model;
        TreeSet<String> groups = new TreeSet<String>();
        if (this.groupByColumn >= 0) {
            DataTable dataTable = this.dataTable;
            synchronized (dataTable) {
                DataTableRow row;
                int i;
                if (this.dataTable.isDate(this.groupByColumn)) {
                    i = 0;
                    while (i < this.dataTable.getNumberOfRows()) {
                        row = this.dataTable.getRow(i);
                        groups.add(Tools.formatDate(new Date((long)row.getValue(this.groupByColumn))));
                        ++i;
                    }
                } else if (this.dataTable.isTime(this.groupByColumn)) {
                    i = 0;
                    while (i < this.dataTable.getNumberOfRows()) {
                        row = this.dataTable.getRow(i);
                        groups.add(Tools.formatTime(new Date((long)row.getValue(this.groupByColumn))));
                        ++i;
                    }
                } else if (this.dataTable.isDateTime(this.groupByColumn)) {
                    i = 0;
                    while (i < this.dataTable.getNumberOfRows()) {
                        row = this.dataTable.getRow(i);
                        groups.add(Tools.formatDateTime(new Date((long)row.getValue(this.groupByColumn))));
                        ++i;
                    }
                } else if (this.dataTable.isNominal(this.groupByColumn)) {
                    i = 0;
                    while (i < this.dataTable.getNumberOfRows()) {
                        row = this.dataTable.getRow(i);
                        groups.add(this.dataTable.mapIndex(this.groupByColumn, (int)row.getValue(this.groupByColumn)));
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < this.dataTable.getNumberOfRows()) {
                        row = this.dataTable.getRow(i);
                        groups.add(Tools.formatIntegerIfPossible(row.getValue(this.groupByColumn)));
                        ++i;
                    }
                }
            }
        }
        if (groups.size() > 0) {
            model = new ExtendedListModel();
            for (String group : groups) {
                model.addElement(group, "Select group '" + group + "' for explosion.");
            }
            this.explodingGroupList.setModel(model);
        } else {
            model = new ExtendedListModel();
            model.addElement("Specify 'Group By' first...");
            this.explodingGroupList.setModel(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int prepareData() {
        var1_1 = this.dataTable;
        synchronized (var1_1) {
            block19: {
                aggregation = null;
                if (this.aggregationFunction.getSelectedIndex() > 0) {
                    try {
                        aggregation = AbstractAggregationFunction.createAggregationFunction(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[this.aggregationFunction.getSelectedIndex() - 1]);
                    }
                    catch (Exception e) {
                        LogService.getGlobal().logWarning("Cannot instantiate aggregation function '" + this.aggregationFunction.getSelectedItem() + "', using 'average' as default.");
                        aggregation = new AverageFunction();
                    }
                }
                i = this.dataTable.iterator();
                categoryValues = new LinkedHashMap<String, TreeSet<Double>>();
                this.pieDataSet.clear();
                if (this.groupByColumn >= 0 && this.dataTable.isNumerical(this.groupByColumn)) {
                    return 0;
                }
                while (true) {
                    block20: {
                        if (i.hasNext()) break block20;
                        if (this.valueColumn < 0) break block19;
                        if (aggregation == null) break;
                        c = categoryValues.entrySet().iterator();
                        if (true) ** GOTO lbl78
                    }
                    row = i.next();
                    value = NaN;
                    if (this.valueColumn >= 0) {
                        value = row.getValue(this.valueColumn);
                    }
                    if (Double.isNaN(value)) continue;
                    if (this.absolute) {
                        value = Math.abs(value);
                    }
                    valueString = null;
                    valueString = this.dataTable.isDate(this.valueColumn) != false ? Tools.formatDate(new Date((long)value)) : (this.dataTable.isTime(this.valueColumn) != false ? Tools.formatTime(new Date((long)value)) : (this.dataTable.isDateTime(this.valueColumn) != false ? Tools.formatDateTime(new Date((long)value)) : (this.dataTable.isNominal(this.valueColumn) != false ? this.dataTable.mapIndex(this.valueColumn, (int)value) : Tools.formatIntegerIfPossible(value))));
                    legendName = String.valueOf(valueString);
                    if (this.legendByColumn >= 0) {
                        nameValue = row.getValue(this.legendByColumn);
                        legendName = this.dataTable.isDate(this.legendByColumn) != false ? Tools.formatDate(new Date((long)nameValue)) : (this.dataTable.isTime(this.legendByColumn) != false ? Tools.formatTime(new Date((long)nameValue)) : (this.dataTable.isDateTime(this.legendByColumn) != false ? Tools.formatDateTime(new Date((long)nameValue)) : (this.dataTable.isNominal(this.legendByColumn) != false ? String.valueOf(this.dataTable.mapIndex(this.legendByColumn, (int)nameValue)) + " (" + valueString + ")" : String.valueOf(Tools.formatIntegerIfPossible(nameValue)) + " (" + valueString + ")")));
                    }
                    groupByName = legendName;
                    if (this.groupByColumn >= 0) {
                        nameValue = row.getValue(this.groupByColumn);
                        groupByName = this.dataTable.isDate(this.groupByColumn) != false ? Tools.formatDate(new Date((long)nameValue)) : (this.dataTable.isTime(this.groupByColumn) != false ? Tools.formatTime(new Date((long)nameValue)) : (this.dataTable.isDateTime(this.groupByColumn) != false ? Tools.formatDateTime(new Date((long)nameValue)) : (this.dataTable.isNominal(this.groupByColumn) != false ? this.dataTable.mapIndex(this.groupByColumn, (int)nameValue) : String.valueOf(Tools.formatIntegerIfPossible(nameValue)))));
                    }
                    if ((values /* !! */  = (TreeSet<Double>)categoryValues.get(groupByName)) == null) {
                        values /* !! */  = this.useDistinct.isSelected() != false ? new TreeSet<Double>() : new LinkedList<E>();
                        categoryValues.put(groupByName, values /* !! */ );
                    }
                    values /* !! */ .add(value);
                }
                for (Map.Entry<K, V> entry : categoryValues.entrySet()) {
                    name = (String)entry.getKey();
                    values = (Collection)entry.getValue();
                    v = values.iterator();
                    while (v.hasNext()) {
                        value = (Double)v.next();
                        if (this.legendByColumn >= 0) {
                            this.pieDataSet.setValue((Comparable)name, value);
                            continue;
                        }
                        this.pieDataSet.setValue((Comparable)(String.valueOf(name) + " (" + Tools.formatIntegerIfPossible(value) + ")"), value);
                    }
                }
                break block19;
                do {
                    entry = c.next();
                    name = (String)entry.getKey();
                    values = (Collection)entry.getValue();
                    valueArray = new double[values.size()];
                    v = values.iterator();
                    valueIndex = 0;
                    while (v.hasNext()) {
                        valueArray[valueIndex++] = (Double)v.next();
                    }
                    value = aggregation.calculate(valueArray);
                    if (this.legendByColumn >= 0) {
                        this.pieDataSet.setValue((Comparable)name, value);
                        continue;
                    }
                    this.pieDataSet.setValue((Comparable)(String.valueOf(name) + " (" + Tools.formatIntegerIfPossible(value) + ")"), value);
lbl78:
                    // 3 sources

                } while (c.hasNext());
            }
            return categoryValues.size();
        }
    }

    @Override
    public JComponent getPlotter() {
        return this.panel;
    }

    public void updatePlotter() {
        boolean createLegend;
        int categoryCount = this.prepareData();
        String maxClassesProperty = System.getProperty("rapidminer.gui.plotter.legend.classlimit");
        int maxClasses = 20;
        try {
            if (maxClassesProperty != null) {
                maxClasses = Integer.parseInt(maxClassesProperty);
            }
        }
        catch (NumberFormatException e) {
            LogService.getGlobal().log("Pie Chart plotter: cannot parse property 'rapidminer.gui.plotter.colors.classlimit', using maximal 20 different classes.", 5);
        }
        boolean bl = createLegend = categoryCount > 0 && categoryCount < maxClasses;
        if (categoryCount <= 50) {
            JFreeChart chart = this.createChart((PieDataset)this.pieDataSet, createLegend);
            chart.setBackgroundPaint((Paint)Color.white);
            PiePlot plot = (PiePlot)chart.getPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setSectionOutlinesVisible(true);
            plot.setShadowPaint((Paint)new Color(104, 104, 104, 100));
            int size = this.pieDataSet.getKeys().size();
            int i = 0;
            while (i < size) {
                Comparable key = this.pieDataSet.getKey(i);
                plot.setSectionPaint(key, (Paint)this.getColorProvider().getPointColor((double)i / (double)(size - 1)));
                boolean explode = false;
                String[] stringArray = this.explodingGroups;
                int n = this.explodingGroups.length;
                int n2 = 0;
                while (n2 < n) {
                    String explosionGroup = stringArray[n2];
                    if (key.toString().startsWith(explosionGroup) || explosionGroup.startsWith(key.toString())) {
                        explode = true;
                        break;
                    }
                    ++n2;
                }
                if (explode) {
                    plot.setExplodePercent(key, this.explodingAmount);
                }
                ++i;
            }
            plot.setLabelFont(LABEL_FONT);
            plot.setNoDataMessage("No data available");
            plot.setCircular(false);
            plot.setLabelGap(0.02);
            plot.setOutlinePaint((Paint)Color.WHITE);
            LegendTitle legend = chart.getLegend();
            if (legend != null) {
                legend.setPosition(RectangleEdge.TOP);
                legend.setFrame((BlockFrame)BlockBorder.NONE);
                legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                legend.setItemFont(LABEL_FONT);
            }
            if (this.panel instanceof CtrlChartPanel) {
                this.panel.setChart(chart);
            } else {
                this.panel = new CtrlChartPanel(chart, this.getWidth(), this.getHeight() - 20);
                ChartPanelShiftController controller = new ChartPanelShiftController(this.panel);
                this.panel.addMouseListener((MouseListener)controller);
                this.panel.addMouseMotionListener((MouseMotionListener)controller);
            }
            this.panel.getChartRenderingInfo().setEntityCollection(null);
        } else {
            LogService.getGlobal().logNote("Too many columns (" + categoryCount + "), this chart is only able to plot up to " + 50 + " different categories.");
        }
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        switch (index) {
            case 0: {
                JLabel label = new JLabel("Aggregation");
                label.setToolTipText("Select the type of the aggregation function which should be used for grouped values.");
                return label;
            }
            case 1: {
                return this.aggregationFunction;
            }
            case 2: {
                return this.useDistinct;
            }
            case 3: {
                if (this.isSupportingExplosion()) {
                    JLabel label = new JLabel("Explosion Groups");
                    label.setToolTipText("Select the groups which should explode, i.e. which should be located outside of the chart to the specified extent.");
                    return label;
                }
                return null;
            }
            case 4: {
                if (this.isSupportingExplosion()) {
                    this.explodingGroupList.setToolTipText("Select the groups which should explode, i.e. which should be located outside of the chart to the specified extent.");
                    ExtendedJScrollPane pane = new ExtendedJScrollPane(this.explodingGroupList);
                    return pane;
                }
                return null;
            }
            case 5: {
                if (this.isSupportingExplosion()) {
                    JLabel label = new JLabel("Explosion Amount");
                    label.setToolTipText("Select the amount of explosion for the selected groups.");
                    return label;
                }
                return null;
            }
            case 6: {
                if (!this.isSupportingExplosion()) break;
                this.explodingSlider.setToolTipText("Select the amount of explosion for the selected groups.");
                return this.explodingSlider;
            }
        }
        return null;
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys() {
        List<ParameterType> types = super.getAdditionalParameterKeys();
        String[] allFunctions = new String[AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length + 1];
        allFunctions[0] = "none";
        System.arraycopy(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 0, allFunctions, 1, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length);
        types.add(new ParameterTypeCategory("aggregation", "The function used for aggregating the values grouped by the specified column.", allFunctions, 0));
        types.add(new ParameterTypeBoolean("use_distinct", "Indicates if only distinct values should be regarded for aggregation.", false));
        if (this.isSupportingExplosion()) {
            types.add(new ParameterTypeString("explosion_groups", "A comma separated list of groups which should be exploded, i.e. moved out from the center of the plot.", true));
            types.add(new ParameterTypeDouble("explosion_amount", "The percentage of explosion for the selected groups.", 0.0, Double.POSITIVE_INFINITY, 0.0));
        }
        return types;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setAdditionalParameter(String key, String value) {
        if ("aggregation".equals(key)) {
            block15: {
                index = 0;
                try {
                    index = Integer.valueOf(value);
                    break block15;
                }
                catch (NumberFormatException e) {
                    nameCounter = 1;
                    var9_11 = AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES;
                    var8_12 = AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES.length;
                    var7_13 = 0;
                    ** while (var7_13 < var8_12)
                }
lbl-1000:
                // 1 sources

                {
                    name = var9_11[var7_13];
                    if (name.equals(value)) {
                        index = nameCounter;
                        break;
                    }
                    ++nameCounter;
                    ++var7_13;
                    continue;
                }
            }
            this.aggregationFunction.setSelectedIndex(index);
        } else if ("use_distinct".equals(key)) {
            distinct = Tools.booleanValue(value, false);
            this.useDistinct.setSelected(distinct);
        } else if ("explosion_groups".equals(key)) {
            newGroups = new String[]{};
            if (value != null) {
                newGroups = value.split(",");
            }
            i = 0;
            while (i < newGroups.length) {
                newGroups[i] = newGroups[i].trim();
                ++i;
            }
            this.setExplodingGroups(newGroups);
        } else if ("explosion_amount".equals(key)) {
            try {
                amount = Double.parseDouble(value);
                this.setExplodingAmount(amount);
            }
            catch (NumberFormatException var3_7) {
                // empty catch block
            }
        }
    }
}

