/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.gui.plotter.ColorProvider;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.util.ShapeUtilities;

public class ColorizedShapeItemRenderer
extends XYShapeRenderer {
    private static final long serialVersionUID = 1110895790394519633L;
    private double minColor;
    private double maxColor;
    private ColorProvider colorProvider = new ColorProvider();

    public ColorizedShapeItemRenderer(double minColor, double maxColor) {
        this.minColor = minColor;
        this.maxColor = maxColor;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        Shape hotspot = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        double x = dataset.getXValue(series, item);
        double y = dataset.getYValue(series, item);
        double colorValue = ((XYZDataset)dataset).getZValue(series, item);
        double normalized = (colorValue - this.minColor) / (this.maxColor - this.minColor);
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return;
        }
        double transX = domainAxis.valueToJava2D(x, dataArea, plot.getDomainAxisEdge());
        double transY = rangeAxis.valueToJava2D(y, dataArea, plot.getRangeAxisEdge());
        PlotOrientation orientation = plot.getOrientation();
        Shape shape = this.getItemShape(series, item);
        if (orientation == PlotOrientation.HORIZONTAL) {
            shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)transY, (double)transX);
        } else if (orientation == PlotOrientation.VERTICAL) {
            shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)transX, (double)transY);
        }
        hotspot = shape;
        if (shape.intersects(dataArea)) {
            g2.setPaint(this.colorProvider.getPointColor(normalized));
            g2.fill(shape);
            if (this.getDrawOutlines()) {
                if (this.getUseOutlinePaint()) {
                    g2.setPaint(this.getItemOutlinePaint(series, item));
                } else {
                    g2.setPaint(this.getItemPaint(series, item));
                }
                g2.setStroke(this.getItemOutlineStroke(series, item));
                g2.draw(shape);
            }
        }
        if (entities != null) {
            this.addEntity(entities, hotspot, dataset, series, item, transX, transY);
        }
    }
}

