/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.properties.MatrixPropertyTable;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterTypeMatrix;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class MatrixPropertyDialog
extends JDialog {
    private static final long serialVersionUID = 5396725165122306231L;
    private boolean ok = false;
    private boolean isSquared = false;
    private MatrixPropertyTable matrixPropertyTable;

    public MatrixPropertyDialog(ParameterTypeMatrix type, double[][] matrix, Operator operator) {
        super(RapidMinerGUI.getMainFrame(), "Parameter Matrix: " + type.getKey(), true);
        this.isSquared = type.isSquared();
        this.matrixPropertyTable = new MatrixPropertyTable(type.getBaseName(), type.getRowBaseName(), type.getColumnBaseName(), matrix, operator);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        if (!this.isSquared) {
            JButton addRowButton = new JButton("Add row");
            addRowButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.addRow();
                }
            });
            buttonPanel.add(addRowButton);
            JButton addColumnButton = new JButton("Add column");
            addColumnButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.addColumn();
                }
            });
            buttonPanel.add(addColumnButton);
            JButton removeRowButton = new JButton("Remove row");
            removeRowButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.removeSelectedRow();
                }
            });
            buttonPanel.add(removeRowButton);
            JButton removeColumnButton = new JButton("Remove column");
            removeColumnButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.removeSelectedColumn();
                }
            });
            buttonPanel.add(removeColumnButton);
        } else {
            JButton addColumnButton = new JButton("Increase Size");
            addColumnButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.addRow();
                    MatrixPropertyDialog.this.matrixPropertyTable.addColumn();
                    MatrixPropertyDialog.this.matrixPropertyTable.fillNewRowAndColumn();
                }
            });
            buttonPanel.add(addColumnButton);
            JButton removeRowButton = new JButton("Decrease Size");
            removeRowButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MatrixPropertyDialog.this.matrixPropertyTable.removeSelectedRowAndColumn();
                }
            });
            buttonPanel.add(removeRowButton);
        }
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatrixPropertyDialog.this.ok();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatrixPropertyDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        ExtendedJScrollPane scrollpane = new ExtendedJScrollPane(this.matrixPropertyTable);
        this.getContentPane().add((Component)scrollpane, "Center");
        this.setSize(RapidMinerGUI.getMainFrame().getWidth() / 2, RapidMinerGUI.getMainFrame().getHeight() / 2);
        this.setLocationRelativeTo(RapidMinerGUI.getMainFrame());
    }

    public double[][] getMatrix() {
        return this.matrixPropertyTable.getParameterMatrix();
    }

    private void ok() {
        this.ok = true;
        this.dispose();
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }
}

