/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.properties.PropertyTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsPropertyTable
extends PropertyTable {
    private static final long serialVersionUID = 649188519589057381L;
    private transient ParameterType[] parameterTypes;

    public SettingsPropertyTable() {
        this(RapidMiner.getRapidMinerProperties());
    }

    public SettingsPropertyTable(Collection<ParameterType> allProperties) {
        super(new String[]{"Property", "Value"});
        this.parameterTypes = new ParameterType[allProperties.size()];
        allProperties.toArray(this.parameterTypes);
        this.updateTableData(this.parameterTypes.length);
        int i = 0;
        while (i < this.parameterTypes.length) {
            ParameterType type = this.parameterTypes[i];
            String key = this.parameterTypes[i].getKey();
            this.getModel().setValueAt(key, i, 0);
            Object property = System.getProperty(key);
            if (property == null) {
                property = type.getDefaultValue();
            }
            this.getModel().setValueAt(property, i, 1);
            ++i;
        }
        SettingsPropertyTable.updateEditorsAndRenderers(this);
    }

    @Override
    protected Object readResolve() {
        return this;
    }

    @Override
    public ParameterType getParameterType(int row) {
        return this.parameterTypes[row];
    }

    @Override
    public Operator getOperator(int row) {
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    private String getPropertyValue(int index) {
        Object value = this.getModel().getValueAt(index, 1);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void applyProperties() {
        this.applyProperties(System.getProperties());
    }

    public void applyProperties(Properties properties) {
        int i = 0;
        while (i < this.parameterTypes.length) {
            String value = this.getPropertyValue(i);
            if (value != null) {
                properties.setProperty(this.parameterTypes[i].getKey(), value);
            } else {
                properties.remove(this.parameterTypes[i].getKey());
            }
            ++i;
        }
    }

    public void writeProperties(PrintWriter out) throws IOException {
        int i = 0;
        while (i < this.parameterTypes.length) {
            String key = this.parameterTypes[i].getKey();
            String value = this.getPropertyValue(i);
            if (value != null) {
                System.setProperty(key, value);
                out.println(String.valueOf(key) + " = " + value);
            }
            ++i;
        }
    }
}

