/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressMonitor {
    private int total;
    private int current = -1;
    private boolean indeterminate;
    private int waitingTime = 100;
    private String status;
    private Vector<ChangeListener> listeners = new Vector();
    private ChangeEvent changeEvent = new ChangeEvent(this);

    public ProgressMonitor(int total, boolean indeterminate, int waitingTime) {
        this.total = total;
        this.indeterminate = indeterminate;
        this.waitingTime = waitingTime;
    }

    public ProgressMonitor(int total, boolean indeterminate) {
        this.total = total;
        this.indeterminate = indeterminate;
    }

    public int getTotal() {
        return this.total;
    }

    public void start(String status) {
        if (this.current != -1) {
            throw new IllegalStateException("not started yet");
        }
        this.status = status;
        this.current = 0;
        this.fireChangeEvent();
    }

    public int getWaitingTime() {
        return this.waitingTime;
    }

    public int getCurrent() {
        return this.current;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setCurrent(String status, int current) {
        if (current == -1) {
            throw new IllegalStateException("not started yet");
        }
        this.current = current;
        if (status != null) {
            this.status = status;
        }
        this.fireChangeEvent();
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        Vector targets;
        ProgressMonitor progressMonitor = this;
        synchronized (progressMonitor) {
            targets = (Vector)this.listeners.clone();
        }
        for (ChangeListener listener : targets) {
            listener.stateChanged(this.changeEvent);
        }
    }
}

