/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.SwingTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class SystemMonitor
extends JPanel {
    private static final long serialVersionUID = -6860624220979494451L;
    private static final Color BACKGROUND = Color.WHITE;
    private static final Color TEXT_COLOR = SwingTools.VERY_DARK_BLUE;
    private static final Color MEMORY_COLOR = SwingTools.LIGHTEST_BLUE;
    private static final Color GRID_COLOR = Color.LIGHT_GRAY;
    private static final Color LINE_COLOR = SwingTools.VERY_DARK_BLUE;
    private static final String[] MEMORY_UNITS = new String[]{"b", "kB", "MB", "GB", "TB"};
    private static final int NUMBER_OF_MEASUREMENTS = 20;
    private static final int GRID_X = 10;
    private static final int GRID_Y = 10;
    private static final int MARGIN = 10;
    private long delay = 1000L;
    private long[] memory = new long[20];
    private int currentMeasurement = 0;
    private double currentlyUsed = 0.0;
    private Color backgroundColor = BACKGROUND;
    private Color textColor = TEXT_COLOR;
    private Color memoryColor = MEMORY_COLOR;
    private Color gridColor = GRID_COLOR;
    private Color lineColor = LINE_COLOR;

    public SystemMonitor() {
        this.setBackground(this.backgroundColor);
    }

    public void startMonitorThread() {
        new Thread("SystemMonitor-Thread"){
            {
                this.setDaemon(true);
            }

            public void run() {
                this.setPriority(1);
                while (true) {
                    SystemMonitor.this.currentlyUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    ((SystemMonitor)SystemMonitor.this).memory[((SystemMonitor)SystemMonitor.this).currentMeasurement] = (long)SystemMonitor.this.currentlyUsed;
                    SystemMonitor.this.currentMeasurement = (SystemMonitor.this.currentMeasurement + 1) % SystemMonitor.this.memory.length;
                    SystemMonitor.this.repaint();
                    try {
                        1.sleep(SystemMonitor.this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
    }

    protected final void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.setBackground(this.backgroundColor);
    }

    protected final void setTextColor(Color color) {
        this.textColor = color;
    }

    protected final void setMemoryColor(Color color) {
        this.memoryColor = color;
    }

    protected final void setGridColor(Color color) {
        this.gridColor = color;
    }

    protected final void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        GeneralPath path = new GeneralPath();
        Dimension d = this.getSize();
        int monitorWidth = (int)d.getWidth() - 20;
        int monitorHeight = (int)d.getHeight() - 20;
        long total = Runtime.getRuntime().totalMemory();
        path.moveTo(10.0f, 10 + monitorHeight);
        int i = 0;
        while (i < this.memory.length) {
            int index = (this.currentMeasurement + i) % this.memory.length;
            path.lineTo(10 + i * monitorWidth / (this.memory.length - 1), (long)(10 + monitorHeight) - (long)monitorHeight * this.memory[index] / total);
            ++i;
        }
        path.lineTo(10 + monitorWidth, 10 + monitorHeight);
        path.closePath();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.gridColor);
        int x = 0;
        while (x < 11) {
            g2d.drawLine(10 + x * monitorWidth / 10, 10, 10 + x * monitorWidth / 10, 10 + monitorHeight);
            ++x;
        }
        int y = 0;
        while (y < 11) {
            g2d.drawLine(10, 10 + y * monitorHeight / 10, 10 + monitorWidth, 10 + y * monitorHeight / 10);
            ++y;
        }
        Color currentMemoryColor = this.memoryColor;
        if (this.currentlyUsed > 0.2 * (double)Runtime.getRuntime().maxMemory()) {
            double more = this.currentlyUsed - 0.2 * (double)Runtime.getRuntime().maxMemory();
            double factor = more / (0.6 * (double)Runtime.getRuntime().maxMemory());
            currentMemoryColor = this.getMemoryColor(Math.max(Math.min(1.0, factor), 0.0));
        }
        g2d.setColor(currentMemoryColor);
        g2d.fill(path);
        g2d.setColor(this.lineColor);
        g2d.draw(path);
        g2d.setColor(this.textColor);
        Font font = new Font("Courier", 0, 11);
        g2d.setFont(font);
        String totalString = " Total: " + this.humanReadable(total);
        String maxString = " Max:   " + this.humanReadable(Runtime.getRuntime().maxMemory());
        Rectangle2D totalBounds = g2d.getFontMetrics().getStringBounds(totalString, g2d);
        Rectangle2D maxBounds = g2d.getFontMetrics().getStringBounds(totalString, g2d);
        int totalHeight = 4 * font.getSize() + 20;
        int totalWidth = (int)Math.max(totalBounds.getWidth(), maxBounds.getWidth()) + 30;
        if (totalHeight < this.getHeight() && totalWidth < this.getWidth()) {
            g2d.drawString(totalString, 10, 10 + (monitorHeight - font.getSize()));
            g2d.drawString(maxString, 10, 10 + (monitorHeight - 2 * font.getSize()));
        }
    }

    private String humanReadable(long bytes) {
        long result = bytes;
        long rest = 0L;
        int unit = 0;
        while (result > 1024L) {
            rest = result % 1024L;
            result /= 1024L;
            if (++unit >= MEMORY_UNITS.length - 1) break;
        }
        if (result < 10L && unit > 0) {
            return String.valueOf(result) + "." + 10L * rest / 1024L + " " + MEMORY_UNITS[unit];
        }
        return String.valueOf(result) + " " + MEMORY_UNITS[unit];
    }

    private Color getMemoryColor(double value) {
        if (Double.isNaN(value)) {
            return SwingTools.LIGHTEST_BLUE;
        }
        float[] minCol = Color.RGBtoHSB(SwingTools.LIGHTEST_BLUE.getRed(), SwingTools.LIGHTEST_BLUE.getGreen(), SwingTools.LIGHTEST_BLUE.getBlue(), null);
        float[] maxCol = Color.RGBtoHSB(SwingTools.LIGHTEST_RED.getRed(), SwingTools.LIGHTEST_RED.getGreen(), SwingTools.LIGHTEST_RED.getBlue(), null);
        double hColorDiff = maxCol[0] - minCol[0];
        double sColorDiff = maxCol[1] - minCol[1];
        double bColorDiff = maxCol[2] - minCol[2];
        return new Color(Color.HSBtoRGB((float)((double)minCol[0] + hColorDiff * value), (float)((double)minCol[1] + value * sColorDiff), (float)((double)minCol[2] + value * bColorDiff)));
    }
}

