/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNumber
implements Comparable<VersionNumber> {
    private int majorNumber;
    private int minorNumber;
    private int patchLevel;
    private boolean beta;
    private int betaNumber;

    public VersionNumber(String versionString) {
        String version = versionString.toLowerCase().trim();
        int betaIndex = version.indexOf("beta");
        if (betaIndex >= 0) {
            String[] numbers = version.substring(0, betaIndex).split("\\.");
            if (numbers.length > 0) {
                this.majorNumber = Integer.parseInt(numbers[0]);
            }
            if (numbers.length > 1) {
                this.minorNumber = Integer.parseInt(numbers[1]);
            }
            if (numbers.length > 2) {
                this.patchLevel = Integer.parseInt(numbers[2]);
            }
            this.beta = true;
            String betaNumberString = version.substring(betaIndex + "beta".length());
            if (betaNumberString.length() > 0) {
                this.betaNumber = Integer.parseInt(betaNumberString);
            }
        } else {
            String[] numbers = version.split("\\.");
            if (numbers.length > 0) {
                this.majorNumber = Integer.parseInt(numbers[0]);
            }
            if (numbers.length > 1) {
                this.minorNumber = Integer.parseInt(numbers[1]);
            }
            if (numbers.length > 2) {
                this.patchLevel = Integer.parseInt(numbers[2]);
            }
        }
    }

    public VersionNumber(int majorNumber, int minorNumber, int patchLevel, boolean beta, int betaNumber) {
        this.majorNumber = majorNumber;
        this.minorNumber = minorNumber;
        this.patchLevel = patchLevel;
        this.beta = beta;
        this.betaNumber = betaNumber;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VersionNumber)) {
            return false;
        }
        VersionNumber other = (VersionNumber)o;
        return this.majorNumber == other.majorNumber && this.minorNumber == other.minorNumber && this.patchLevel == other.patchLevel && this.beta == other.beta && this.betaNumber == other.betaNumber;
    }

    public int hashCode() {
        return Double.valueOf(this.majorNumber).hashCode() ^ Double.valueOf(this.minorNumber).hashCode() ^ Double.valueOf(this.patchLevel).hashCode() ^ Boolean.valueOf(this.beta).hashCode() ^ Double.valueOf(this.betaNumber).hashCode();
    }

    @Override
    public int compareTo(VersionNumber o) {
        int index = Double.compare(this.majorNumber, o.majorNumber);
        if (index != 0) {
            return index;
        }
        index = Double.compare(this.minorNumber, o.minorNumber);
        if (index != 0) {
            return index;
        }
        index = Double.compare(this.patchLevel, o.patchLevel);
        if (index != 0) {
            return index;
        }
        if (this.beta && !o.beta) {
            return -1;
        }
        if (!this.beta && o.beta) {
            return 1;
        }
        if (!this.beta && !o.beta) {
            return 0;
        }
        return Double.compare(this.betaNumber, o.betaNumber);
    }

    public String toString() {
        return String.valueOf(this.majorNumber) + "." + this.minorNumber + "." + this.patchLevel + (this.beta ? "beta" + (this.betaNumber >= 2 ? String.valueOf(this.betaNumber) : "") : "");
    }
}

