/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.wizards;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.wizards.ConfigurationListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class AbstractConfigurationWizard
extends JDialog {
    private static final long serialVersionUID = -2633062859175838003L;
    private JButton next = new JButton("Next >");
    private JButton previous = new JButton("< Previous");
    private CardLayout cardLayout = new CardLayout();
    private JPanel mainPanel = new JPanel(this.cardLayout);
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private JPanel contentPanel = new JPanel(this.layout);
    private int currentStep = 0;
    private int numberOfSteps = 0;
    private ConfigurationListener listener;

    public AbstractConfigurationWizard(String name, ConfigurationListener listener) {
        super(RapidMinerGUI.getMainFrame(), name, true);
        this.listener = listener;
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.next);
        buttonPanel.add(this.previous);
        this.previous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractConfigurationWizard.this.step(-1);
            }
        });
        buttonPanel.add(this.next);
        this.next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractConfigurationWizard.this.step(1);
            }
        });
        buttonPanel.add(Box.createHorizontalStrut(11));
        JButton cancel = new JButton("Cancel");
        buttonPanel.add(cancel);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractConfigurationWizard.this.cancel();
            }
        });
        this.getContentPane().add((Component)buttonPanel, "South");
        this.c.fill = 1;
        this.c.anchor = 18;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridwidth = 0;
        this.c.insets = new Insets(11, 11, 11, 11);
        this.contentPanel = new JPanel(this.layout);
        this.layout.setConstraints(this.mainPanel, this.c);
        this.contentPanel.add(this.mainPanel);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.setSize(Math.max(640, (int)(0.66 * (double)this.getOwner().getWidth())), Math.max(480, (int)(0.66 * (double)this.getOwner().getHeight())));
        this.setLocationRelativeTo(this.getOwner());
    }

    public boolean validateCurrentStep(int currentStep, int newStep) {
        return true;
    }

    protected abstract void performStepAction(int var1, int var2);

    protected abstract void finish(ConfigurationListener var1);

    protected void addBottomComponent(Component bottomComponent) {
        this.c.weighty = 2.0;
        this.layout.setConstraints(bottomComponent, this.c);
        this.contentPanel.add(bottomComponent);
    }

    protected int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    protected void addStep(Component c) {
        this.mainPanel.add(c, String.valueOf(this.numberOfSteps));
        ++this.numberOfSteps;
    }

    private void step(int dir) {
        int oldStep = this.currentStep;
        this.currentStep += dir;
        if (this.validateCurrentStep(oldStep, this.currentStep)) {
            if (this.currentStep < 0) {
                this.currentStep = 0;
            }
            if (this.currentStep == 0) {
                this.previous.setEnabled(false);
            } else {
                this.previous.setEnabled(true);
            }
            if (this.currentStep >= this.numberOfSteps) {
                this.currentStep = this.numberOfSteps - 1;
                this.finish(this.listener);
            }
            if (this.currentStep == this.numberOfSteps - 1) {
                this.next.setText("Finish");
            } else {
                this.next.setText("Next >");
            }
            this.cardLayout.show(this.mainPanel, String.valueOf(this.currentStep));
            this.performStepAction(this.currentStep, oldStep);
        } else {
            this.currentStep = oldStep;
        }
    }

    protected void cancel() {
        this.dispose();
    }
}

