/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.wizards;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.JDBCDriverTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.wizards.AbstractConfigurationWizard;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.DatabaseService;
import com.rapidminer.tools.jdbc.DriverInfo;
import com.rapidminer.tools.jdbc.JDBCProperties;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DBExampleSetWriterConfigurationWizard
extends AbstractConfigurationWizard {
    private static final long serialVersionUID = 5127262335077061590L;
    private static final String USER_DEFINED_STRING = "User Defined URL (next step)";
    private static final int STEP_USER_DATA = 2;
    private transient DatabaseHandler handler = null;
    private boolean isConnected = false;
    Map<String, List<String>> attributeNameMap = new LinkedHashMap<String, List<String>>();
    private JComboBox systemComboBox;
    private JTextField serverField = new JTextField(40);
    private JTextField urlField = new JTextField(40);
    private JTextField databaseNameField = new JTextField(40);
    private JTextField userNameField = new JTextField(40);
    private JTextField tableNameField = new JTextField(40);
    private JPasswordField passwordField = new JPasswordField(40);
    private String password = null;
    private boolean showSystemSetup = true;

    public DBExampleSetWriterConfigurationWizard(ConfigurationListener listener, boolean showDrivers, boolean showSystemSetup, String selectedSystem, String server, String databaseName) {
        super("Database Example Set Writer Wizard", listener);
        this.showSystemSetup = showSystemSetup;
        this.addTitleStep(showDrivers);
        this.addDBSystemSelectionStep();
        this.addUserDataStep();
        this.addTableSelectionStep();
        this.updateSystemSelection();
        this.initStartParameters(listener);
        if (!showSystemSetup) {
            if (selectedSystem != null) {
                this.systemComboBox.setSelectedItem(selectedSystem);
            }
            this.serverField.setText(server);
        }
        if (databaseName != null) {
            this.databaseNameField.setText(databaseName);
        }
    }

    private void addTitleStep(boolean showDrivers) {
        StringBuffer titleString = new StringBuffer();
        titleString.append("This wizard will guide you through the process of writing data into databases. Using this wizard will involve the following steps:<ul>");
        if (this.showSystemSetup) {
            titleString.append("<li>Selection of a database</li>");
        }
        titleString.append("<li>Definition of the username and password</li><li>Definition of a table name</li></ul>");
        if (showDrivers) {
            titleString.append("<br>The currently available JDBC drivers are listed below. Please make sure to copy missing drivers into the directory lib/jdbc and restart RapidMiner in order to make additional drivers available.");
        }
        JPanel panel = SwingTools.createTextPanel("Welcome to the Database Example Set Writer Wizard", titleString.toString());
        if (showDrivers) {
            DriverInfo[] drivers = DatabaseService.getAllDriverInfos();
            JDBCDriverTable driverTable = new JDBCDriverTable(drivers);
            panel.add((Component)new JScrollPane(driverTable), "Center");
        }
        this.addStep(panel);
    }

    private void addDBSystemSelectionStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify your database system...", "Please specify your database system. If your system is not available, you can select \"User Defined URL (next step)\" and define an appropriate connection URL for your system in the next step. If the connection fails because no suitable driver is available, you might copy a driver library into the directory lib/jdbc and it will be available after the next start of RapidMiner.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("Database System:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        String[] knownNames = DatabaseService.getDBSystemNames();
        String[] names = new String[knownNames.length + 1];
        System.arraycopy(knownNames, 0, names, 0, knownNames.length);
        names[names.length - 1] = USER_DEFINED_STRING;
        this.systemComboBox = new JComboBox<String>(names);
        this.systemComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBExampleSetWriterConfigurationWizard.this.updateSystemSelection();
            }
        });
        c.weightx = 1.0;
        c.gridwidth = 0;
        if (!this.showSystemSetup) {
            this.systemComboBox.setEnabled(false);
        }
        layout.setConstraints(this.systemComboBox, c);
        content.add(this.systemComboBox);
        label = new JLabel("Server Name or IP:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        if (!this.showSystemSetup) {
            this.serverField.setEnabled(false);
        }
        layout.setConstraints(this.serverField, c);
        content.add(this.serverField);
        label = new JLabel("Database Name:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.databaseNameField, c);
        content.add(this.databaseNameField);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addUserDataStep() {
        JPanel panel = SwingTools.createTextPanel("Please specify the connection data...", "Please check the connection URL and adapt it if necessary (or define it in cases where your database system was not available in the dialog before). Please specify the user name and the password. If the password field remains empty you will be prompted for it during connections. You can validate the connection to the database by pressing the \"Test Connection\" button.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("URL:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.urlField, c);
        content.add(this.urlField);
        JPanel fillPanel = new JPanel();
        layout.setConstraints(fillPanel, c);
        content.add(fillPanel);
        label = new JLabel("User:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.userNameField, c);
        content.add(this.userNameField);
        label = new JLabel("Password:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.passwordField, c);
        content.add(this.passwordField);
        JPanel testButtonPanel = new JPanel(new FlowLayout(1));
        JButton testButton = new JButton("Test Connection");
        testButton.setToolTipText("Tests the connection to the database based on the current settings.");
        testButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBExampleSetWriterConfigurationWizard.this.testConnection();
            }
        });
        testButtonPanel.add(testButton);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(testButtonPanel, c);
        content.add(testButtonPanel);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addTableSelectionStep() {
        JPanel panel = SwingTools.createTextPanel("Please define a table name.", "Please specify the table into which the data should be written.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        JLabel label = new JLabel("Table Name:");
        c.weightx = 0.0;
        c.gridwidth = -1;
        layout.setConstraints(label, c);
        content.add(label);
        c.weightx = 1.0;
        c.gridwidth = 0;
        layout.setConstraints(this.tableNameField, c);
        content.add(this.tableNameField);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    protected void performStepAction(int currentStep, int oldStep) {
        if (currentStep == 2) {
            this.password = null;
            if (this.systemComboBox.getSelectedIndex() < DatabaseService.getJDBCProperties().size()) {
                this.urlField.setText(this.createPredefinedDatabaseURL());
            }
        }
    }

    private void updateSystemSelection() {
        if (!this.showSystemSetup) {
            this.serverField.setEnabled(false);
        } else if (this.systemComboBox.getSelectedIndex() >= DatabaseService.getJDBCProperties().size()) {
            this.serverField.setEnabled(false);
            this.databaseNameField.setEnabled(false);
            this.urlField.setText("");
        } else {
            this.serverField.setEnabled(true);
            this.databaseNameField.setEnabled(true);
        }
    }

    private String getDatabaseURL() {
        return this.urlField.getText().trim();
    }

    private String createPredefinedDatabaseURL() {
        int index = this.systemComboBox.getSelectedIndex();
        String serverName = this.serverField.getText().trim();
        if (serverName == null || serverName.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("Please specify a database server name or IP!");
            return "";
        }
        String databaseName = this.databaseNameField.getText().trim();
        if (databaseName == null || databaseName.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("Please specify a database name!");
            return "";
        }
        String portString = "";
        String defaultPort = DatabaseService.getJDBCProperties().get(index).getDefaultPort();
        if (defaultPort.length() > 0) {
            portString = ":" + defaultPort;
        }
        return String.valueOf(DatabaseService.getJDBCProperties().get(index).getUrlPrefix()) + serverName + portString + DatabaseService.getJDBCProperties().get(index).getDbNameSeperator() + databaseName;
    }

    private void testConnection() {
        try {
            if (!this.connect()) {
                throw new SQLException("Connection was not possible!");
            }
            this.disconnect();
            JOptionPane.showMessageDialog(this, "Connection to database is possible.", "Connection OK", 1);
        }
        catch (SQLException e) {
            this.showConnectionError(null, e);
        }
    }

    private boolean connect() throws SQLException {
        String urlString = this.getDatabaseURL();
        if (urlString != null && urlString.length() > 0) {
            if (this.isConnected) {
                this.handler.disconnect();
                this.handler = null;
            }
            this.handler = new DatabaseHandler(urlString, DatabaseService.getJDBCProperties().get(this.systemComboBox.getSelectedIndex()));
            String userName = null;
            String passwd = null;
            if (urlString.indexOf("AuthenticationMethod") < 0) {
                userName = this.userNameField.getText().trim();
                if (userName == null || userName.length() == 0) {
                    SwingTools.showVerySimpleErrorMessage("Please specify a user name!");
                    return false;
                }
                passwd = this.password;
                if (passwd == null && ((passwd = new String(this.passwordField.getPassword())) == null || passwd.length() == 0)) {
                    passwd = RapidMiner.getInputHandler().inputPassword("Password for user '" + userName + "' required:");
                }
            }
            this.handler.connect(userName, passwd, true);
            this.password = passwd;
            this.isConnected = true;
            return true;
        }
        SwingTools.showVerySimpleErrorMessage("Please specify the necessary connection data!");
        return false;
    }

    private void disconnect() throws SQLException {
        if (this.isConnected) {
            this.handler.disconnect();
            this.handler = null;
            this.isConnected = false;
        }
    }

    private void showConnectionError(String message, SQLException e) {
        JOptionPane.showMessageDialog(this, String.valueOf(message != null ? String.valueOf(message) + ": " : "") + "Connection to database has failed:" + Tools.getLineSeparator() + e.getMessage().substring(0, Math.min(300, e.getMessage().length())) + "...", "Connection failed", 0);
    }

    protected void initStartParameters(ConfigurationListener listener) {
        Parameters parameters = listener.getParameters();
        int dbIndex = -1;
        try {
            String systemObject = parameters.getParameter("database_system");
            if (systemObject != null) {
                dbIndex = Integer.valueOf(systemObject);
                this.systemComboBox.setSelectedIndex(dbIndex);
            }
        }
        catch (UndefinedParameterError systemObject) {
            // empty catch block
        }
        try {
            String urlObject = parameters.getParameter("database_url");
            if (urlObject != null) {
                String urlString = urlObject.toString();
                this.urlField.setText(urlString);
                JDBCProperties props = DatabaseService.getJDBCProperties().get(dbIndex);
                String urlPrefix = props.getUrlPrefix();
                String dbNameSeparator = props.getDbNameSeperator();
                int serverStart = urlPrefix.length();
                int serverEnd = -1;
                if (urlString.indexOf(":") >= 0) {
                    serverEnd = urlString.indexOf(":", serverStart + 1);
                } else if (urlString.indexOf(dbNameSeparator, serverStart + 1) >= 0) {
                    serverEnd = urlString.indexOf(dbNameSeparator);
                }
                if (serverEnd >= serverStart && serverStart < urlString.length()) {
                    String serverName = urlString.substring(serverStart, serverEnd);
                    this.serverField.setText(serverName);
                }
                int dbStart = -1;
                if (urlString.indexOf(dbNameSeparator, serverStart + 1) >= 0) {
                    dbStart = urlString.lastIndexOf(dbNameSeparator) + dbNameSeparator.length();
                }
                if (dbStart >= 0) {
                    String dbName = urlString.substring(dbStart);
                    this.databaseNameField.setText(dbName);
                }
            }
        }
        catch (UndefinedParameterError urlObject) {
            // empty catch block
        }
        try {
            String userNameObject = parameters.getParameter("username");
            if (userNameObject != null) {
                this.userNameField.setText(userNameObject.toString());
            }
        }
        catch (UndefinedParameterError userNameObject) {
            // empty catch block
        }
        try {
            String passwordObject = parameters.getParameter("password");
            if (passwordObject != null) {
                this.passwordField.setText(passwordObject.toString());
            }
        }
        catch (UndefinedParameterError passwordObject) {
            // empty catch block
        }
        try {
            String tableObject = parameters.getParameter("table_name");
            if (tableObject != null) {
                this.tableNameField.setText(tableObject.toString());
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
    }

    protected void finish(ConfigurationListener listener) {
        try {
            this.disconnect();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String tableName = this.tableNameField.getText().trim();
        String databaseURL = this.urlField.getText().trim();
        String userName = this.userNameField.getText().trim();
        if (databaseURL.length() == 0 || tableName.length() == 0 || userName.length() == 0) {
            SwingTools.showVerySimpleErrorMessage("You must specify a database connection and proper settings - the operator will not work without this." + Tools.getLineSeparator() + "Please select \"Cancel\" if you want to abort this wizard.");
        } else {
            Parameters parameters = listener.getParameters();
            parameters.setParameter("database_system", String.valueOf(this.systemComboBox.getSelectedIndex()));
            parameters.setParameter("database_url", databaseURL);
            parameters.setParameter("username", userName);
            parameters.setParameter("password", null);
            char[] password = this.passwordField.getPassword();
            if (password != null && password.length > 0) {
                parameters.setParameter("password", new String(password));
            }
            parameters.setParameter("table_name", tableName);
            listener.setParameters(parameters);
            this.dispose();
            RapidMinerGUI.getMainFrame().getPropertyTable().refresh();
        }
    }

    protected void cancel() {
        try {
            this.disconnect();
        }
        catch (SQLException e) {
            LogService.getGlobal().log("Problem during disconnecting: " + e.getMessage(), 5);
        }
        super.cancel();
    }
}

