/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingOperator
extends Operator {
    public static final String PARAMETER_SCRIPT = "script";
    public static final String PARAMETER_STANDARD_IMPORTS = "standard_imports";

    public ScriptingOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Object result;
        String script = this.getParameterAsString(PARAMETER_SCRIPT);
        if (this.getParameterAsBoolean(PARAMETER_STANDARD_IMPORTS)) {
            StringBuffer imports = new StringBuffer();
            imports.append("import com.rapidminer.example.*;\n");
            imports.append("import com.rapidminer.example.set.*;\n");
            imports.append("import com.rapidminer.example.table.*;\n");
            imports.append("import com.rapidminer.operator.*;\n");
            imports.append("import com.rapidminer.tools.Tools;\n");
            imports.append("import java.util.*;\n");
            script = String.valueOf(imports.toString()) + script;
        }
        try {
            GroovyShell shell = new GroovyShell();
            shell.setVariable("operator", (Object)this);
            Script parsedScript = shell.parse(script);
            result = parsedScript.run();
        }
        catch (Throwable e) {
            throw new UserError((Operator)this, e, 945, "Groovy", e);
        }
        if (result instanceof Object[]) {
            return (IOObject[])result;
        }
        if (result instanceof List) {
            LinkedList<IOObject> results = new LinkedList<IOObject>();
            for (Object single : (List)result) {
                if (single instanceof IOObject) {
                    results.add((IOObject)single);
                    continue;
                }
                this.logWarning("Unknown result type: " + single);
            }
            return results.toArray(new IOObject[results.size()]);
        }
        if (result != null) {
            if (result instanceof IOObject) {
                return new IOObject[]{(IOObject)result};
            }
            this.log("Unknown result: " + result.getClass() + ": " + result);
            return new IOObject[0];
        }
        return new IOObject[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeText(PARAMETER_SCRIPT, "The script to execute.", TextType.JAVA, false));
        types.add(new ParameterTypeBoolean(PARAMETER_STANDARD_IMPORTS, "Indicates if standard imports for examples and attributes etc. should be automatically generated.", true));
        return types;
    }
}

