/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.Cluster;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlattenClusterModel
extends Operator {
    public static final String PARAMETER_NUMBER_OF_CLUSTER = "number_of_clusters";

    public FlattenClusterModel(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        HierarchicalClusterModel model = this.getInput(HierarchicalClusterModel.class);
        HierarchicalClusterNode root = model.getRootNode();
        int numberOfClusters = this.getParameterAsInt(PARAMETER_NUMBER_OF_CLUSTER);
        PriorityQueue<HierarchicalClusterNode> queue = new PriorityQueue<HierarchicalClusterNode>(numberOfClusters, new Comparator<HierarchicalClusterNode>(){

            @Override
            public int compare(HierarchicalClusterNode o1, HierarchicalClusterNode o2) {
                int value = -1 * Double.compare(o1.getDistance(), o2.getDistance());
                if (value != 0) {
                    return value;
                }
                return -1 * Double.compare(o1.getNumberOfExamplesInSubtree(), o2.getNumberOfExamplesInSubtree());
            }
        });
        LinkedList<HierarchicalClusterNode> leafs = new LinkedList<HierarchicalClusterNode>();
        queue.add(root);
        while (queue.size() < numberOfClusters - leafs.size()) {
            HierarchicalClusterNode topNode = queue.poll();
            if (topNode.getSubNodes().size() > 0) {
                queue.addAll(topNode.getSubNodes());
                continue;
            }
            leafs.add(topNode);
        }
        queue.addAll(leafs);
        ClusterModel flatModel = new ClusterModel(numberOfClusters);
        int i = 0;
        for (HierarchicalClusterNode node : queue) {
            Cluster flatCluster = flatModel.getCluster(i);
            for (Object exampleId : node.getExampleIdsInSubtree()) {
                flatCluster.assignExample(exampleId);
            }
            ++i;
        }
        return new IOObject[]{flatModel};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{HierarchicalClusterModel.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ClusterModel.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_NUMBER_OF_CLUSTER, "Specifies how many flat clusters should be created.", 1, Integer.MAX_VALUE, 3));
        return types;
    }
}

