/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.WekaClusterModel;
import com.rapidminer.operator.clustering.clusterer.AbstractClusterer;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.WekaTools;
import java.util.LinkedList;
import java.util.List;
import weka.clusterers.Clusterer;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericWekaClustererAdaptor
extends AbstractClusterer
implements TechnicalInformationHandler {
    public static final String[] WEKA_CLUSTERERS = WekaTools.getWekaClasses(Clusterer.class);
    private List<ParameterType> wekaParameters = new LinkedList<ParameterType>();

    public GenericWekaClustererAdaptor(OperatorDescription description) {
        super(description);
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        Tools.checkAndCreateIds(exampleSet);
        Clusterer clusterer = this.getWekaClusterer(WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        Instances instances = WekaTools.toWekaInstances(exampleSet, "ClusterInstances", 2);
        try {
            clusterer.buildClusterer(instances);
            WekaClusterModel wekaCluster = new WekaClusterModel(exampleSet, clusterer);
            exampleSet = wekaCluster.apply(exampleSet);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, this.getOperatorClassName(), e);
        }
        ClusterModel clusterModel = this.createWekaBasedClusterModel(exampleSet);
        return clusterModel;
    }

    private ClusterModel createWekaBasedClusterModel(ExampleSet exampleSet) {
        Attribute clusterAttribute = exampleSet.getAttributes().getCluster();
        NominalMapping mapping = clusterAttribute.getMapping();
        ClusterModel result = new ClusterModel(mapping.size());
        int[] clusterAssignment = new int[exampleSet.size()];
        int i = 0;
        for (Example example : exampleSet) {
            clusterAssignment[i] = mapping.mapString(example.getNominalValue(clusterAttribute));
            ++i;
        }
        result.setClusterAssignments(clusterAssignment, exampleSet);
        return result;
    }

    private Clusterer getWekaClusterer(String[] parameters) throws OperatorException {
        String prefixName = this.getOperatorClassName();
        String actualName = prefixName.substring("W-".length());
        String clustererName = null;
        int i = 0;
        while (i < WEKA_CLUSTERERS.length) {
            if (WEKA_CLUSTERERS[i].endsWith(actualName)) {
                clustererName = WEKA_CLUSTERERS[i];
                break;
            }
            ++i;
        }
        Clusterer clusterer = null;
        try {
            Class<?> clazz = Class.forName(clustererName);
            clusterer = (Clusterer)clazz.newInstance();
            if (clusterer instanceof OptionHandler) {
                OptionHandler optionHandler = (OptionHandler)clusterer;
                optionHandler.setOptions(parameters);
            }
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, clustererName, e);
        }
        return clusterer;
    }

    public TechnicalInformation getTechnicalInformation() {
        try {
            Clusterer clusterer = this.getWekaClusterer(null);
            if (clusterer instanceof TechnicalInformationHandler) {
                return ((TechnicalInformationHandler)clusterer).getTechnicalInformation();
            }
            return null;
        }
        catch (OperatorException e) {
            return null;
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Clusterer clusterer = null;
        try {
            clusterer = this.getWekaClusterer(null);
        }
        catch (OperatorException e) {
            throw new RuntimeException("Cannot instantiate Weka clusterer " + this.getOperatorClassName() + ": " + e.getMessage());
        }
        this.wekaParameters = new LinkedList<ParameterType>();
        if (clusterer != null && clusterer instanceof OptionHandler) {
            WekaTools.addParameterTypes((OptionHandler)clusterer, types, this.wekaParameters, false, null);
        }
        return types;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }
}

