/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.ClusterModel2ExampleSet;
import com.rapidminer.operator.clustering.FlattenClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterLeafNode;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterNode;
import com.rapidminer.operator.condition.AllInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.OperatorService;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopDownClustering
extends OperatorChain {
    public static final String PARAMETER_MAX_LEAF_SIZE = "max_leaf_size";
    public static final String PARAMETER_MAX_DEPTH = "max_depth";
    public static final String PARAMETER_CREATE_CLUSTER_LABEL = "create_cluster_label";

    public TopDownClustering(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        int maxLeafSize = this.getParameterAsInt(PARAMETER_MAX_LEAF_SIZE);
        Tools.checkAndCreateIds(exampleSet);
        Tools.onlyNonMissingValues(exampleSet, "AgglomerativeClustering");
        HierarchicalClusterNode root = new HierarchicalClusterNode("root");
        HierarchicalClusterModel model = new HierarchicalClusterModel(root);
        int createdLeafs = this.descent(exampleSet, root, 0, maxLeafSize, this.getParameterAsInt(PARAMETER_MAX_DEPTH) - 1);
        if (this.getParameterAsBoolean("keep_example_set")) {
            if (this.getParameterAsBoolean(PARAMETER_CREATE_CLUSTER_LABEL)) {
                try {
                    FlattenClusterModel flattener = OperatorService.createOperator(FlattenClusterModel.class);
                    flattener.setParameter("number_of_clusters", String.valueOf(createdLeafs));
                    IOContainer container = flattener.apply(new IOContainer(exampleSet, model));
                    ClusterModel2ExampleSet applier = OperatorService.createOperator(ClusterModel2ExampleSet.class);
                    container = applier.apply(container);
                    return new IOObject[]{container.get(ExampleSet.class), model};
                }
                catch (OperatorCreationException e) {
                    throw new OperatorException("Could not create FlattenClusterModel Operator:", e.getCause());
                }
            }
            Attribute clusterAttribute = exampleSet.getAttributes().getCluster();
            if (clusterAttribute != null) {
                exampleSet.getAttributes().remove(clusterAttribute);
            }
            return new IOObject[]{model};
        }
        return new IOObject[]{model};
    }

    private int descent(ExampleSet exampleSet, HierarchicalClusterNode elter, int depth, int maxLeafSize, int maxDepth) throws OperatorException {
        Tools.checkAndCreateIds(exampleSet);
        IOContainer container = this.getOperator(0).apply(new IOContainer(exampleSet));
        ClusterModel currentModel = container.get(ClusterModel.class);
        int[] clusterAssignments = currentModel.getClusterAssignments(exampleSet);
        Partition partition = new Partition(clusterAssignments, currentModel.getNumberOfClusters());
        SplittedExampleSet splittedSet = new SplittedExampleSet(exampleSet, partition);
        int numberOfCreatedLeafs = 0;
        int i = 0;
        while (i < currentModel.getNumberOfClusters()) {
            splittedSet.selectSingleSubset(i);
            if (splittedSet.size() > maxLeafSize && depth < maxDepth) {
                HierarchicalClusterNode node = new HierarchicalClusterNode(String.valueOf(depth) + ":" + i);
                elter.addSubNode(node);
                numberOfCreatedLeafs += this.descent(splittedSet, node, depth + 1, maxLeafSize, maxDepth);
            } else {
                LinkedList<Object> exampleIds = new LinkedList<Object>();
                Attribute id = splittedSet.getAttributes().getId();
                if (id.isNominal()) {
                    for (Example example : splittedSet) {
                        exampleIds.add(example.getValueAsString(id));
                    }
                } else {
                    for (Example example : splittedSet) {
                        exampleIds.add(example.getValue(id));
                    }
                }
                HierarchicalClusterLeafNode leaf = new HierarchicalClusterLeafNode(String.valueOf(depth) + ":" + i, exampleIds);
                elter.addSubNode(leaf);
                ++numberOfCreatedLeafs;
            }
            ++i;
        }
        return numberOfCreatedLeafs;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{HierarchicalClusterModel.class};
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_CREATE_CLUSTER_LABEL, "Specifies if a cluster label should be created.", true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, "keep_example_set", false, true));
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_MAX_LEAF_SIZE, "The maximal number of items in each cluster leaf.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeInt(PARAMETER_MAX_DEPTH, "The maximal depth of cluster tree.", 1, Integer.MAX_VALUE, 5));
        return types;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new AllInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{ClusterModel.class});
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }
}

