/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.selection.BoltzmannSelection;
import com.rapidminer.operator.features.selection.CutSelection;
import com.rapidminer.operator.features.selection.NonDominatedSortingSelection;
import com.rapidminer.operator.features.selection.RankSelection;
import com.rapidminer.operator.features.selection.RouletteWheel;
import com.rapidminer.operator.features.selection.SaveIntermediateWeights;
import com.rapidminer.operator.features.selection.StochasticUniversalSampling;
import com.rapidminer.operator.features.selection.TournamentSelection;
import com.rapidminer.operator.features.selection.UniformSelection;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGeneticAlgorithm
extends FeatureOperator {
    public static final String PARAMETER_POPULATION_SIZE = "population_size";
    public static final String PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS = "maximum_number_of_generations";
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_SELECTION_SCHEME = "selection_scheme";
    public static final String PARAMETER_TOURNAMENT_SIZE = "tournament_size";
    public static final String PARAMETER_START_TEMPERATURE = "start_temperature";
    public static final String PARAMETER_DYNAMIC_SELECTION_PRESSURE = "dynamic_selection_pressure";
    public static final String PARAMETER_KEEP_BEST_INDIVIDUAL = "keep_best_individual";
    public static final String PARAMETER_SAVE_INTERMEDIATE_WEIGHTS = "save_intermediate_weights";
    public static final String PARAMETER_INTERMEDIATE_WEIGHTS_GENERATIONS = "intermediate_weights_generations";
    public static final String PARAMETER_INTERMEDIATE_WEIGHTS_FILE = "intermediate_weights_file";
    public static final String[] SELECTION_SCHEMES = new String[]{"uniform", "cut", "roulette wheel", "stochastic universal sampling", "Boltzmann", "rank", "tournament", "non dominated sorting"};
    public static final int UNIFORM_SELECTION = 0;
    public static final int CUT_SELECTION = 1;
    public static final int ROULETTE_WHEEL = 2;
    public static final int STOCHASTIC_UNIVERSAL = 3;
    public static final int BOLTZMANN_SELECTION = 4;
    public static final int RANK_SELECTION = 5;
    public static final int TOURNAMENT_SELECTION = 6;
    public static final int NON_DOMINATED_SORTING_SELECTION = 7;
    private int numberOfIndividuals;
    private int maxGen;
    private int generationsWithoutImproval;

    public AbstractGeneticAlgorithm(OperatorDescription description) {
        super(description);
    }

    protected abstract PopulationOperator getMutationPopulationOperator(ExampleSet var1) throws OperatorException;

    protected abstract PopulationOperator getCrossoverPopulationOperator(ExampleSet var1) throws OperatorException;

    protected List<PopulationOperator> getPreProcessingPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    protected List<PopulationOperator> getPostProcessingPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public final List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        PopulationOperator mutation;
        LinkedList<PopulationOperator> preOp = new LinkedList<PopulationOperator>();
        PopulationOperator crossover = this.getCrossoverPopulationOperator(input);
        if (crossover != null) {
            preOp.add(crossover);
        }
        if ((mutation = this.getMutationPopulationOperator(input)) != null) {
            preOp.add(mutation);
        }
        preOp.addAll(this.getPreProcessingPopulationOperators(input));
        return preOp;
    }

    @Override
    public final List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        LinkedList<PopulationOperator> postOp = new LinkedList<PopulationOperator>();
        this.numberOfIndividuals = this.getParameterAsInt(PARAMETER_POPULATION_SIZE);
        this.maxGen = this.getParameterAsInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS);
        this.generationsWithoutImproval = this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL);
        if (this.generationsWithoutImproval < 1) {
            this.generationsWithoutImproval = this.maxGen;
        }
        boolean keepBest = this.getParameterAsBoolean(PARAMETER_KEEP_BEST_INDIVIDUAL);
        boolean dynamicSelection = this.getParameterAsBoolean(PARAMETER_DYNAMIC_SELECTION_PRESSURE);
        int selectionScheme = this.getParameterAsInt(PARAMETER_SELECTION_SCHEME);
        switch (selectionScheme) {
            case 0: {
                postOp.add(new UniformSelection(this.numberOfIndividuals, keepBest, this.getRandom()));
                break;
            }
            case 1: {
                postOp.add(new CutSelection(this.numberOfIndividuals));
                break;
            }
            case 2: {
                postOp.add(new RouletteWheel(this.numberOfIndividuals, keepBest, this.getRandom()));
                break;
            }
            case 3: {
                postOp.add(new StochasticUniversalSampling(this.numberOfIndividuals, keepBest, this.getRandom()));
                break;
            }
            case 4: {
                postOp.add(new BoltzmannSelection(this.numberOfIndividuals, this.getParameterAsDouble(PARAMETER_START_TEMPERATURE), this.maxGen, dynamicSelection, keepBest, this.getRandom()));
                break;
            }
            case 5: {
                postOp.add(new RankSelection(this.numberOfIndividuals, keepBest, this.getRandom()));
                break;
            }
            case 6: {
                postOp.add(new TournamentSelection(this.numberOfIndividuals, this.getParameterAsDouble(PARAMETER_TOURNAMENT_SIZE), this.maxGen, dynamicSelection, keepBest, this.getRandom()));
                break;
            }
            case 7: {
                postOp.add(new NonDominatedSortingSelection(this.numberOfIndividuals));
                this.setCheckForMaximum(false);
                break;
            }
        }
        if (this.getParameterAsBoolean(PARAMETER_SAVE_INTERMEDIATE_WEIGHTS)) {
            File file = this.getParameterAsFile(PARAMETER_INTERMEDIATE_WEIGHTS_FILE, true);
            if (file != null) {
                postOp.add(new SaveIntermediateWeights(this, this.getParameterAsInt(PARAMETER_INTERMEDIATE_WEIGHTS_GENERATIONS), Tools.getRegularAttributeNames(input)));
            } else {
                this.logWarning("The parameter 'save_intermediate_weights' was set but no file was specified: ignoring.");
            }
        }
        postOp.addAll(this.getPostProcessingPopulationOperators(input));
        return postOp;
    }

    @Override
    public boolean solutionGoodEnough(Population pop) {
        return pop.getGeneration() >= this.maxGen || pop.getGenerationsWithoutImproval() >= this.generationsWithoutImproval;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt(PARAMETER_POPULATION_SIZE, "Number of individuals per generation.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAXIMUM_NUMBER_OF_GENERATIONS, "Number of generations after which to terminate the algorithm.", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop criterion: Stop after n generations without improval of the performance (-1: perform all generations).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory(PARAMETER_SELECTION_SCHEME, "The selection scheme of this EA.", SELECTION_SCHEMES, 6));
        types.add(new ParameterTypeDouble(PARAMETER_TOURNAMENT_SIZE, "The fraction of the current population which should be used as tournament members (only tournament selection).", 0.0, 1.0, 0.25));
        types.add(new ParameterTypeDouble(PARAMETER_START_TEMPERATURE, "The scaling temperature (only Boltzmann selection).", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean(PARAMETER_DYNAMIC_SELECTION_PRESSURE, "If set to true the selection pressure is increased to maximum during the complete optimization run (only Boltzmann and tournament selection).", true));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_BEST_INDIVIDUAL, "If set to true, the best individual of each generations is guaranteed to be selected for the next generation (elitist selection).", false));
        types.add(new ParameterTypeBoolean(PARAMETER_SAVE_INTERMEDIATE_WEIGHTS, "Determines if the intermediate best results should be saved.", false));
        type = new ParameterTypeInt(PARAMETER_INTERMEDIATE_WEIGHTS_GENERATIONS, "Determines if the intermediate best results should be saved. Will be performed every k generations for a specified value of k.", 1, Integer.MAX_VALUE, 10);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_SAVE_INTERMEDIATE_WEIGHTS, false, true));
        types.add(type);
        type = new ParameterTypeFile(PARAMETER_INTERMEDIATE_WEIGHTS_FILE, "The file into which the intermediate weights will be saved.", "wgt", true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_SAVE_INTERMEDIATE_WEIGHTS, true, true));
        types.add(type);
        return types;
    }
}

