/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.selection.IterativeFeatureAdding;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightGuidedSelectionOperator
extends FeatureOperator {
    public static final String PARAMETER_GENERATIONS_WITHOUT_IMPROVAL = "generations_without_improval";
    public static final String PARAMETER_USE_ABSOLUTE_WEIGHTS = "use_absolute_weights";
    private int generationsWOImp;
    private int maxGenerations;
    private int maxWeightIndex = -1;

    public WeightGuidedSelectionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) throws UndefinedParameterError {
        this.generationsWOImp = this.getParameterAsInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL);
        this.maxGenerations = es.getAttributes().size();
        Population initP = new Population();
        double[] weights = new double[es.getAttributes().size()];
        if (this.maxWeightIndex >= 0) {
            weights[this.maxWeightIndex] = 1.0;
        } else {
            weights[0] = 1.0;
        }
        initP.add(new Individual(weights));
        return initP;
    }

    @Override
    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        LinkedList<PopulationOperator> preOp = new LinkedList<PopulationOperator>();
        String[] attributeNames = Tools.getRegularAttributeNames(input);
        AttributeWeights attributeWeights = this.getInput(AttributeWeights.class);
        attributeWeights.sortByWeight(attributeNames, 1, this.getParameterAsBoolean(PARAMETER_USE_ABSOLUTE_WEIGHTS) ? 1 : 0);
        int[] attributeIndices = new int[input.getAttributes().size()];
        int counter = 0;
        String[] stringArray = attributeNames;
        int n = attributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            int index = 0;
            for (Attribute attribute : input.getAttributes()) {
                if (attribute.getName().equals(name)) {
                    attributeIndices[counter] = index;
                    break;
                }
                ++index;
            }
            ++counter;
            ++n2;
        }
        this.maxWeightIndex = attributeIndices[0];
        preOp.add(new IterativeFeatureAdding(attributeIndices, 1));
        return preOp;
    }

    @Override
    public List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public boolean solutionGoodEnough(Population pop) throws OperatorException {
        return pop.empty() || this.generationsWOImp > 0 && pop.getGenerationsWithoutImproval() >= this.generationsWOImp || pop.getGeneration() >= this.maxGenerations;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_GENERATIONS_WITHOUT_IMPROVAL, "Stop after n generations without improval of the performance (-1: stops if the number of features is reached).", -1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_ABSOLUTE_WEIGHTS, "Indicates that the absolute values of the input weights should be used to determine the feature adding order.", true));
        return types;
    }
}

