/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.transformation.PCA;
import com.rapidminer.operator.features.weighting.AbstractWeighting;
import com.rapidminer.operator.features.weighting.ComponentWeights;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorService;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCAWeighting
extends AbstractWeighting {
    public PCAWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public AttributeWeights calculateWeights(ExampleSet exampleSet) throws OperatorException {
        PCA pcaOperator = null;
        try {
            pcaOperator = OperatorService.createOperator(PCA.class);
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 904, "inner pca operator", e.getMessage());
        }
        pcaOperator.setParameter("dimensionality_reduction", "0");
        ComponentWeights weightOperator = null;
        try {
            weightOperator = OperatorService.createOperator(ComponentWeights.class);
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 904, "inner weight operator", e.getMessage());
        }
        weightOperator.setParameter("component_number", String.valueOf(this.getParameterAsInt("component_number")));
        IOContainer ioContainer = new IOContainer(exampleSet);
        ioContainer = pcaOperator.apply(ioContainer);
        ioContainer = weightOperator.apply(ioContainer);
        AttributeWeights result = ioContainer.remove(AttributeWeights.class);
        result.setSource(this.getName());
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt("component_number", "Indicates the number of the component from which the weights should be calculated.", 1, Integer.MAX_VALUE, 1));
        return types;
    }
}

