/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DatabaseExampleTable;
import com.rapidminer.gui.wizards.DBExampleSourceConfigurationWizardCreator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.ResultSetExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.DatabaseService;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseExampleSource
extends ResultSetExampleSource {
    public static final String PARAMETER_WORK_ON_DATABASE = "work_on_database";
    public static final String PARAMETER_DATABASE_SYSTEM = "database_system";
    public static final String PARAMETER_DATABASE_URL = "database_url";
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_QUERY = "query";
    public static final String PARAMETER_QUERY_FILE = "query_file";
    public static final String PARAMETER_TABLE_NAME = "table_name";
    public static final String PARAMETER_CLASSES = "classes";
    private DatabaseHandler databaseHandler;
    private Statement statement;

    public DatabaseExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        if (!this.getParameterAsBoolean(PARAMETER_WORK_ON_DATABASE)) {
            ExampleSet output = super.createExampleSet();
            this.disconnect();
            return output;
        }
        try {
            String tableName = this.getParameterAsString(PARAMETER_TABLE_NAME);
            if (tableName == null) {
                throw new UserError((Operator)this, 201, PARAMETER_TABLE_NAME, PARAMETER_WORK_ON_DATABASE, "true");
            }
            DatabaseExampleTable table = DatabaseExampleTable.createDatabaseExampleTable(this.getConnectedDatabaseHandler(), tableName);
            ExampleSet exampleSet = DatabaseExampleSource.createExampleSet(table, this);
            exampleSet.recalculateAllAttributeStatistics();
            return exampleSet;
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, e.getMessage());
        }
    }

    @Override
    public void tearDown() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                this.logWarning("Cannot close statement.");
            }
            this.statement = null;
        }
    }

    public void setNominalValues(List attributeList, ResultSet resultSet, Attribute label) throws UndefinedParameterError {
        this.setNominalValuesForLabel(label);
    }

    private void setNominalValuesForLabel(Attribute label) throws UndefinedParameterError {
        if (label != null) {
            String classes = this.getParameterAsString(PARAMETER_CLASSES);
            if (label.isNominal()) {
                if (classes != null) {
                    String[] labelClasses = classes.split(" ");
                    int i = 0;
                    while (i < labelClasses.length) {
                        label.getMapping().mapString(labelClasses[i].trim());
                        ++i;
                    }
                }
            } else if (classes != null && classes.length() > 0) {
                this.logWarning("Ignoring classes for non-nominal attribute " + label.getName() + ".");
            }
        }
    }

    private String getQuery() throws OperatorException {
        String query = this.getParameterAsString(PARAMETER_QUERY);
        if (query != null) {
            query = query.trim();
        }
        String parameterUsed = null;
        boolean warning = false;
        if (query == null || query.length() == 0) {
            File queryFile = this.getParameterAsFile(PARAMETER_QUERY_FILE);
            if (queryFile != null) {
                try {
                    query = Tools.readTextFile(queryFile);
                    parameterUsed = PARAMETER_QUERY_FILE;
                }
                catch (IOException ioe) {
                    throw new UserError((Operator)this, (Throwable)ioe, 302, queryFile, ioe.getMessage());
                }
                if (query == null || query.trim().length() == 0) {
                    throw new UserError((Operator)this, 205, queryFile);
                }
            }
        } else {
            parameterUsed = PARAMETER_QUERY;
            if (this.isParameterSet(PARAMETER_QUERY_FILE)) {
                warning = true;
            }
        }
        if (query == null || query.trim().length() == 0) {
            if (this.isParameterSet(PARAMETER_TABLE_NAME)) {
                query = "SELECT * FROM " + this.getParameterAsString(PARAMETER_TABLE_NAME);
                parameterUsed = PARAMETER_TABLE_NAME;
            }
        } else if (this.isParameterSet(PARAMETER_TABLE_NAME)) {
            warning = true;
        }
        if (query == null) {
            throw new UserError((Operator)this, 202, PARAMETER_QUERY, PARAMETER_QUERY_FILE, PARAMETER_TABLE_NAME);
        }
        if (warning) {
            this.logWarning("Only one of the parameters 'query', 'query_file', and 'table_name' have to be set. Using value of '" + parameterUsed + "'.");
        }
        return query;
    }

    protected DatabaseHandler getConnectedDatabaseHandler() throws OperatorException, SQLException {
        String databaseURL = this.getParameterAsString(PARAMETER_DATABASE_URL);
        String username = this.getParameterAsString(PARAMETER_USERNAME);
        String password = this.getParameterAsString(PARAMETER_PASSWORD);
        return DatabaseHandler.getConnectedDatabaseHandler(databaseURL, username, password, DatabaseService.getJDBCProperties().get(this.getParameterAsInt(PARAMETER_DATABASE_SYSTEM)), this);
    }

    @Override
    public ResultSet getResultSet() throws OperatorException {
        ResultSet rs = null;
        try {
            this.databaseHandler = this.getConnectedDatabaseHandler();
            String query = this.getQuery();
            this.log("Executing query: '" + query + "'");
            this.statement = this.databaseHandler.createStatement(false);
            rs = this.statement.executeQuery(query);
            this.log("Query executed.");
        }
        catch (SQLException sqle) {
            throw new UserError((Operator)this, (Throwable)sqle, 304, sqle.getMessage());
        }
        return rs;
    }

    @Override
    public void processFinished() {
        this.disconnect();
    }

    private void disconnect() {
        this.tearDown();
        if (this.databaseHandler != null) {
            try {
                this.databaseHandler.disconnect();
                this.databaseHandler = null;
            }
            catch (SQLException e) {
                this.logWarning("Cannot disconnect from database: " + e);
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        HashMap<String, String> wizardParameters = new HashMap<String, String>();
        wizardParameters.put("only_table_name", "false");
        wizardParameters.put("show_database_configuration", "true");
        ParameterType type = new ParameterTypeConfiguration(DBExampleSourceConfigurationWizardCreator.class, wizardParameters, this);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_WORK_ON_DATABASE, "(EXPERIMENTAL!) If set to true, the data read from the database is NOT copied to main memory. All operations that change data will modify the database.", false));
        type = new ParameterTypeCategory(PARAMETER_DATABASE_SYSTEM, "Indicates the used database system", DatabaseService.getDBSystemNames(), 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_DATABASE_URL, "The complete URL connection string for the database, e.g. 'jdbc:mysql://foo.bar:portnr/database'", false));
        types.add(new ParameterTypeString(PARAMETER_USERNAME, "Database username.", false));
        types.add(new ParameterTypePassword(PARAMETER_PASSWORD, "Password for the database."));
        type = new ParameterTypeText(PARAMETER_QUERY, "SQL query. If not set, the query is read from the file specified by 'query_file'.", TextType.SQL);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile(PARAMETER_QUERY_FILE, "File containing the query. Only evaluated if 'query' is not set.", null, true));
        types.add(new ParameterTypeString(PARAMETER_TABLE_NAME, "Use this table if work_on_database is true or no other query is specified."));
        types.addAll(super.getParameterTypes());
        types.add(new ParameterTypeString(PARAMETER_CLASSES, "Whitespace separated list of possible class values of the label attribute."));
        return types;
    }
}

