/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.associations.fpgrowth;

import com.rapidminer.operator.learner.associations.Item;
import com.rapidminer.operator.learner.associations.fpgrowth.FrequencyStack;
import com.rapidminer.operator.learner.associations.fpgrowth.Header;
import com.rapidminer.operator.learner.associations.fpgrowth.ListFrequencyStack;
import com.rapidminer.tools.Tools;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FPTreeNode {
    protected FrequencyStack frequencies = new ListFrequencyStack();
    protected Item nodeItem;
    protected FPTreeNode sibling;
    protected FPTreeNode father;
    protected Map<Item, FPTreeNode> children;

    public FPTreeNode() {
        this.children = new LinkedHashMap<Item, FPTreeNode>();
    }

    public FPTreeNode(FPTreeNode father, Item nodeItem) {
        this.father = father;
        this.children = new HashMap<Item, FPTreeNode>();
        this.nodeItem = nodeItem;
    }

    public void addItemSet(Collection<Item> itemSet, Map<Item, Header> headerTable, int weight) {
        Iterator<Item> iterator = itemSet.iterator();
        if (iterator.hasNext()) {
            FPTreeNode childNode;
            Item firstItem = iterator.next();
            if (!this.children.containsKey(firstItem)) {
                childNode = this.createChildNode(firstItem);
                this.children.put(firstItem, childNode);
                if (!headerTable.containsKey(firstItem)) {
                    headerTable.put(firstItem, new Header());
                }
                headerTable.get(firstItem).addSibling(childNode);
            } else {
                childNode = this.children.get(firstItem);
            }
            headerTable.get((Object)firstItem).frequencies.increaseFrequency(0, weight);
            childNode.increaseFrequency(0, weight);
            itemSet.remove(firstItem);
            childNode.addItemSet(itemSet, headerTable, weight);
        }
    }

    public FPTreeNode getFather() {
        return this.father;
    }

    public boolean hasFather() {
        return this.father != null;
    }

    public FPTreeNode getSibling() {
        return this.sibling;
    }

    public FPTreeNode getLastSibling() {
        FPTreeNode currentNode = this;
        while (currentNode.hasSibling()) {
            currentNode = currentNode.getSibling();
        }
        return currentNode;
    }

    public void setSibling(FPTreeNode sibling) {
        this.sibling = sibling;
    }

    public boolean hasSibling() {
        return this.sibling != null;
    }

    public void increaseFrequency(int recursionDepth, int value) {
        this.frequencies.increaseFrequency(recursionDepth, value);
    }

    public void popFrequency(int height) {
        this.frequencies.popFrequency(height);
    }

    public int getFrequency(int height) {
        return this.frequencies.getFrequency(height);
    }

    public Item getNodeItem() {
        return this.nodeItem;
    }

    public Map<Item, FPTreeNode> getChildren() {
        return this.children;
    }

    public FPTreeNode getChild() {
        if (this.children.size() != 1) {
            return null;
        }
        return this.children.get(this.children.keySet().iterator().next());
    }

    public FPTreeNode createChildNode(Item nodeItem) {
        return new FPTreeNode(this, nodeItem);
    }

    public String toString(int recursionDepth) {
        return this.toString("", recursionDepth);
    }

    public String toString(String abs, int recursionDepth) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(abs);
        buffer.append("+ ");
        buffer.append(this.nodeItem.toString());
        buffer.append(" (");
        buffer.append(this.frequencies.getFrequency(recursionDepth));
        buffer.append(")");
        buffer.append(Tools.getLineSeparator());
        for (FPTreeNode node : this.children.values()) {
            buffer.append(node.toString(String.valueOf(abs) + "  ", recursionDepth));
        }
        return buffer.toString();
    }
}

