/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.bayes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.plotter.charts.DistributionPlotter;
import com.rapidminer.gui.tools.JRadioSelectionPanel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.learner.bayes.DistributionModel;
import com.rapidminer.report.Renderable;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.distribution.DiscreteDistribution;
import com.rapidminer.tools.math.distribution.Distribution;
import com.rapidminer.tools.math.distribution.NormalDistribution;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDistributionModel
extends DistributionModel
implements Renderable {
    private static final long serialVersionUID = -402827845291958569L;
    private static final String UNKNOWN_VALUE_NAME = "unknown";
    private static final int INDEX_COUNT = 0;
    private static final int INDEX_VALUE_SUM = 1;
    private static final int INDEX_SQUARED_VALUE_SUM = 2;
    private static final int INDEX_MISSING_WEIGHTS = 3;
    private static final int INDEX_MEAN = 0;
    private static final int INDEX_STANDARD_DEVIATION = 1;
    private static final int INDEX_LOG_FACTOR = 2;
    private int numberOfClasses;
    private int numberOfAttributes;
    private boolean[] nominal;
    private String className;
    private String[] classValues;
    private String[] attributeNames;
    private String[][] attributeValues;
    private double totalWeight;
    private double[] classWeights;
    private double[][][] weightSums;
    private double[] priors;
    private double[][][] distributionProperties;
    boolean laplaceCorrectionEnabled;
    private boolean modelRecentlyUpdated;
    private transient DistributionPlotter plotter;

    public SimpleDistributionModel(ExampleSet exampleSet) {
        this(exampleSet, true);
    }

    public SimpleDistributionModel(ExampleSet exampleSet, boolean laplaceCorrectionEnabled) {
        super(exampleSet);
        this.laplaceCorrectionEnabled = laplaceCorrectionEnabled;
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        this.numberOfClasses = labelAttribute.getMapping().size();
        this.numberOfAttributes = exampleSet.getAttributes().size();
        this.nominal = new boolean[this.numberOfAttributes];
        this.attributeNames = new String[this.numberOfAttributes];
        this.attributeValues = new String[this.numberOfAttributes][];
        this.className = labelAttribute.getName();
        this.classValues = new String[this.numberOfClasses];
        int i = 0;
        while (i < this.numberOfClasses) {
            this.classValues[i] = labelAttribute.getMapping().mapIndex(i);
            ++i;
        }
        int attributeIndex = 0;
        this.weightSums = new double[this.numberOfAttributes][this.numberOfClasses][];
        this.distributionProperties = new double[this.numberOfAttributes][this.numberOfClasses][];
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.attributeNames[attributeIndex] = attribute.getName();
            if (attribute.isNominal()) {
                this.nominal[attributeIndex] = true;
                int mappingSize = attribute.getMapping().size() + 1;
                this.attributeValues[attributeIndex] = new String[mappingSize];
                int i2 = 0;
                while (i2 < mappingSize - 1) {
                    this.attributeValues[attributeIndex][i2] = attribute.getMapping().mapIndex(i2);
                    ++i2;
                }
                this.attributeValues[attributeIndex][mappingSize - 1] = UNKNOWN_VALUE_NAME;
                i2 = 0;
                while (i2 < this.numberOfClasses) {
                    this.weightSums[attributeIndex][i2] = new double[mappingSize];
                    this.distributionProperties[attributeIndex][i2] = new double[mappingSize];
                    ++i2;
                }
            } else {
                this.nominal[attributeIndex] = false;
                int i3 = 0;
                while (i3 < this.numberOfClasses) {
                    this.weightSums[attributeIndex][i3] = new double[4];
                    this.distributionProperties[attributeIndex][i3] = new double[3];
                    ++i3;
                }
            }
            ++attributeIndex;
        }
        this.totalWeight = 0.0;
        this.classWeights = new double[this.numberOfClasses];
        this.priors = new double[this.numberOfClasses];
        this.updateModel(exampleSet);
        this.updateDistributionProperties();
    }

    @Override
    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    @Override
    public int getNumberOfAttributes() {
        return this.attributeNames.length;
    }

    @Override
    public void updateModel(ExampleSet exampleSet) {
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        for (Example example : exampleSet) {
            int classIndex;
            double weight = weightAttribute == null ? 1.0 : example.getWeight();
            this.totalWeight += weight;
            double labelValue = example.getLabel();
            if (Double.isNaN(labelValue)) continue;
            int n = classIndex = (int)example.getLabel();
            this.classWeights[n] = this.classWeights[n] + weight;
            int attributeIndex = 0;
            for (Attribute attribute : exampleSet.getAttributes()) {
                double attributeValue = example.getValue(attribute);
                if (this.nominal[attributeIndex]) {
                    if (!Double.isNaN(attributeValue)) {
                        if ((int)attributeValue < this.weightSums[attributeIndex][classIndex].length - 1) {
                            double[] dArray = this.weightSums[attributeIndex][classIndex];
                            int n2 = (int)attributeValue;
                            dArray[n2] = dArray[n2] + weight;
                        } else {
                            int i = 0;
                            while (i < this.numberOfClasses) {
                                double[] newWeightSums = new double[(int)attributeValue + 2];
                                newWeightSums[newWeightSums.length - 1] = this.weightSums[attributeIndex][i][this.weightSums[attributeIndex][i].length - 1];
                                int j = 0;
                                while (j < this.weightSums[attributeIndex][i].length - 1) {
                                    newWeightSums[j] = this.weightSums[attributeIndex][i][j];
                                    ++j;
                                }
                                this.weightSums[attributeIndex][i] = newWeightSums;
                                this.distributionProperties[attributeIndex][i] = new double[(int)attributeValue + 2];
                                ++i;
                            }
                            double[] dArray = this.weightSums[attributeIndex][classIndex];
                            int n3 = (int)attributeValue;
                            dArray[n3] = dArray[n3] + weight;
                            this.attributeValues[attributeIndex] = new String[(int)attributeValue + 2];
                            i = 0;
                            while (i < this.attributeValues[attributeIndex].length - 1) {
                                this.attributeValues[attributeIndex][i] = attribute.getMapping().mapIndex(i);
                                ++i;
                            }
                            this.attributeValues[attributeIndex][this.attributeValues[attributeIndex].length - 1] = UNKNOWN_VALUE_NAME;
                        }
                    } else {
                        double[] dArray = this.weightSums[attributeIndex][classIndex];
                        int n4 = this.weightSums[attributeIndex][classIndex].length - 1;
                        dArray[n4] = dArray[n4] + weight;
                    }
                } else if (!Double.isNaN(attributeValue)) {
                    double[] dArray = this.weightSums[attributeIndex][classIndex];
                    dArray[0] = dArray[0] + 1.0;
                    double[] dArray2 = this.weightSums[attributeIndex][classIndex];
                    dArray2[1] = dArray2[1] + weight * attributeValue;
                    double[] dArray3 = this.weightSums[attributeIndex][classIndex];
                    dArray3[2] = dArray3[2] + weight * attributeValue * attributeValue;
                } else {
                    double[] dArray = this.weightSums[attributeIndex][classIndex];
                    dArray[3] = dArray[3] + weight;
                }
                ++attributeIndex;
            }
        }
        this.modelRecentlyUpdated = true;
    }

    private void updateDistributionProperties() {
        double f = this.laplaceCorrectionEnabled ? 1.0 / this.totalWeight : Double.MIN_VALUE;
        double logFactorCoefficient = Math.sqrt(Math.PI * 2);
        int i = 0;
        while (i < this.numberOfClasses) {
            this.priors[i] = Math.log(this.classWeights[i] / this.totalWeight);
            ++i;
        }
        i = 0;
        while (i < this.numberOfAttributes) {
            int j;
            if (this.nominal[i]) {
                j = 0;
                while (j < this.numberOfClasses) {
                    int k = 0;
                    while (k < this.weightSums[i][j].length) {
                        this.distributionProperties[i][j][k] = Math.log((this.weightSums[i][j][k] + f) / (this.classWeights[j] + f * (double)this.weightSums[i][j].length));
                        ++k;
                    }
                    ++j;
                }
            } else {
                j = 0;
                while (j < this.numberOfClasses) {
                    double classWeight = this.classWeights[j] - this.weightSums[i][j][3];
                    this.distributionProperties[i][j][0] = this.weightSums[i][j][1] / classWeight;
                    double standardDeviation = Math.sqrt((this.weightSums[i][j][2] - this.weightSums[i][j][1] * this.weightSums[i][j][1] / classWeight) / ((this.weightSums[i][j][0] - 1.0) / this.weightSums[i][j][0] * classWeight));
                    if (Double.isNaN(standardDeviation) || standardDeviation <= 0.001) {
                        standardDeviation = 0.001;
                    }
                    this.distributionProperties[i][j][1] = standardDeviation;
                    this.distributionProperties[i][j][2] = Math.log(this.distributionProperties[i][j][1] * logFactorCoefficient);
                    ++j;
                }
            }
            ++i;
        }
        this.modelRecentlyUpdated = false;
    }

    public ExampleSet performPredictionOld(ExampleSet exampleSet, Attribute predictedLabel) {
        if (this.modelRecentlyUpdated) {
            this.updateDistributionProperties();
        }
        for (Example example : exampleSet) {
            double[] probabilities = new double[this.numberOfClasses];
            double maxLogProbability = Double.NEGATIVE_INFINITY;
            double probabilitySum = 0.0;
            int mostProbableClass = 0;
            int i = 0;
            while (i < this.numberOfClasses) {
                double logProbability = this.priors[i];
                if (!Double.isNaN(logProbability)) {
                    int j = 0;
                    for (Attribute attribute : exampleSet.getAttributes()) {
                        double value = example.getValue(attribute);
                        if (this.nominal[j]) {
                            logProbability = !Double.isNaN(value) && (int)value < this.distributionProperties[j][i].length ? (logProbability += this.distributionProperties[j][i][(int)value]) : (logProbability += this.distributionProperties[j][i][this.distributionProperties[j][i].length - 1]);
                        } else if (!Double.isNaN(value)) {
                            double base = (value - this.distributionProperties[j][i][0]) / this.distributionProperties[j][i][1];
                            logProbability -= this.distributionProperties[j][i][2] + 0.5 * (base * base);
                        }
                        ++j;
                    }
                    if (logProbability > maxLogProbability) {
                        maxLogProbability = logProbability;
                        mostProbableClass = i;
                    }
                    probabilities[i] = logProbability;
                } else {
                    probabilities[i] = Double.NaN;
                }
                ++i;
            }
            i = 0;
            while (i < this.numberOfClasses) {
                if (!Double.isNaN(probabilities[i])) {
                    probabilities[i] = Math.exp(probabilities[i] - maxLogProbability);
                    probabilitySum += probabilities[i];
                } else {
                    probabilities[i] = 0.0;
                }
                ++i;
            }
            if (maxLogProbability == Double.NEGATIVE_INFINITY) {
                example.setPredictedLabel(Double.NaN);
                i = 0;
                while (i < this.numberOfClasses) {
                    example.setConfidence(this.classValues[i], Double.NaN);
                    ++i;
                }
                continue;
            }
            example.setPredictedLabel(mostProbableClass);
            i = 0;
            while (i < this.numberOfClasses) {
                example.setConfidence(this.classValues[i], probabilities[i] / probabilitySum);
                ++i;
            }
        }
        return exampleSet;
    }

    @Override
    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) {
        if (this.modelRecentlyUpdated) {
            this.updateDistributionProperties();
        }
        double[] probabilities = new double[this.numberOfClasses];
        for (Example example : exampleSet) {
            double maxLogProbability = Double.NEGATIVE_INFINITY;
            double probabilitySum = 0.0;
            int mostProbableClass = 0;
            int j = 0;
            int i = 0;
            while (i < this.numberOfClasses) {
                probabilities[i] = this.priors[i];
                ++i;
            }
            for (Attribute attribute : exampleSet.getAttributes()) {
                int i2;
                double value = example.getValue(attribute);
                if (this.nominal[j]) {
                    if (!Double.isNaN(value)) {
                        int intValue = (int)value;
                        int i3 = 0;
                        while (i3 < this.numberOfClasses) {
                            if (intValue < this.distributionProperties[j][i3].length) {
                                int n = i3;
                                probabilities[n] = probabilities[n] + this.distributionProperties[j][i3][intValue];
                            }
                            ++i3;
                        }
                    } else {
                        i2 = 0;
                        while (i2 < this.numberOfClasses) {
                            int n = i2;
                            probabilities[n] = probabilities[n] + this.distributionProperties[j][i2][this.distributionProperties[j][i2].length - 1];
                            ++i2;
                        }
                    }
                } else if (!Double.isNaN(value)) {
                    i2 = 0;
                    while (i2 < this.numberOfClasses) {
                        double base = (value - this.distributionProperties[j][i2][0]) / this.distributionProperties[j][i2][1];
                        int n = i2;
                        probabilities[n] = probabilities[n] - (this.distributionProperties[j][i2][2] + 0.5 * base * base);
                        ++i2;
                    }
                }
                ++j;
            }
            i = 0;
            while (i < this.numberOfClasses) {
                if (!Double.isNaN(probabilities[i]) && probabilities[i] > maxLogProbability) {
                    maxLogProbability = probabilities[i];
                    mostProbableClass = i;
                }
                ++i;
            }
            i = 0;
            while (i < this.numberOfClasses) {
                if (!Double.isNaN(probabilities[i])) {
                    probabilities[i] = Math.exp(probabilities[i] - maxLogProbability);
                    probabilitySum += probabilities[i];
                } else {
                    probabilities[i] = 0.0;
                }
                ++i;
            }
            if (maxLogProbability == Double.NEGATIVE_INFINITY) {
                example.setPredictedLabel(Double.NaN);
                i = 0;
                while (i < this.numberOfClasses) {
                    example.setConfidence(this.classValues[i], Double.NaN);
                    ++i;
                }
                continue;
            }
            example.setPredictedLabel(mostProbableClass);
            i = 0;
            while (i < this.numberOfClasses) {
                example.setConfidence(this.classValues[i], probabilities[i] / probabilitySum);
                ++i;
            }
        }
        return exampleSet;
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    public void setLaplaceCorrectionEnabled(boolean laplaceCorrectionEnabled) {
        this.laplaceCorrectionEnabled = laplaceCorrectionEnabled;
    }

    public boolean getLaplaceCorrectionEnabled() {
        return this.laplaceCorrectionEnabled;
    }

    @Override
    public double getLowerBound(int attributeIndex) {
        if (!this.nominal[attributeIndex]) {
            double lowerBound = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < this.numberOfClasses) {
                double currentLowerBound = NormalDistribution.getLowerBound(this.distributionProperties[attributeIndex][i][0], this.distributionProperties[attributeIndex][i][1]);
                if (!Double.isNaN(currentLowerBound)) {
                    lowerBound = Math.min(lowerBound, currentLowerBound);
                }
                ++i;
            }
            return lowerBound;
        }
        return Double.NaN;
    }

    @Override
    public double getUpperBound(int attributeIndex) {
        if (!this.nominal[attributeIndex]) {
            double upperBound = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < this.numberOfClasses) {
                double currentUpperBound = NormalDistribution.getUpperBound(this.distributionProperties[attributeIndex][i][0], this.distributionProperties[attributeIndex][i][1]);
                if (!Double.isNaN(currentUpperBound)) {
                    upperBound = Math.max(upperBound, currentUpperBound);
                }
                ++i;
            }
            return upperBound;
        }
        return Double.NaN;
    }

    @Override
    public boolean isDiscrete(int attributeIndex) {
        if (attributeIndex >= 0 && attributeIndex < this.nominal.length) {
            return this.nominal[attributeIndex];
        }
        return false;
    }

    @Override
    public Collection<Integer> getClassIndices() {
        ArrayList<Integer> classValueIndices = new ArrayList<Integer>(this.numberOfClasses);
        int i = 0;
        while (i < this.numberOfClasses) {
            classValueIndices.add(i);
            ++i;
        }
        return classValueIndices;
    }

    @Override
    public int getNumberOfClasses() {
        return this.numberOfClasses;
    }

    @Override
    public String getClassName(int index) {
        return this.classValues[index];
    }

    @Override
    public Distribution getDistribution(int classIndex, int attributeIndex) {
        if (this.nominal[attributeIndex]) {
            double[] probabilities = new double[this.distributionProperties[attributeIndex][classIndex].length];
            int i = 0;
            while (i < probabilities.length) {
                probabilities[i] = Math.exp(this.distributionProperties[attributeIndex][classIndex][i]);
                ++i;
            }
            return new DiscreteDistribution(this.attributeNames[attributeIndex], probabilities, this.attributeValues[attributeIndex]);
        }
        return new NormalDistribution(this.distributionProperties[attributeIndex][classIndex][0], this.distributionProperties[attributeIndex][classIndex][1]);
    }

    @Override
    public Component getVisualizationComponent(IOContainer container) {
        if (this.modelRecentlyUpdated) {
            this.updateDistributionProperties();
        }
        JRadioSelectionPanel selectionPanel = new JRadioSelectionPanel();
        JPanel graphPanel = new JPanel(new BorderLayout());
        this.plotter = new DistributionPlotter(this);
        graphPanel.add((Component)this.plotter, "Center");
        final JComboBox<String> combo = new JComboBox<String>(this.attributeNames);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(4, 4, 4, 4);
        c.gridwidth = 0;
        JPanel boxPanel = new JPanel(layout);
        JLabel label = new JLabel("Attribute");
        layout.setConstraints(label, c);
        boxPanel.add(label);
        layout.setConstraints(combo, c);
        boxPanel.add(combo);
        c.weighty = 1.0;
        JPanel fillPanel = new JPanel();
        layout.setConstraints(fillPanel, c);
        boxPanel.add(fillPanel);
        graphPanel.add((Component)boxPanel, "West");
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SimpleDistributionModel.this.plotter.setPlotColumn(combo.getSelectedIndex(), true);
            }
        });
        combo.setSelectedIndex(0);
        selectionPanel.addComponent("Plot View", graphPanel, "Shows a graphical visualisation of the densitiy estimates.");
        selectionPanel.addComponent("Text View", super.getVisualizationComponent(container), "Shows a textual description of the estimated densities.");
        return selectionPanel;
    }

    @Override
    public void prepareRendering() {
        if (this.plotter == null) {
            this.plotter = new DistributionPlotter(this);
        }
        this.plotter.prepareRendering();
    }

    @Override
    public void finishRendering() {
        this.plotter.finishRendering();
        this.plotter = null;
    }

    @Override
    public int getRenderHeight(int preferredHeight) {
        return this.plotter.getRenderHeight(preferredHeight);
    }

    @Override
    public int getRenderWidth(int preferredWidth) {
        return this.plotter.getRenderWidth(preferredWidth);
    }

    @Override
    public void render(Graphics graphics, int width, int height) {
        this.plotter.setSize(width, height);
        this.plotter.paintComponent(graphics);
    }

    @Override
    public String toString() {
        if (this.modelRecentlyUpdated) {
            this.updateDistributionProperties();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Distribution model for label attribute " + this.className);
        buffer.append(Tools.getLineSeparators(2));
        int i = 0;
        while (i < this.numberOfClasses) {
            String classTitle = "Class " + this.classValues[i] + " (" + Tools.formatNumber(Math.exp(this.priors[i])) + ")";
            buffer.append(Tools.getLineSeparator());
            buffer.append(classTitle);
            buffer.append(Tools.getLineSeparator());
            buffer.append(String.valueOf(this.attributeNames.length) + " distributions");
            buffer.append(Tools.getLineSeparator());
            ++i;
        }
        return buffer.toString();
    }
}

